/*
 * Decompiled with CFR 0.152.
 */
package com.techempower;

import com.techempower.Version;
import com.techempower.asynchronous.Asynchronous;
import com.techempower.asynchronous.DeferredStartAsynchronous;
import com.techempower.log.BasicLog;
import com.techempower.log.ComponentLog;
import com.techempower.log.Log;
import com.techempower.log.LogWriterManager;
import com.techempower.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;

public class TechEmpowerApplication {
    private final Version version;
    private final Log rootLog;
    private final ComponentLog log;
    private final Scheduler scheduler;
    private final List<Asynchronous> asynchronousRscs = new ArrayList<Asynchronous>();
    private final List<DeferredStartAsynchronous> deferredRscs = new ArrayList<DeferredStartAsynchronous>();
    private final LogWriterManager logManager;

    public TechEmpowerApplication() {
        this.version = this.constructVersion();
        this.logManager = this.constructLogCloser();
        this.logManager.begin();
        this.rootLog = this.constructLog();
        this.log = this.getLog("teap");
        this.scheduler = this.constructScheduler();
    }

    protected Version constructVersion() {
        return new Version();
    }

    protected Log constructLog() {
        return new BasicLog(this);
    }

    protected Scheduler constructScheduler() {
        return new Scheduler(this);
    }

    protected LogWriterManager constructLogCloser() {
        return new LogWriterManager(this);
    }

    public Version getVersion() {
        return this.version;
    }

    public ComponentLog getLog(String componentCode) {
        return this.rootLog.getComponentLog(componentCode);
    }

    protected ComponentLog getComponentLog() {
        return this.log;
    }

    public Log getApplicationLog() {
        return this.rootLog;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public LogWriterManager getLogManager() {
        return this.logManager;
    }

    public void addAsynchronous(DeferredStartAsynchronous asynch) {
        if (!this.deferredRscs.contains(asynch)) {
            this.deferredRscs.add(asynch);
        }
    }

    public void addAsynchronous(Asynchronous asynch) {
        if (!this.asynchronousRscs.contains(asynch)) {
            this.asynchronousRscs.add(asynch);
        }
    }

    public void removeAsynchronous(Asynchronous asynch) {
        this.asynchronousRscs.remove(asynch);
    }

    public void startAsynchronousResources() {
        for (Asynchronous asynch : this.asynchronousRscs) {
            asynch.begin();
        }
        if (this.deferredRscs.size() > 0) {
            DeferredAsynchronousStarter thread = new DeferredAsynchronousStarter(this.deferredRscs);
            thread.start();
        }
    }

    public void stopAsynchronousResources() {
        for (Asynchronous asynchronous : this.asynchronousRscs) {
            asynchronous.end();
        }
        for (DeferredStartAsynchronous deferredStartAsynchronous : this.deferredRscs) {
            deferredStartAsynchronous.end();
        }
        this.logManager.end();
    }

    static final class DeferredAsynchronousStarter
    extends Thread {
        private final List<DeferredStartAsynchronous> deferred;

        private DeferredAsynchronousStarter(List<DeferredStartAsynchronous> deferred) {
            super("Deferred Asynchronous Object Starter");
            this.deferred = deferred;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (Asynchronous asynchronous : this.deferred) {
                asynchronous.begin();
            }
        }
    }
}

