/*
 * Decompiled with CFR 0.152.
 */
package com.techempower;

import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Version {
    public static final int ENV_DEVELOPMENT = 0;
    public static final int ENV_TEST = 1;
    public static final int ENV_PRODUCTION = 2;
    private String versionString = String.valueOf(this.getMajorVersion()) + "." + StringHelper.padZero(this.getMinorVersion(), 2) + "." + StringHelper.padZero(this.getMicroVersion(), 2);
    private String buildDate = null;
    private String deploymentDescription = "Default";
    private int environment = 0;

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getMicroVersion() {
        return 0;
    }

    public String getProductCode() {
        return "GA";
    }

    public String getProductName() {
        return "Example";
    }

    public String getAbbreviatedProductName() {
        return this.getProductName();
    }

    public String getClientName() {
        return "Example";
    }

    public String getDeveloperName() {
        return "TechEmpower, Inc.";
    }

    public String getCopyrightYears() {
        return "2013";
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public String getVerboseDescription() {
        return String.valueOf(this.getAbbreviatedProductName()) + " " + this.getVersionString() + " build " + this.getBuildDate();
    }

    public String getJavaVersion() {
        return String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.vendor") + ")" + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public String getDeploymentDescription() {
        return this.deploymentDescription;
    }

    public void setDeploymentDescription(String deploymentDescription) {
        this.deploymentDescription = deploymentDescription;
        int env = 0;
        if (StringHelper.containsIgnoreCase(deploymentDescription, "Test") || StringHelper.containsIgnoreCase(deploymentDescription, "QA") || StringHelper.containsIgnoreCase(deploymentDescription, "Staging")) {
            env = 1;
        }
        if (StringHelper.containsIgnoreCase(deploymentDescription, "Production")) {
            env = 2;
        }
        this.setEnvironment(env);
    }

    public String getNameAndDeployment() {
        return String.valueOf(this.getProductName()) + (StringHelper.isNonEmpty(this.getDeploymentDescription()) ? " (" + this.getDeploymentDescription() + ")" : "");
    }

    public void setEnvironment(int environmentType) {
        if (environmentType >= 0 && environmentType <= 2) {
            this.environment = environmentType;
        }
    }

    public int getEnvironment() {
        return this.environment;
    }

    public Map<Object, Boolean> getEnvironmentFlags() {
        HashMap<Object, Boolean> toReturn = new HashMap<Object, Boolean>();
        if (this.isProduction()) {
            toReturn.put("production", Boolean.TRUE);
            toReturn.put("prod", Boolean.TRUE);
        }
        if (this.isTest()) {
            toReturn.put("test", Boolean.TRUE);
            toReturn.put("staging", Boolean.TRUE);
        }
        if (this.isDevelopment()) {
            toReturn.put("development", Boolean.TRUE);
            toReturn.put("dev", Boolean.TRUE);
        }
        if (this.isTest() || this.isProduction()) {
            toReturn.put("testOrProduction", Boolean.TRUE);
            toReturn.put("testOrProd", Boolean.TRUE);
        }
        if (this.isDevelopment() || this.isTest()) {
            toReturn.put("developmentOrTest", Boolean.TRUE);
            toReturn.put("devOrTest", Boolean.TRUE);
        }
        return toReturn;
    }

    public boolean isDevelopment() {
        return this.environment == 0;
    }

    public boolean isTest() {
        return this.environment == 1;
    }

    public boolean isProduction() {
        return this.environment == 2;
    }

    public String getBuildDate() {
        if (this.buildDate == null) {
            this.buildDate = "Unknown";
            try {
                String name = this.getClass().getCanonicalName();
                URL location = this.getClass().getClassLoader().getResource(String.valueOf(name.replace('.', '/')) + ".class");
                File source = new File(location.toURI());
                if (source.exists()) {
                    this.buildDate = DateHelper.STANDARD_TECH_FORMAT.format(new Date(source.lastModified()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.buildDate;
    }

    public void setBuildDate(String buildDate) {
        this.buildDate = buildDate;
    }
}

