/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.audit;

import com.techempower.TechEmpowerApplication;
import com.techempower.audit.Audit;
import com.techempower.audit.AuditListener;
import com.techempower.audit.AuditSession;
import com.techempower.audit.Auditable;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuditManager {
    public static final String COMPONENT_CODE = "audt";
    public static final int DEFAULT_MAXIMUM_VALUE_LENGTH = 100;
    private static final ThreadLocal<AuditSession> SESSION_BY_THREAD = new ThreadLocal();
    private final ComponentLog log;
    private int maximumValueLength = 100;
    private final List<AuditListener> listeners;

    public AuditManager(TechEmpowerApplication application) {
        this.log = application.getLog(COMPONENT_CODE);
        this.listeners = new ArrayList<AuditListener>(2);
    }

    public int getMaximumValueLength() {
        return this.maximumValueLength;
    }

    public void setMaximumValueLength(int maximumValueLength) {
        this.maximumValueLength = maximumValueLength;
    }

    public ComponentLog getLog() {
        return this.log;
    }

    public AuditSession constructSession(Auditable cause) {
        return new AuditSession(this, cause);
    }

    public static AuditSession getSession() {
        return SESSION_BY_THREAD.get();
    }

    public void newSession(Auditable cause) {
        SESSION_BY_THREAD.set(this.constructSession(cause));
    }

    public static int size() {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            return session.size();
        }
        return 0;
    }

    public static boolean hasAudits() {
        return AuditManager.size() > 0;
    }

    public static void commit() {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.commit();
        }
    }

    public static void clear() {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.clear();
        }
    }

    public static void audit(int type, Auditable affected, int attributeID, String originalValue, String newValue) {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.add(type, affected, attributeID, originalValue, newValue);
        }
    }

    public static void audit(int type, Auditable affected, int attributeID, Date originalValue, Date newValue) {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.add(type, affected, attributeID, originalValue, newValue);
        }
    }

    public static void audit(int type, Auditable affected, int attributeID, int originalValue, int newValue) {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.add(type, affected, attributeID, originalValue, newValue);
        }
    }

    public static void audit(int type, Auditable affected, int attributeID, float originalValue, float newValue) {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.add(type, affected, attributeID, originalValue, newValue);
        }
    }

    public static void audit(int type, Auditable affected, int attributeID, boolean originalValue, boolean newValue) {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.add(type, affected, attributeID, originalValue, newValue);
        }
    }

    public static void audit(int type, Auditable affected, int attributeID, Object originalValue, Object newValue) {
        AuditSession session = AuditManager.getSession();
        if (session != null) {
            session.add(type, affected, attributeID, originalValue, newValue);
        }
    }

    public void addListener(AuditListener listener) {
        this.listeners.add(listener);
        this.log.log("Listener registered: " + listener.getAuditListenerName());
    }

    public void removeListener(AuditListener listener) {
        this.listeners.remove(listener);
        this.log.log("Listener de-registered: " + listener.getAuditListenerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitSession(AuditSession session) {
        AuditSession auditSession = session;
        synchronized (auditSession) {
            if (this.listeners.size() > 0) {
                for (AuditListener listener : this.listeners) {
                    listener.auditSessionCommitted(session);
                }
                int i = 0;
                while (i < session.size()) {
                    Audit audit = session.get(i);
                    for (AuditListener listener : this.listeners) {
                        listener.auditCommitted(session, audit);
                    }
                    ++i;
                }
                for (AuditListener listener : this.listeners) {
                    listener.auditSessionCommitComplete(session);
                }
            } else {
                this.log.log("No AuditListeners are defined!  Audit information will not be recorded.");
            }
        }
    }
}

