/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.audit;

import com.techempower.audit.Audit;
import com.techempower.helper.DateHelper;
import com.techempower.util.Identifiable;
import java.util.Comparator;
import java.util.Date;

public class ReadonlyAudit
implements Identifiable {
    public static final Comparator<ReadonlyAudit> SORT_DATE_DESC = new Comparator<ReadonlyAudit>(){

        @Override
        public int compare(ReadonlyAudit arg0, ReadonlyAudit arg1) {
            return arg1.getAuditTime().compareTo(arg0.getAuditTime());
        }
    };
    private int auditID;
    private int type;
    private Date auditTime;
    private int affected;
    private int affectedTypeID;
    private int cause;
    private int causeTypeID;
    private int attributeID;
    private String originalValue;
    private String newValue;

    @Override
    public int getId() {
        return this.auditID;
    }

    @Override
    public void setId(int identity) {
        this.auditID = identity;
    }

    public String toString() {
        return "ReadonlyAudit [" + DateHelper.STANDARD_SQL_FORMAT.format(this.getAuditTime()) + " " + this.getAffected() + " (" + this.getAffectedTypeID() + ") by " + this.getCause() + " (" + this.getCauseTypeID() + ") changed " + this.getAttributeID() + " to " + this.getNewValue() + "]";
    }

    public int getAffected() {
        return this.affected;
    }

    public void setAffected(int affected) {
        this.affected = affected;
    }

    public int getAffectedTypeID() {
        return this.affectedTypeID;
    }

    public void setAffectedTypeID(int affectedTypeID) {
        this.affectedTypeID = affectedTypeID;
    }

    public int getAttributeID() {
        return this.attributeID;
    }

    public void setAttributeID(int attributeID) {
        this.attributeID = attributeID;
    }

    public int getAuditID() {
        return this.auditID;
    }

    public void setAuditID(int auditID) {
        this.auditID = auditID;
    }

    public Date getAuditTime() {
        return this.auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public int getCause() {
        return this.cause;
    }

    public void setCause(int cause) {
        this.cause = cause;
    }

    public int getCauseTypeID() {
        return this.causeTypeID;
    }

    public void setCauseTypeID(int causeTypeID) {
        this.causeTypeID = causeTypeID;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getAuditTypeName() {
        return Audit.getAuditTypeName(this.getType());
    }
}

