/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.cache;

import com.techempower.cache.CachedRelationListener;
import com.techempower.cache.EntityStore;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.ManyToManyIntegerRelation;
import com.techempower.data.ConnectionMonitor;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.EntityRelation;
import com.techempower.helper.DatabaseHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.Identifiable;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CachedRelation<L extends Identifiable, R extends Identifiable>
implements EntityRelation<L, R>,
Identifiable {
    private static final int MAX_SQL_SIZE = 1000;
    private final EntityStore store;
    private final ConnectorFactory cf;
    private final Class<L> leftType;
    private final Class<R> rightType;
    private final String table;
    private final String leftColumn;
    private final String rightColumn;
    private final String quotedTable;
    private final String quotedLeftColumn;
    private final String quotedRightColumn;
    private final IntegerRelation relation;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Collection<CachedRelationListener> listeners = new ArrayList<CachedRelationListener>();
    private volatile boolean loaded = false;
    private int id;

    public static <L extends Identifiable, R extends Identifiable> Builder<L, R> of(Class<L> leftType, Class<R> rightType) {
        return new Builder<L, R>(leftType, rightType);
    }

    protected CachedRelation(EntityStore store, Class<L> leftType, Class<R> rightType, String tableName, String leftColumn, String rightColumn, IntegerRelation relation) {
        this.store = store;
        this.cf = store.getConnectorFactory();
        this.leftType = leftType;
        this.rightType = rightType;
        this.table = tableName == null ? "map" + leftType.getSimpleName().toLowerCase() + "to" + rightType.getSimpleName().toLowerCase() : tableName;
        this.leftColumn = leftColumn == null ? leftType.getSimpleName().toLowerCase() : leftColumn;
        this.rightColumn = rightColumn == null ? rightType.getSimpleName().toLowerCase() : rightColumn;
        this.relation = relation == null ? new ManyToManyIntegerRelation(true) : (IntegerRelation)relation.clone();
        this.quotedTable = DatabaseHelper.quoteTableOrColumn(this.cf, this.table);
        this.quotedLeftColumn = DatabaseHelper.quoteTableOrColumn(this.cf, this.leftColumn);
        this.quotedRightColumn = DatabaseHelper.quoteTableOrColumn(this.cf, this.rightColumn);
    }

    @Override
    public boolean add(int leftID, int rightID) {
        return this.add(leftID, rightID, true, true);
    }

    public boolean add(int leftID, int rightID, boolean updateDatabase, boolean notifyListeners) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.writeLock().lock();
        try {
            if (!this.relation.add(leftID, rightID)) {
                return false;
            }
            if (updateDatabase) {
                Throwable throwable = null;
                Iterator<CachedRelationListener> iterator = null;
                try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (PreparedStatement insertStatement = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + ", " + this.quotedRightColumn + ") VALUES (?, ?);");){
                        insertStatement.setInt(1, leftID);
                        insertStatement.setInt(2, rightID);
                        insertStatement.executeUpdate();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            if (notifyListeners) {
                for (CachedRelationListener listener : this.listeners) {
                    listener.add(this.id, leftID, rightID);
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean add(int leftID, R right) {
        return right != null && this.add(leftID, right.getId());
    }

    @Override
    public boolean add(L left, int rightID) {
        return left != null && this.add(left.getId(), rightID);
    }

    @Override
    public boolean add(L left, R right) {
        return left != null && right != null && this.add(left.getId(), right.getId());
    }

    @Override
    public boolean addAll(IntegerRelation relationToAdd) {
        return this.addAll(relationToAdd, true, true);
    }

    public boolean addAll(IntegerRelation relationToAdd, boolean updateDatabase, boolean notifyListeners) {
        block63: {
            if (relationToAdd == null) {
                return false;
            }
            if (!this.loaded) {
                this.load();
            }
            this.lock.writeLock().lock();
            try {
                block61: {
                    int[] newLefts = new int[relationToAdd.size()];
                    int[] newRights = new int[relationToAdd.size()];
                    int insertCount = 0;
                    Object iter = relationToAdd.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        int leftID = iter.left();
                        int rightID = iter.right();
                        if (!this.relation.add(leftID, rightID)) continue;
                        newLefts[insertCount] = leftID;
                        newRights[insertCount] = rightID;
                        ++insertCount;
                    }
                    if (insertCount == 0) {
                        return false;
                    }
                    if (updateDatabase) {
                        this.lock.writeLock().unlock();
                        iter = null;
                        Object var8_11 = null;
                        try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                            int i;
                            if (insertCount <= 1000) {
                                Throwable throwable = null;
                                Object var11_23 = null;
                                try (PreparedStatement insertStatementA = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") VALUES " + StringHelper.join(",", Collections.nCopies(insertCount, "(?,?)")) + ";");){
                                    int i2 = 0;
                                    while (i2 < insertCount) {
                                        insertStatementA.setInt(2 * i2 + 1, newLefts[i2]);
                                        insertStatementA.setInt(2 * i2 + 2, newRights[i2]);
                                        ++i2;
                                    }
                                    insertStatementA.executeUpdate();
                                    break block61;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            int smallInsertSize = insertCount % 1000;
                            int lastBigInsertIndex = insertCount - smallInsertSize;
                            int numLargeInserts = lastBigInsertIndex / 1000;
                            Throwable throwable = null;
                            Object var14_32 = null;
                            try (PreparedStatement insertStatementA = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") VALUES " + StringHelper.join(",", Collections.nCopies(1000, "(?,?)")) + ";");){
                                i = 0;
                                while (i < numLargeInserts) {
                                    int startIndex = i * 1000;
                                    int j = 0;
                                    while (j < 1000) {
                                        insertStatementA.setInt(2 * j + 1, newLefts[j + startIndex]);
                                        insertStatementA.setInt(2 * j + 2, newRights[j + startIndex]);
                                        ++j;
                                    }
                                    insertStatementA.addBatch();
                                    ++i;
                                }
                                insertStatementA.executeBatch();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                            if (smallInsertSize <= 0) break block61;
                            throwable = null;
                            var14_32 = null;
                            try (PreparedStatement insertStatementB = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") VALUES " + StringHelper.join(",", Collections.nCopies(smallInsertSize, "(?,?)")) + ";");){
                                i = 0;
                                while (i < smallInsertSize) {
                                    insertStatementB.setInt(2 * i + 1, newLefts[i + lastBigInsertIndex]);
                                    insertStatementB.setInt(2 * i + 2, newRights[i + lastBigInsertIndex]);
                                    ++i;
                                }
                                insertStatementB.executeUpdate();
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (iter == null) {
                                iter = throwable;
                            } else if (iter != throwable) {
                                ((Throwable)iter).addSuppressed(throwable);
                            }
                            throw iter;
                        }
                    }
                }
                if (!notifyListeners) break block63;
                for (CachedRelationListener listener : this.listeners) {
                    listener.addAll(this.id, relationToAdd);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
            finally {
                try {
                    this.lock.writeLock().unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }
        return true;
    }

    public void addListener(CachedRelationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        this.clear(true, true);
    }

    public void clear(boolean updateDatabase, boolean notifyListeners) {
        this.lock.writeLock().lock();
        try {
            try {
                this.relation.clear();
                this.lock.writeLock().unlock();
                if (updateDatabase) {
                    Throwable throwable = null;
                    Iterator<CachedRelationListener> iterator = null;
                    try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + ";");){
                            deleteStatement.executeUpdate();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                if (notifyListeners) {
                    for (CachedRelationListener listener : this.listeners) {
                        listener.clear(this.id);
                    }
                }
                this.loaded = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.lock.writeLock().unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }
        finally {
            try {
                this.lock.writeLock().unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {}
        }
    }

    @Override
    public boolean contains(int leftID, int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.relation.contains(leftID, rightID);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(int leftID, R right) {
        return right != null && this.contains(leftID, right.getId());
    }

    @Override
    public boolean contains(L left, int rightID) {
        return left != null && this.contains(left.getId(), rightID);
    }

    @Override
    public boolean contains(L left, R right) {
        return left != null && right != null && this.contains(left.getId(), right.getId());
    }

    @Override
    public boolean containsLeftValue(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.relation.containsLeftValue(leftID);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsLeftValue(L left) {
        return left != null && this.containsLeftValue(left.getId());
    }

    @Override
    public boolean containsRightValue(int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.relation.containsRightValue(rightID);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsRightValue(R right) {
        return right != null && this.containsRightValue(right.getId());
    }

    @Override
    public int[] leftIDArray(R right) {
        return right == null ? new int[]{} : this.leftIDArray(right.getId());
    }

    @Override
    public int[] leftIDArray(int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int[] nArray = this.relation.leftValues(rightID);
            return nArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<Integer> leftIDs(int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            HashSet<Integer> leftIDs = new HashSet<Integer>();
            int[] nArray = this.relation.leftValues(rightID);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                leftIDs.add(i);
                ++n2;
            }
            HashSet<Integer> hashSet = leftIDs;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<Integer> leftIDs(R right) {
        return right == null ? new HashSet(0) : this.leftIDs((R)right.getId());
    }

    @Override
    public int leftSize(int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int n = this.relation.leftSize(rightID);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int leftSize(R right) {
        return right == null ? 0 : this.leftSize(right.getId());
    }

    @Override
    public Class<L> leftType() {
        return this.leftType;
    }

    @Override
    public List<L> leftValueList(int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            List<L> list = this.store.list(this.leftType, this.relation.leftValues(rightID));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<L> leftValueList(R right) {
        return right == null ? new ArrayList(0) : this.leftValueList((R)right.getId());
    }

    @Override
    public Set<L> leftValueSet(int rightID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            HashSet<L> hashSet = new HashSet<L>(this.store.list(this.leftType, this.relation.leftValues(rightID)));
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<L> leftValueSet(R right) {
        return right == null ? new HashSet(0) : this.leftValueSet((R)right.getId());
    }

    public List<CachedRelationListener> listeners() {
        return new ArrayList<CachedRelationListener>(this.listeners);
    }

    protected void load() {
        this.lock.writeLock().lock();
        try {
            if (this.loaded) {
                return;
            }
            try {
                this.relation.clear();
                Throwable throwable = null;
                Object var2_4 = null;
                try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                    Throwable throwable2 = null;
                    Object var5_9 = null;
                    try (PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedLeftColumn + ", " + this.quotedRightColumn + " FROM " + this.quotedTable + ";");){
                        Throwable throwable3 = null;
                        Object var8_14 = null;
                        try (ResultSet resultSet = selectStatement.executeQuery();){
                            while (resultSet.next()) {
                                int leftID = resultSet.getInt(this.leftColumn);
                                int rightID = resultSet.getInt(this.rightColumn);
                                this.relation.add(leftID, rightID);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
                this.loaded = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IntegerRelation relation() {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            IntegerRelation integerRelation = (IntegerRelation)this.relation.clone();
            return integerRelation;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean remove(int leftID, int rightID) {
        return this.remove(leftID, rightID, true, true);
    }

    @Override
    public <T extends Identifiable> boolean removeEntity(T object) {
        return object == null ? false : this.removeEntity(object.getClass(), object.getId());
    }

    @Override
    public <T extends Identifiable> boolean removeEntity(Class<T> type, int idToRemove) {
        boolean changed = false;
        if (this.leftType == type) {
            boolean bl = changed = this.removeLeftValue(idToRemove) || changed;
        }
        if (this.rightType == type) {
            changed = this.removeRightValue(idToRemove) || changed;
        }
        return changed;
    }

    public boolean remove(int leftID, int rightID, boolean updateDatabase, boolean notifyListeners) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.writeLock().lock();
        try {
            if (!this.relation.remove(leftID, rightID)) {
                return false;
            }
            if (updateDatabase) {
                Throwable throwable = null;
                Iterator<CachedRelationListener> iterator = null;
                try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ? AND " + this.quotedRightColumn + " = ?;");){
                        deleteStatement.setInt(1, leftID);
                        deleteStatement.setInt(2, rightID);
                        deleteStatement.executeUpdate();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            if (notifyListeners) {
                for (CachedRelationListener listener : this.listeners) {
                    listener.remove(this.id, leftID, rightID);
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(int leftID, R right) {
        return right != null && this.remove(leftID, right.getId());
    }

    @Override
    public boolean remove(L left, int rightID) {
        return left != null && this.remove(left.getId(), rightID);
    }

    @Override
    public boolean remove(L left, R right) {
        return left != null && right != null && this.remove(left.getId(), right.getId());
    }

    @Override
    public boolean removeAll(IntegerRelation relationToRemove) {
        return this.removeAll(relationToRemove, true, true);
    }

    public boolean removeAll(IntegerRelation relationToRemove, boolean updateDatabase, boolean notifyListeners) {
        block63: {
            if (relationToRemove == null) {
                return false;
            }
            if (!this.loaded) {
                this.load();
            }
            this.lock.writeLock().lock();
            try {
                block61: {
                    int[] removedLefts = new int[relationToRemove.size()];
                    int[] removedRights = new int[relationToRemove.size()];
                    int deleteCount = 0;
                    Object iter = relationToRemove.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        int leftID = iter.left();
                        int rightID = iter.right();
                        if (!this.relation.remove(leftID, rightID)) continue;
                        removedLefts[deleteCount] = leftID;
                        removedRights[deleteCount] = rightID;
                        ++deleteCount;
                    }
                    if (deleteCount == 0) {
                        return false;
                    }
                    if (updateDatabase) {
                        this.lock.writeLock().unlock();
                        iter = null;
                        Object var8_11 = null;
                        try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                            int i;
                            if (deleteCount <= 1000) {
                                Throwable throwable = null;
                                Object var11_23 = null;
                                try (PreparedStatement deleteStatementA = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") IN (" + StringHelper.join(",", Collections.nCopies(deleteCount, "(?,?)")) + ");");){
                                    int i2 = 0;
                                    while (i2 < deleteCount) {
                                        deleteStatementA.setInt(2 * i2 + 1, removedLefts[i2]);
                                        deleteStatementA.setInt(2 * i2 + 2, removedRights[i2]);
                                        ++i2;
                                    }
                                    deleteStatementA.executeUpdate();
                                    break block61;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            int smallDeleteSize = deleteCount % 1000;
                            int lastBigDeleteIndex = deleteCount - smallDeleteSize;
                            int numLargeDeletes = lastBigDeleteIndex / 1000;
                            Throwable throwable = null;
                            Object var14_32 = null;
                            try (PreparedStatement deleteStatementA = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") IN (" + StringHelper.join(",", Collections.nCopies(1000, "(?,?)")) + ");");){
                                i = 0;
                                while (i < numLargeDeletes) {
                                    int startIndex = i * 1000;
                                    int j = 0;
                                    while (j < 1000) {
                                        deleteStatementA.setInt(2 * j + 1, removedLefts[j + startIndex]);
                                        deleteStatementA.setInt(2 * j + 2, removedRights[j + startIndex]);
                                        ++j;
                                    }
                                    deleteStatementA.addBatch();
                                    ++i;
                                }
                                deleteStatementA.executeBatch();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                            if (smallDeleteSize <= 0) break block61;
                            throwable = null;
                            var14_32 = null;
                            try (PreparedStatement deleteStatementB = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") IN (" + StringHelper.join(",", Collections.nCopies(smallDeleteSize, "(?,?)")) + ");");){
                                i = 0;
                                while (i < smallDeleteSize) {
                                    deleteStatementB.setInt(2 * i + 1, removedLefts[i + lastBigDeleteIndex]);
                                    deleteStatementB.setInt(2 * i + 2, removedRights[i + lastBigDeleteIndex]);
                                    ++i;
                                }
                                deleteStatementB.executeUpdate();
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (iter == null) {
                                iter = throwable;
                            } else if (iter != throwable) {
                                ((Throwable)iter).addSuppressed(throwable);
                            }
                            throw iter;
                        }
                    }
                }
                if (!notifyListeners) break block63;
                for (CachedRelationListener listener : this.listeners) {
                    listener.addAll(this.id, relationToRemove);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
            finally {
                try {
                    this.lock.writeLock().unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }
        return true;
    }

    @Override
    public boolean removeLeftValue(int leftID) {
        return this.removeLeftValue(leftID, true, true);
    }

    public boolean removeLeftValue(int leftID, boolean updateDatabase, boolean notifyListeners) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.writeLock().lock();
        try {
            if (!this.relation.removeLeftValue(leftID)) {
                return false;
            }
            if (updateDatabase) {
                Throwable throwable = null;
                Iterator<CachedRelationListener> iterator = null;
                try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;");){
                        deleteStatement.setInt(1, leftID);
                        deleteStatement.executeUpdate();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            if (notifyListeners) {
                for (CachedRelationListener listener : this.listeners) {
                    listener.removeLeftValue(this.id, leftID);
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeLeftValue(L left) {
        return left != null && this.removeLeftValue(left.getId());
    }

    @Override
    public boolean removeRightValue(int rightID) {
        return this.removeRightValue(rightID, true, true);
    }

    public boolean removeRightValue(int rightID, boolean updateDatabase, boolean notifyListeners) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.writeLock().lock();
        try {
            if (!this.relation.removeRightValue(rightID)) {
                return false;
            }
            if (updateDatabase) {
                Throwable throwable = null;
                Iterator<CachedRelationListener> iterator = null;
                try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;");){
                        deleteStatement.setInt(1, rightID);
                        deleteStatement.executeUpdate();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            if (notifyListeners) {
                for (CachedRelationListener listener : this.listeners) {
                    listener.removeRightValue(this.id, rightID);
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeRightValue(R right) {
        return right != null && this.removeRightValue(right.getId());
    }

    @Override
    public boolean replaceAll(IntegerRelation relationToReplace) {
        return this.replaceAll(relationToReplace, true, true);
    }

    public boolean replaceAll(IntegerRelation relationToReplace, boolean updateDatabase, boolean notifyListeners) {
        block74: {
            if (relationToReplace == null) {
                return false;
            }
            if (!this.loaded) {
                this.load();
            }
            this.lock.writeLock().lock();
            try {
                block72: {
                    if (this.relation.containsAll(relationToReplace) && relationToReplace.containsAll(this.relation)) {
                        return false;
                    }
                    this.relation.clear();
                    int[] newLefts = new int[relationToReplace.size()];
                    int[] newRights = new int[relationToReplace.size()];
                    int insertCount = 0;
                    Object iter = relationToReplace.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        int leftID = iter.left();
                        int rightID = iter.right();
                        if (!this.relation.add(leftID, rightID)) continue;
                        newLefts[insertCount] = leftID;
                        newRights[insertCount] = rightID;
                        ++insertCount;
                    }
                    if (updateDatabase) {
                        this.lock.writeLock().unlock();
                        iter = null;
                        Object var8_15 = null;
                        try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                            int i;
                            Throwable throwable = null;
                            Object var11_24 = null;
                            try (PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + ";");){
                                deleteStatement.executeUpdate();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            if (insertCount <= 0) break block72;
                            if (insertCount <= 1000) {
                                throwable = null;
                                var11_24 = null;
                                try (PreparedStatement insertStatementA = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") VALUES " + StringHelper.join(",", Collections.nCopies(insertCount, "(?,?)")) + ";");){
                                    int i2 = 0;
                                    while (i2 < insertCount) {
                                        insertStatementA.setInt(2 * i2 + 1, newLefts[i2]);
                                        insertStatementA.setInt(2 * i2 + 2, newRights[i2]);
                                        ++i2;
                                    }
                                    insertStatementA.executeUpdate();
                                    break block72;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                            int smallInsertSize = insertCount % 1000;
                            int lastBigInsertIndex = insertCount - smallInsertSize;
                            int numLargeInserts = lastBigInsertIndex / 1000;
                            int count = 0;
                            Throwable throwable4 = null;
                            Object var15_34 = null;
                            try (PreparedStatement insertStatementA = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") VALUES " + StringHelper.join(",", Collections.nCopies(1000, "(?,?)")) + ";");){
                                i = 0;
                                while (i < numLargeInserts) {
                                    int startIndex = i * 1000;
                                    int j = 0;
                                    while (j < 1000) {
                                        insertStatementA.setInt(2 * j + 1, newLefts[j + startIndex]);
                                        insertStatementA.setInt(2 * j + 2, newRights[j + startIndex]);
                                        ++j;
                                    }
                                    insertStatementA.addBatch();
                                    if (++count % 100 == 0) {
                                        insertStatementA.executeBatch();
                                    }
                                    ++i;
                                }
                                insertStatementA.executeBatch();
                            }
                            catch (Throwable throwable5) {
                                if (throwable4 == null) {
                                    throwable4 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw throwable4;
                            }
                            if (smallInsertSize <= 0) break block72;
                            throwable4 = null;
                            var15_34 = null;
                            try (PreparedStatement insertStatementB = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + this.quotedLeftColumn + "," + this.quotedRightColumn + ") VALUES " + StringHelper.join(",", Collections.nCopies(smallInsertSize, "(?,?)")) + ";");){
                                i = 0;
                                while (i < smallInsertSize) {
                                    insertStatementB.setInt(2 * i + 1, newLefts[i + lastBigInsertIndex]);
                                    insertStatementB.setInt(2 * i + 2, newRights[i + lastBigInsertIndex]);
                                    ++i;
                                }
                                insertStatementB.executeUpdate();
                            }
                            catch (Throwable throwable6) {
                                if (throwable4 == null) {
                                    throwable4 = throwable6;
                                } else if (throwable4 != throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable) {
                            if (iter == null) {
                                iter = throwable;
                            } else if (iter != throwable) {
                                ((Throwable)iter).addSuppressed(throwable);
                            }
                            throw iter;
                        }
                    }
                }
                if (!notifyListeners) break block74;
                for (CachedRelationListener listener : this.listeners) {
                    listener.addAll(this.id, relationToReplace);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
            finally {
                try {
                    this.lock.writeLock().unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }
        return true;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean notifyListeners) {
        this.lock.writeLock().lock();
        try {
            this.loaded = false;
            if (notifyListeners) {
                for (CachedRelationListener listener : this.listeners) {
                    listener.reset(this.id);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public <T extends Identifiable> void reset(Class<T> type) {
        this.reset(type, true);
    }

    public <T extends Identifiable> void reset(Class<T> type, boolean notifyListeners) {
        if (type.equals(this.leftType) || type.equals(this.rightType)) {
            this.reset(notifyListeners);
        }
    }

    @Override
    public int[] rightIDArray(L left) {
        return left == null ? new int[]{} : this.rightIDArray(left.getId());
    }

    @Override
    public int[] rightIDArray(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int[] nArray = this.relation.rightValues(leftID);
            return nArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TIntSet rightIDsIntegerSet(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            TIntSet tIntSet = this.relation.rightValuesIntegerSet(leftID);
            return tIntSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<Integer> rightIDs(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            HashSet<Integer> rightIDs = new HashSet<Integer>();
            int[] nArray = this.relation.rightValues(leftID);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                rightIDs.add(i);
                ++n2;
            }
            HashSet<Integer> hashSet = rightIDs;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<Integer> rightIDs(L left) {
        return left == null ? new HashSet(0) : this.rightIDs((L)left.getId());
    }

    @Override
    public TIntSet rightIDsIntegerSet(L left) {
        return left == null ? new TIntHashSet(0) : this.rightIDsIntegerSet(left.getId());
    }

    @Override
    public int rightSize(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int n = this.relation.rightSize(leftID);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int rightSize(L left) {
        return left == null ? 0 : this.rightSize(left.getId(), (Collection<Integer>)null);
    }

    @Override
    public int rightSize(L left, Collection<Integer> filterRightIds) {
        return left == null ? 0 : this.rightSize(left.getId(), filterRightIds);
    }

    @Override
    public int rightSize(L left, TIntSet filterRightIds) {
        return left == null ? 0 : this.rightSize(left.getId(), filterRightIds);
    }

    @Override
    public int rightSize(int leftID, Collection<Integer> filterRightIds) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int n = this.relation.rightSize(leftID, filterRightIds);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int rightSize(int leftID, TIntSet filterRightIds) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int n = this.relation.rightSize(leftID, filterRightIds);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Class<R> rightType() {
        return this.rightType;
    }

    @Override
    public List<R> rightValueList(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            List<R> list = this.store.list(this.rightType, this.relation.rightValues(leftID));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<R> rightValueList(L left) {
        return left == null ? new ArrayList(0) : this.rightValueList((L)left.getId());
    }

    @Override
    public Set<R> rightValueSet(int leftID) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            HashSet<R> hashSet = new HashSet<R>(this.store.list(this.rightType, this.relation.rightValues(leftID)));
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<R> rightValueSet(L left) {
        return left == null ? new HashSet(0) : this.rightValueSet((L)left.getId());
    }

    @Override
    public int size() {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            int n = this.relation.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int identity) {
        this.id = identity;
    }

    @Override
    public String tableName() {
        return this.table;
    }

    public static class Builder<L extends Identifiable, R extends Identifiable>
    implements EntityRelation.Builder<L, R, CachedRelation<L, R>> {
        private final Class<L> leftType;
        private final Class<R> rightType;
        private String table;
        private String leftColumn;
        private String rightColumn;
        private IntegerRelation relation;

        protected Builder(Class<L> leftType, Class<R> rightType) {
            Objects.requireNonNull(leftType);
            Objects.requireNonNull(rightType);
            this.leftType = leftType;
            this.rightType = rightType;
        }

        @Override
        public CachedRelation<L, R> build(EntityStore store) {
            Objects.requireNonNull(store);
            return new CachedRelation<L, R>(store, this.leftType, this.rightType, this.table, this.leftColumn, this.rightColumn, this.relation);
        }

        public Builder<L, R> table(String tableName) {
            Objects.requireNonNull(tableName);
            this.table = tableName;
            return this;
        }

        public Builder<L, R> leftColumn(String leftColumnName) {
            Objects.requireNonNull(leftColumnName);
            this.leftColumn = leftColumnName;
            return this;
        }

        public Builder<L, R> rightColumn(String rightColumnName) {
            Objects.requireNonNull(rightColumnName);
            this.rightColumn = rightColumnName;
            return this;
        }

        public Builder<L, R> relation(IntegerRelation integerRelation) {
            Objects.requireNonNull(integerRelation);
            this.relation = integerRelation;
            return this;
        }
    }
}

