/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.cache;

import com.techempower.TechEmpowerApplication;
import com.techempower.cache.CacheGroup;
import com.techempower.cache.CacheListener;
import com.techempower.cache.CachedRelation;
import com.techempower.cache.ControllerError;
import com.techempower.cache.MethodValueCache;
import com.techempower.cache.PureMemoryGroup;
import com.techempower.cache.ResponseCachedToDisk;
import com.techempower.cache.annotation.Indexed;
import com.techempower.cache.annotation.NotIndexed;
import com.techempower.classloader.PackageClassLoader;
import com.techempower.collection.ReflectiveComparator;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.EntityGroup;
import com.techempower.data.EntityRelation;
import com.techempower.data.annotation.CachedEntity;
import com.techempower.data.annotation.Entity;
import com.techempower.data.annotation.EntityTypeAdapter;
import com.techempower.data.annotation.Left;
import com.techempower.data.annotation.PureMemoryEntity;
import com.techempower.data.annotation.Relation;
import com.techempower.data.annotation.Right;
import com.techempower.gemini.GeminiApplication;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.reflect.TypeAdapter;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import com.techempower.util.Identifiable;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class EntityStore
implements Configurable {
    public static final String COMPONENT_CODE = "cach";
    public static final Class<?>[] NO_PARAMETERS = new Class[0];
    public static final Object[] NO_VALUES = new Object[0];
    public static final int INITIAL_GROUPS_SIZE = 20;
    public static final String ERROR_METHOD_ACCESS = "Method cannot be accessed: ";
    public static final String ERROR_FIELD_ACCESS = "Field cannot be accessed: ";
    private final TechEmpowerApplication application;
    private final Map<Class<? extends Identifiable>, EntityGroup<? extends Identifiable>> groups;
    private final ConnectorFactory connectorFactory;
    private final ComponentLog log;
    private final ComponentLog entityLog;
    private volatile Collection<CacheListener> listeners;
    private boolean cacheMethodValues = false;
    private Map<Class<? extends Identifiable>, MethodValueCache<?>> methodValueCaches = new HashMap();
    private final TIntObjectMap<Class<? extends Identifiable>> entityGroupClassesById = new TIntObjectHashMap();
    private final List<EntityRelation<? extends Identifiable, ? extends Identifiable>> relations = new ArrayList<EntityRelation<? extends Identifiable, ? extends Identifiable>>();
    private final List<CachedRelation<? extends Identifiable, ? extends Identifiable>> cachedRelations = new ArrayList<CachedRelation<? extends Identifiable, ? extends Identifiable>>();
    private final ConcurrentHashMap<Class<? extends Object>, EntityRelation<? extends Identifiable, ? extends Identifiable>> relationsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> cachedResponses = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResponseCachedToDisk> cachedResponsesOnDisk = new ConcurrentHashMap();
    private final Map<Class<? extends Identifiable>, Map<String, Boolean>> indexedAnnotatedMethods = new HashMap<Class<? extends Identifiable>, Map<String, Boolean>>();
    private final Map<Class<? extends Identifiable>, Boolean> indexedAnnotatedClasses = new HashMap<Class<? extends Identifiable>, Boolean>();
    private final List<TypeAdapter<?, ?>> typeAdapters = new ArrayList();

    public EntityStore(TechEmpowerApplication application, ConnectorFactory connectorFactory) {
        this.application = application;
        this.connectorFactory = connectorFactory;
        this.groups = new HashMap<Class<? extends Identifiable>, EntityGroup<? extends Identifiable>>(20);
        this.listeners = new ArrayList<CacheListener>(2);
        this.log = application.getLog(COMPONENT_CODE);
        this.entityLog = application.getLog("data");
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.cacheMethodValues = props.getYesNoProperty("CacheController.CacheMethodValues", false);
        this.cacheMethodValues = props.getYesNoProperty("EntityStore.CacheMethodValues", this.cacheMethodValues);
        this.methodValueCaches = new HashMap();
        if (this.groups != null && !this.groups.isEmpty()) {
            for (EntityGroup<? extends Identifiable> group : this.groups.values()) {
                this.methodValueCaches.put(group.type(), new MethodValueCache<Identifiable>(this, group.type()));
            }
        }
    }

    protected <T extends Identifiable> boolean isIndexed(Class<T> type, String methodName) {
        if (!this.groups.containsKey(type)) {
            return false;
        }
        Boolean classIndexed = this.indexedAnnotatedClasses.get(type);
        if (classIndexed == null) {
            classIndexed = this.cacheMethodValues;
        }
        if (classIndexed.booleanValue()) {
            Boolean methodIndexed = this.indexedAnnotatedMethods.get(type).get(methodName);
            return methodIndexed == null || methodIndexed != false;
        }
        Boolean methodIndexed = this.indexedAnnotatedMethods.get(type).get(methodName);
        return methodIndexed != null && methodIndexed != false;
    }

    public ComponentLog getEntityLog() {
        return this.entityLog;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean notifyListeners) {
        this.log.log("Full reset.", 10);
        for (EntityGroup<? extends Identifiable> entityGroup : this.groups.values()) {
            entityGroup.reset();
        }
        for (CachedRelation cachedRelation : this.cachedRelations) {
            cachedRelation.reset(notifyListeners);
        }
        for (MethodValueCache methodValueCache : this.methodValueCaches.values()) {
            methodValueCache.reset();
        }
        if (notifyListeners) {
            for (CacheListener cacheListener : this.listeners) {
                cacheListener.cacheFullReset();
            }
        }
    }

    public <T extends Identifiable> void reset(Class<T> type) {
        this.reset(type, true);
    }

    public <T extends Identifiable> void reset(Class<T> type, boolean notifyListeners) {
        EntityGroup<? extends Identifiable> group;
        for (CachedRelation<? extends Identifiable, ? extends Identifiable> relation : this.cachedRelations) {
            relation.reset(type, notifyListeners);
        }
        MethodValueCache<?> methodValueCache = this.methodValueCaches.get(type);
        if (methodValueCache != null) {
            methodValueCache.reset();
        }
        if ((group = this.groups.get(type)) != null) {
            group.reset();
            if (notifyListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.cacheTypeReset(group.type());
                }
            }
        }
    }

    public synchronized void addListener(CacheListener listener) {
        ArrayList<CacheListener> newList = new ArrayList<CacheListener>(this.listeners.size() + 1);
        newList.addAll(this.listeners);
        newList.add(listener);
        this.listeners = newList;
    }

    public synchronized void removeListener(CacheListener listener) {
        ArrayList<CacheListener> newList = new ArrayList<CacheListener>(this.listeners);
        newList.remove(listener);
        this.listeners = newList;
    }

    public <T extends Identifiable> EntityGroup<T> getGroup(Class<T> type) {
        return this.groups.get(type);
    }

    protected <T extends Identifiable> EntityGroup<T> getGroupSafe(Class<T> type) {
        if (type == null) {
            throw new ControllerError("Invalid parameter: type is null.");
        }
        EntityGroup<T> toReturn = this.getGroup(type);
        if (toReturn == null) {
            throw new ControllerError(String.valueOf(type.getSimpleName()) + " is not registered with the EntityStore.");
        }
        return toReturn;
    }

    public EntityGroup<? extends Identifiable> getGroup(int groupNumber) {
        return this.getGroup((Class)this.entityGroupClassesById.get(groupNumber));
    }

    public CachedRelation<? extends Identifiable, ? extends Identifiable> getCachedRelation(int relationId) {
        return this.cachedRelations.get(relationId - 1);
    }

    protected <T extends Identifiable> void collectIndexedMethodAnnotations(EntityGroup<T> group) {
        this.indexedAnnotatedMethods.put(group.type(), new HashMap());
        Method[] methodArray = group.type().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Indexed.class)) {
                this.indexedAnnotatedMethods.get(group.type()).put(method.getName(), true);
            } else if (method.getAnnotation(NotIndexed.class) != null) {
                this.indexedAnnotatedMethods.get(group.type()).put(method.getName(), false);
            }
            ++n2;
        }
        if (group.type().isAnnotationPresent(Indexed.class)) {
            this.indexedAnnotatedClasses.put(group.type(), true);
        } else if (group.type().isAnnotationPresent(NotIndexed.class)) {
            this.indexedAnnotatedClasses.put(group.type(), false);
        }
    }

    public <T extends Identifiable> void register(EntityGroup.Builder<T> group) {
        this.register((EntityRelation)((Object)group.build(this)));
    }

    public <T extends Identifiable> EntityGroup<T> register(EntityGroup<T> group) {
        this.log.log("Registering " + group, 10);
        this.collectIndexedMethodAnnotations(group);
        this.groups.put(group.type(), group);
        group.setGroupNumber(this.groups.size());
        this.entityGroupClassesById.put(group.getGroupNumber(), group.type());
        this.methodValueCaches.put(group.type(), new MethodValueCache<T>(this, group.type()));
        return group;
    }

    public List<EntityGroup<? extends Identifiable>> getGroupList() {
        return new ArrayList<EntityGroup<? extends Identifiable>>(this.groups.values());
    }

    public ConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public TechEmpowerApplication getApplication() {
        return this.application;
    }

    public ComponentLog getLog() {
        return this.log;
    }

    public void initialize() {
        this.register("com.techempower");
        this.register(this.application.getClass().getPackage().getName());
    }

    public <T extends Identifiable> int size(Class<T> type) {
        return this.getGroupSafe(type).size();
    }

    public <T extends Identifiable> List<T> list(Class<T> type) {
        return this.getGroupSafe(type).list();
    }

    public <T extends Identifiable> TIntObjectMap<T> map(Class<T> type) {
        return this.getGroupSafe(type).map();
    }

    public <T extends Identifiable> List<T> list(Class<T> type, String methodName, Object value) {
        MethodValueCache<?> methodValueCache;
        if (this.isIndexed(type, methodName) && (methodValueCache = this.methodValueCaches.get(type)) != null) {
            return methodValueCache.getObjects(methodName, value);
        }
        return this.list(type, methodName, NO_PARAMETERS, value);
    }

    public <T extends Identifiable> List<T> list(Class<T> type, String methodName, Object[] args, Object value) {
        return this.list(type, methodName, NO_PARAMETERS, args, value);
    }

    public <T extends Identifiable> List<T> list(Class<T> type, String methodName, Class<?>[] paramTypes, Object[] args, Object value) {
        return this.list(type, methodName, paramTypes, args, value, false);
    }

    public <T extends Identifiable> List<T> list(Class<T> type, String methodName, Object value, boolean loose) {
        return this.list(type, methodName, NO_PARAMETERS, NO_VALUES, value, loose);
    }

    public <T extends Identifiable> List<T> list(Class<T> type, String methodName, Class<?>[] paramTypes, Object[] args, Object value, boolean loose) {
        ArrayList<Identifiable> toReturn = new ArrayList<Identifiable>();
        List<T> objects = this.list(type);
        if (CollectionHelper.isNonEmpty(objects)) {
            Method method = null;
            try {
                method = type.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException exc) {
                try {
                    method = type.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException etexc) {
                    throw new ControllerError("No method found: " + methodName, etexc);
                }
            }
            if (method != null) {
                try {
                    for (Identifiable object : objects) {
                        Object objValue = method.invoke((Object)object, args);
                        if (value.equals(objValue)) {
                            toReturn.add(object);
                            continue;
                        }
                        if (!loose || !value.equals(objValue.toString())) continue;
                        toReturn.add(object);
                    }
                }
                catch (InvocationTargetException etexc) {
                    throw new ControllerError("Unable to invoke method: " + methodName, etexc);
                }
                catch (IllegalAccessException | SecurityException e) {
                    throw new ControllerError(ERROR_METHOD_ACCESS + methodName, e);
                }
            }
        }
        return toReturn;
    }

    public <T extends Identifiable> T get(Class<T> type, int identifier) {
        return this.getGroupSafe(type).get(identifier);
    }

    public <T extends Identifiable> T get(Class<T> type, String identifier) {
        return this.get(type, NumberHelper.parseIntPermissive(identifier, -1));
    }

    public Identifiable get(Collection<Identifiable> collection, int identifier) {
        if (collection == null) {
            return null;
        }
        for (Identifiable object : collection) {
            if (object.getId() != identifier) continue;
            return object;
        }
        return null;
    }

    public <T extends Identifiable> Identifiable getHighestIdentity(Class<T> type) {
        int highestID = this.getGroupSafe(type).highest();
        return this.get(type, highestID);
    }

    public <T extends Identifiable> Identifiable getLowestIdentity(Class<T> type) {
        int lowestID = this.getGroupSafe(type).lowest();
        return this.get(type, lowestID);
    }

    public <T extends Identifiable> List<T> sortedList(Collection<T> unsorted, String sortField, int comparisonType, int ordering, boolean ignoreCase) {
        if (unsorted != null) {
            ArrayList<T> results = new ArrayList<T>(unsorted);
            ReflectiveComparator comparator = new ReflectiveComparator(sortField, comparisonType, ordering);
            comparator.setIgnoreCase(ignoreCase);
            Collections.sort(results, comparator);
            return results;
        }
        return null;
    }

    public <T extends Identifiable> List<T> sortedList(Collection<T> unsorted, String sortField, int comparisonType, int ordering) {
        return this.sortedList(unsorted, sortField, comparisonType, ordering, false);
    }

    public <T extends Identifiable> List<T> sortedList(Collection<T> unsorted, String sortField, int comparisonType) {
        return this.sortedList(unsorted, sortField, comparisonType, 0, false);
    }

    public <T extends Identifiable> List<T> sortedList(Class<T> type, String sortField, int comparisonType) {
        return this.sortedList(this.list(type), sortField, comparisonType);
    }

    public <T extends Identifiable> List<T> sortedList(Class<T> type, String sortField, int comparisonType, int ordering, boolean ignoreCase) {
        return this.sortedList(this.list(type), sortField, comparisonType, ordering, ignoreCase);
    }

    public <T extends Identifiable> List<T> sortedList(Class<T> type, String sortField, int comparisonType, int ordering) {
        return this.sortedList(this.list(type), sortField, comparisonType, ordering);
    }

    public <T extends Identifiable> T getByField(Class<T> type, String fieldName, Object value) {
        Field field = null;
        List<T> list = this.list(type);
        try {
            for (Identifiable object : list) {
                Object objValue;
                if (field == null) {
                    field = object.getClass().getDeclaredField(fieldName);
                }
                if (!value.equals(objValue = field.get(object))) continue;
                return (T)object;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new ControllerError(ERROR_FIELD_ACCESS + fieldName, e);
        }
        return null;
    }

    public <T extends Identifiable> T get(Class<T> type, String methodName, Object value) {
        MethodValueCache<?> methodValueCache;
        if (this.isIndexed(type, methodName) && (methodValueCache = this.methodValueCaches.get(type)) != null) {
            return (T)methodValueCache.getObject(methodName, value);
        }
        Method method = null;
        List<T> list = this.list(type);
        try {
            for (Identifiable object : list) {
                Object objValue;
                if (method == null) {
                    method = object.getClass().getMethod(methodName, new Class[0]);
                }
                if (!Objects.equals(value, objValue = method.invoke((Object)object, new Object[0]))) continue;
                return (T)object;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ControllerError(ERROR_METHOD_ACCESS + methodName, e);
        }
        return null;
    }

    public void refresh(Class<? extends Identifiable> type, int id) {
        this.getGroupSafe(type).refresh(id);
        MethodValueCache<?> methodValueCache = this.methodValueCaches.get(type);
        if (methodValueCache != null) {
            methodValueCache.update(id);
        }
    }

    public <T extends Identifiable> void put(T entity) {
        if (entity == null) {
            throw new ControllerError("Cannot put null entity.");
        }
        this.getGroupSafe(entity.getClass()).put(entity);
        MethodValueCache<?> methodValueCache = this.methodValueCaches.get(entity.getClass());
        if (methodValueCache != null) {
            methodValueCache.update(entity.getId());
        }
        for (CacheListener listener : this.listeners) {
            listener.cacheObjectExpired(entity.getClass(), entity.getId());
        }
    }

    public <T extends Identifiable> void remove(Class<T> type, int id) {
        T entity = this.get(type, id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    public <T extends Identifiable> void remove(T entity) {
        if (entity == null) {
            throw new ControllerError("Cannot remove null entity.");
        }
        this.getGroupSafe(entity.getClass()).remove(entity.getId());
        for (EntityRelation<? extends Identifiable, ? extends Identifiable> relation : this.relations) {
            relation.removeEntity(entity);
        }
        MethodValueCache<?> methodValueCache = this.methodValueCaches.get(entity.getClass());
        if (methodValueCache != null) {
            methodValueCache.delete(entity.getId());
        }
        for (CacheListener listener : this.listeners) {
            listener.removeFromCache(entity.getClass(), entity.getId());
        }
    }

    public <L extends Identifiable, R extends Identifiable, E extends EntityRelation<L, R>> E register(EntityRelation.Builder<L, R, E> relation) {
        return this.register(relation.build(this), (Class<? extends Object>)null);
    }

    public EntityRelation<? extends Identifiable, ? extends Identifiable> register(EntityRelation.Builder<? extends Identifiable, ? extends Identifiable, ? extends EntityRelation<?, ?>> relation, Class<? extends Object> definition) {
        return this.register(relation.build(this), definition);
    }

    public <L extends Identifiable, R extends Identifiable, E extends EntityRelation<L, R>> E register(E relation) {
        return this.register(relation, null);
    }

    public <L extends Identifiable, R extends Identifiable, E extends EntityRelation<L, R>> E register(E relation, Class<? extends Object> definition) {
        this.relations.add(relation);
        if (relation instanceof CachedRelation) {
            CachedRelation cr = (CachedRelation)relation;
            this.cachedRelations.add(cr);
            cr.setId(this.cachedRelations.size());
        }
        if (definition != null) {
            this.relationsMap.put(definition, relation);
        }
        return relation;
    }

    public void register(String packageName) {
        try {
            for (Class<Identifiable> clazz : PackageClassLoader.getClassesBySubclass(packageName, Identifiable.class, true)) {
                EntityGroup.Builder builder;
                Annotation annotation;
                if (clazz.isAnnotationPresent(Entity.class)) {
                    annotation = clazz.getAnnotation(Entity.class);
                    builder = EntityGroup.of(clazz);
                    if (StringHelper.isNonEmpty(annotation.table())) {
                        builder.table(annotation.table());
                    }
                    if (StringHelper.isNonEmpty(annotation.id())) {
                        builder.id(annotation.id());
                    }
                    if (StringHelper.isNonEmpty(annotation.comparator())) {
                        builder.comparator(annotation.comparator());
                    }
                    this.register((EntityRelation)((Object)builder));
                    continue;
                }
                if (clazz.isAnnotationPresent(CachedEntity.class)) {
                    annotation = clazz.getAnnotation(CachedEntity.class);
                    builder = CacheGroup.of(clazz);
                    if (StringHelper.isNonEmpty(annotation.table())) {
                        builder.table(annotation.table());
                    }
                    if (StringHelper.isNonEmpty(annotation.id())) {
                        builder.id(annotation.id());
                    }
                    if (StringHelper.isNonEmpty(annotation.comparator())) {
                        builder.comparator(annotation.comparator());
                    }
                    this.register((EntityRelation)((Object)builder));
                    continue;
                }
                if (!clazz.isAnnotationPresent(PureMemoryEntity.class)) continue;
                this.register((EntityRelation)((Object)PureMemoryGroup.of(clazz)));
            }
            for (Class<Object> clazz : PackageClassLoader.getClassesBySubclass(packageName, Object.class, true)) {
                if (!clazz.isAnnotationPresent(Relation.class)) continue;
                Field[] fields = clazz.getDeclaredFields();
                Field left = null;
                Field right = null;
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (field.isAnnotationPresent(Left.class)) {
                        left = field;
                    } else if (field.isAnnotationPresent(Right.class)) {
                        right = field;
                    }
                    ++n2;
                }
                if (left == null || right == null) {
                    throw new RuntimeException("Cannot create CachedRelation from @Relation definition class without specifying @Left and @Right Identifiables.");
                }
                if (this.getRelation(clazz) != null) continue;
                this.register((EntityRelation)((Object)CachedRelation.of(left.getType(), right.getType()).table(clazz.getSimpleName()).leftColumn(left.getName()).rightColumn(right.getName())), (Class<? extends Object>)clazz);
            }
            for (Class<Object> clazz : PackageClassLoader.getClassesBySubclass(packageName, TypeAdapter.class, true)) {
                if (!clazz.isAnnotationPresent(EntityTypeAdapter.class)) continue;
                try {
                    this.register((TypeAdapter)clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Warn: Could not register TypeAdapter", e);
                }
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException("Warn: could not locate package " + packageName + ", aborting register by package.", exception);
        }
    }

    public <L extends Identifiable, R extends Identifiable> EntityRelation<L, R> getRelation(Class<L> leftClass, Class<R> rightClass) {
        for (EntityRelation<? extends Identifiable, ? extends Identifiable> cr : this.relations) {
            if (!cr.leftType().equals(leftClass) || !cr.rightType().equals(rightClass)) continue;
            return cr;
        }
        return null;
    }

    public EntityRelation<? extends Identifiable, ? extends Identifiable> getRelation(Class<? extends Object> definition) {
        return this.relationsMap.get(definition);
    }

    public EntityRelation<?, ?> getRelation(String tableName) {
        for (EntityRelation<? extends Identifiable, ? extends Identifiable> relation : this.relations) {
            if (!relation.tableName().equals(tableName)) continue;
            return relation;
        }
        return null;
    }

    public List<EntityRelation<?, ?>> getRelations() {
        return new ArrayList(this.relations);
    }

    public List<CachedRelation<?, ?>> getCachedRelations() {
        return new ArrayList(this.cachedRelations);
    }

    public String getCachedResponse(String parameterKeys) {
        return this.cachedResponses.get(parameterKeys);
    }

    public void setCachedResponse(String parameterKeys, String responseText) {
        this.cachedResponses.remove(parameterKeys);
        this.cachedResponses.putIfAbsent(parameterKeys, responseText);
    }

    public String getCachedResponseOnDisk(String parameterKeys) {
        ResponseCachedToDisk ctd = this.cachedResponsesOnDisk.get(parameterKeys);
        String toRet = null;
        try {
            if (ctd != null) {
                long cacheRequestTimeInMillis = System.currentTimeMillis();
                toRet = ctd.getCachedValue();
                this.log.log("Using cached response from disk (" + ctd.getFileName() + " took " + (System.currentTimeMillis() - cacheRequestTimeInMillis) + "ms for " + ctd.getFileSize() + " bytes).");
            }
        }
        catch (FileNotFoundException fnfe) {
            this.cachedResponsesOnDisk.remove(ctd.getRequestSignature());
            ctd.purge();
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachedResponseOnDisk(String parameterKeys, String responseText) {
        try {
            ConcurrentHashMap<String, ResponseCachedToDisk> concurrentHashMap = this.cachedResponsesOnDisk;
            synchronized (concurrentHashMap) {
                if (this.cachedResponsesOnDisk.containsKey(parameterKeys)) {
                    return;
                }
                ResponseCachedToDisk ctd = new ResponseCachedToDisk((GeminiApplication)this.application, parameterKeys, responseText);
                this.cachedResponsesOnDisk.put(parameterKeys, ctd);
                this.log.log("Cached response to disk(" + ctd.getCreationTimeInMillis() + "ms) for key: " + parameterKeys + ", file name: " + ctd.getFileName());
            }
        }
        catch (IOException ioe) {
            this.log.log("IOException while caching file to disk for key: " + parameterKeys + " :: " + ioe);
        }
        catch (Exception e) {
            this.log.log("Exception while caching file to disk for key: " + parameterKeys + " :: " + e);
        }
    }

    public void clearCachedResponses() {
        this.cachedResponses = new ConcurrentHashMap();
        long totalMillisSaved = 0L;
        for (ResponseCachedToDisk ctd : this.cachedResponsesOnDisk.values()) {
            totalMillisSaved += (long)ctd.getRequestCount() * ctd.getInvocationTimeInMillis();
            this.log.log("clearCachedResponses :: requestString(" + ctd.getRequestSignature() + "), hits(" + ctd.getRequestCount() + "), invocationTime(" + ctd.getInvocationTimeInMillis() + ") saving " + (long)ctd.getRequestCount() * ctd.getInvocationTimeInMillis() + "ms", 50);
            ctd.purge();
        }
        if (totalMillisSaved > 0L) {
            this.log.log("clearCachedResponses :: total time saved by disk caching: " + totalMillisSaved + "ms", 50);
        }
        this.cachedResponsesOnDisk = new ConcurrentHashMap();
    }

    public <T extends Identifiable> List<T> list(Class<T> type, int ... ids) {
        return this.list(type, CollectionHelper.toList(ids));
    }

    public <T extends Identifiable> List<T> list(Class<T> type, Collection<Integer> ids) {
        return this.getGroupSafe(type).list(ids);
    }

    public <T extends Identifiable> TIntObjectMap<T> map(Class<T> type, int ... ids) {
        return this.map(type, CollectionHelper.toList(ids));
    }

    public <T extends Identifiable> TIntObjectMap<T> map(Class<T> type, Collection<Integer> ids) {
        return this.getGroupSafe(type).map(ids);
    }

    public <T extends Identifiable> void removeAll(Class<T> type, int ... ids) {
        this.removeAll(type, (Collection<Integer>)CollectionHelper.toList(ids));
    }

    public <T extends Identifiable> void removeAll(Class<T> type, Collection<Integer> ids) {
        this.getGroupSafe(type).removeAll(ids);
        for (EntityRelation<? extends Identifiable, ? extends Identifiable> relation : this.relations) {
            for (int id : ids) {
                relation.removeEntity(type, id);
            }
        }
        MethodValueCache<?> methodValueCache = this.methodValueCaches.get(type);
        if (methodValueCache != null) {
            for (int id : ids) {
                methodValueCache.delete(id);
            }
        }
        for (CacheListener listener : this.listeners) {
            for (int id : ids) {
                listener.removeFromCache(type, id);
            }
        }
    }

    @SafeVarargs
    public final <T extends Identifiable> void putAll(T ... objects) {
        this.putAll((Collection<T>)CollectionHelper.toList(objects));
    }

    public <T extends Identifiable> void putAll(Collection<T> objects) {
        if (objects == null) {
            throw new ControllerError("Cannot putAll of a null collection.");
        }
        HashMap map = new HashMap();
        for (Identifiable identifiable : objects) {
            ArrayList<Identifiable> collection = (ArrayList<Identifiable>)map.get(identifiable.getClass());
            if (collection == null) {
                collection = new ArrayList<Identifiable>();
                map.put(identifiable.getClass(), collection);
            }
            collection.add(identifiable);
        }
        for (Map.Entry entry : map.entrySet()) {
            Class type = (Class)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            this.getGroupSafe(type).putAll(collection);
            MethodValueCache<?> methodValueCache = this.methodValueCaches.get(type);
            if (methodValueCache != null) {
                for (Identifiable object : collection) {
                    methodValueCache.update(object.getId());
                }
            }
            for (CacheListener listener : this.listeners) {
                for (Identifiable object : collection) {
                    listener.cacheObjectExpired(object.getClass(), object.getId());
                }
            }
        }
    }

    @SafeVarargs
    public final <T extends Identifiable> void removeAll(T ... objects) {
        this.removeAll((Collection<T>)CollectionHelper.toList(objects));
    }

    public <T extends Identifiable> void removeAll(Collection<T> objects) {
        if (objects == null) {
            throw new ControllerError("Cannot removeAll of a null collection.");
        }
        HashMap map = new HashMap();
        for (Identifiable identifiable : objects) {
            ArrayList<Integer> collection = (ArrayList<Integer>)map.get(identifiable.getClass());
            if (collection == null) {
                collection = new ArrayList<Integer>();
                map.put(identifiable.getClass(), collection);
            }
            collection.add(identifiable.getId());
        }
        for (Map.Entry entry : map.entrySet()) {
            Class type = (Class)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            this.getGroupSafe(type).removeAll(collection);
            for (EntityRelation<? extends Identifiable, ? extends Identifiable> relation : this.relations) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    relation.removeEntity(type, id);
                }
            }
            MethodValueCache<?> methodValueCache = this.methodValueCaches.get(type);
            if (methodValueCache == null) continue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                methodValueCache.delete(id);
            }
        }
    }

    public <F, T> void register(TypeAdapter<F, T> adapter) {
        if (adapter == null) {
            throw new ControllerError("Cannot register a null type adapter.");
        }
        this.typeAdapters.add(adapter);
    }

    public List<TypeAdapter<?, ?>> getTypeAdapters() {
        return Collections.unmodifiableList(this.typeAdapters);
    }
}

