/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.cache;

import com.techempower.cache.EntityStore;
import com.techempower.util.Identifiable;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MethodValueCache<T extends Identifiable> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Map<Object, TIntSet>> mapMethodNameToValueToIds = new HashMap<String, Map<Object, TIntSet>>();
    private final Map<String, TIntObjectMap<Object>> mapMethodNameToIdToValue = new HashMap<String, TIntObjectMap<Object>>();
    private final Map<String, Method> mapMethodNameToMethod = new HashMap<String, Method>();
    private boolean loaded = false;
    private final EntityStore cache;
    private final Class<T> type;

    public MethodValueCache(EntityStore cache, Class<T> type) {
        this.cache = cache;
        this.type = type;
    }

    public void delete(int id) {
        if (!this.loaded) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (String methodName : this.mapMethodNameToMethod.keySet()) {
                Object value;
                TIntObjectMap<Object> mapIdToValue = this.mapMethodNameToIdToValue.get(methodName);
                Map<Object, TIntSet> mapValueToIds = this.mapMethodNameToValueToIds.get(methodName);
                TIntSet ids = mapValueToIds.get(value = mapIdToValue.get(id));
                if (ids != null) {
                    ids.remove(id);
                    if (ids.isEmpty()) {
                        mapValueToIds.remove(value);
                    }
                }
                mapIdToValue.remove(id);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public T getObject(String methodName, Object value) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            Map<Object, TIntSet> mapValueToIds = this.mapMethodNameToValueToIds.get(methodName);
            if (mapValueToIds != null) {
                TIntSet ids = mapValueToIds.get(value);
                if (ids == null || ids.isEmpty()) {
                    return null;
                }
                int id = ids.iterator().next();
                T t = this.cache.get(this.type, id);
                return t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.addMethod(methodName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.getObject(methodName, value);
    }

    public List<T> getObjects(String methodName, Object value) {
        if (!this.loaded) {
            this.load();
        }
        this.lock.readLock().lock();
        try {
            Map<Object, TIntSet> mapValueToIds = this.mapMethodNameToValueToIds.get(methodName);
            if (mapValueToIds != null) {
                TIntSet ids = mapValueToIds.get(value);
                if (ids == null || ids.isEmpty()) {
                    ArrayList arrayList = new ArrayList(0);
                    return arrayList;
                }
                ArrayList<T> values = new ArrayList<T>();
                for (int id : ids) {
                    values.add(this.cache.get(this.type, id));
                }
                ArrayList<T> arrayList = values;
                return arrayList;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.addMethod(methodName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.getObjects(methodName, value);
    }

    public void reset() {
        if (!this.loaded) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.loaded = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void update(int id) {
        if (!this.loaded) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            T object = this.cache.get(this.type, id);
            for (String methodName : this.mapMethodNameToMethod.keySet()) {
                Object oldValue;
                TIntObjectMap<Object> mapIdToValue = this.mapMethodNameToIdToValue.get(methodName);
                Map<Object, TIntSet> mapValueToIds = this.mapMethodNameToValueToIds.get(methodName);
                TIntSet oldIds = mapValueToIds.get(oldValue = mapIdToValue.get(id));
                if (oldIds != null) {
                    oldIds.remove(id);
                    if (oldIds.isEmpty()) {
                        mapValueToIds.remove(oldValue);
                    }
                }
                mapIdToValue.remove(id);
                if (object == null) continue;
                Object newValue = this.invokeMethod(object, methodName);
                mapIdToValue.put(id, newValue);
                TIntSet ids = mapValueToIds.get(newValue);
                if (ids == null) {
                    ids = new TIntHashSet();
                    mapValueToIds.put(newValue, ids);
                }
                ids.add(id);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void addMethod(String methodName) {
        try {
            Method method = this.type.getMethod(methodName, new Class[0]);
            this.mapMethodNameToMethod.put(methodName, method);
            this.mapMethodNameToValueToIds.put(methodName, new HashMap());
            this.mapMethodNameToIdToValue.put(methodName, (TIntObjectMap<Object>)new TIntObjectHashMap());
            this.indexMethod(methodName);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void indexMethod(String methodName) {
        TIntObjectHashMap mapIdToValue = this.mapMethodNameToIdToValue.get(methodName);
        Map<Object, TIntSet> mapValueToIds = this.mapMethodNameToValueToIds.get(methodName);
        if (mapIdToValue == null) {
            mapIdToValue = new TIntObjectHashMap();
            this.mapMethodNameToIdToValue.put(methodName, (TIntObjectMap<Object>)mapIdToValue);
        } else {
            mapIdToValue.clear();
        }
        if (mapValueToIds == null) {
            mapValueToIds = new HashMap<Object, TIntSet>();
            this.mapMethodNameToValueToIds.put(methodName, mapValueToIds);
        } else {
            mapValueToIds.clear();
        }
        for (Identifiable object : this.cache.list(this.type)) {
            Object value = this.invokeMethod(object, methodName);
            int id = object.getId();
            mapIdToValue.put(id, value);
            TIntSet ids = mapValueToIds.get(value);
            if (ids == null) {
                ids = new TIntHashSet();
                mapValueToIds.put(value, ids);
            }
            ids.add(id);
        }
    }

    protected Object invokeMethod(T object, String methodName) {
        try {
            return this.mapMethodNameToMethod.get(methodName).invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    protected void load() {
        this.lock.writeLock().lock();
        try {
            if (this.loaded) {
                return;
            }
            for (String methodName : this.mapMethodNameToMethod.keySet()) {
                this.indexMethod(methodName);
            }
            this.loaded = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

