/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.cache;

import com.techempower.cache.CacheGroup;
import com.techempower.cache.EmptyInitializer;
import com.techempower.cache.EntityStore;
import com.techempower.cache.GroupInitializer;
import com.techempower.data.EntityMaker;
import com.techempower.util.Identifiable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PureMemoryGroup<T extends Identifiable>
extends CacheGroup<T> {
    private final GroupInitializer<T> initializer;

    protected PureMemoryGroup(EntityStore controller, Class<T> type, EntityMaker<T> maker, Comparator<? super T> comparator, GroupInitializer<T> initializer) {
        super(controller, type, null, null, maker, comparator, null, null);
        this.initializer = initializer;
    }

    public static <T extends Identifiable> Builder<T> of(Class<T> type) {
        return new Builder<T>(type);
    }

    @Override
    protected void putPersistent(T object) {
    }

    @Override
    protected void putAllPersistent(Collection<T> objects) {
    }

    @Override
    protected void removePersistent(int id) {
    }

    protected void removeAllPersistent(int id) {
    }

    @Override
    protected List<T> fetchAllPersistedObjects() {
        List<T> result = this.initializer.list();
        Collections.sort(result, this.comparator());
        return result;
    }

    @Override
    public void refresh(int ... ids) {
    }

    @Override
    protected boolean isPersisted(Identifiable entity) {
        return this.containsRaw(entity);
    }

    public static class Builder<T extends Identifiable>
    extends CacheGroup.Builder<T> {
        private GroupInitializer<T> initializer = new EmptyInitializer();

        protected Builder(Class<T> type) {
            super(type);
        }

        @Override
        public PureMemoryGroup<T> build(EntityStore controller) {
            if (controller == null) {
                throw new NullPointerException();
            }
            return new PureMemoryGroup<T>(controller, this.type, this.maker, this.comparator, this.initializer);
        }

        public Builder<T> initializer(GroupInitializer<T> groupInitializer) {
            if (groupInitializer == null) {
                throw new IllegalArgumentException("CacheInitializer may not be null.");
            }
            this.initializer = groupInitializer;
            return this;
        }

        @Override
        public Builder<T> maker(EntityMaker<T> entityMaker) {
            super.maker((EntityMaker)entityMaker);
            return this;
        }

        @Override
        public Builder<T> comparator(Comparator<? super T> entityComparator) {
            super.comparator((Comparator)entityComparator);
            return this;
        }

        @Override
        public Builder<T> comparator(String methodName) {
            super.comparator(methodName);
            return this;
        }

        @Override
        public Builder<T> constructorArgs(Object ... arguments) {
            super.constructorArgs(arguments);
            return this;
        }
    }
}

