/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class PackageClassLoader {
    private static final String CLASS_EXTENSION = ".class";

    public static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name())));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(PackageClassLoader.findClasses(directory, packageName));
        }
        return classes;
    }

    public static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(PackageClassLoader.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(CLASS_EXTENSION)) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length())));
            }
            ++n2;
        }
        return classes;
    }

    public static <T> List<Class<? extends T>> getClassesBySubclass(String packageName, Class<? extends T> clazz, boolean publicOnly) throws ClassNotFoundException, IOException {
        String path = packageName.replace('.', '/');
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = loader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            File file = new File(URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name()));
            dirs.add(file);
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (File directory : dirs) {
            classes.addAll(PackageClassLoader.findClassesBySubclass(directory, packageName, clazz, publicOnly));
        }
        return classes;
    }

    public static <T> List<Class<? extends T>> findClassesBySubclass(File directory, String packageName, Class<? extends T> clazz, boolean publicOnly) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(PackageClassLoader.findClassesBySubclass(file, String.valueOf(packageName) + "." + file.getName(), clazz, publicOnly));
            } else if (file.getName().endsWith(CLASS_EXTENSION)) {
                Class<?> newClazz = Class.forName(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length()));
                if (!(publicOnly && newClazz.isInterface() || Modifier.isAbstract(newClazz.getModifiers()) || !Modifier.isPublic(newClazz.getModifiers()) || !clazz.isAssignableFrom(newClazz))) {
                    classes.add(newClazz);
                }
            }
            ++n2;
        }
        return classes;
    }

    private PackageClassLoader() {
    }
}

