/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection;

import java.util.Arrays;

public class IntegerSetComparison {
    private int[] setA;
    private int[] setB;
    private int[] aSorted;
    private int[] bSorted;
    private int[] aMinusB;
    private int[] bMinusA;
    private int[] superSet;
    private int largerSize;
    private int smallerSize;
    private boolean computed = false;

    public IntegerSetComparison(int[] setA, int[] setB) {
        this.setA = setA;
        this.setB = setB;
        if (setA.length > setB.length) {
            this.largerSize = setA.length;
            this.smallerSize = setB.length;
        } else {
            this.largerSize = setB.length;
            this.smallerSize = setA.length;
        }
    }

    public void computeIfNeeded() {
        if (!this.computed) {
            this.compute();
        }
    }

    public void compute() {
        this.aSorted = new int[this.setA.length];
        this.bSorted = new int[this.setB.length];
        System.arraycopy(this.setA, 0, this.aSorted, 0, this.setA.length);
        System.arraycopy(this.setB, 0, this.bSorted, 0, this.setB.length);
        Arrays.sort(this.aSorted);
        Arrays.sort(this.bSorted);
        int[] tempAminusB = new int[this.largerSize];
        int[] tempBminusA = new int[this.largerSize];
        int[] tempSuper = new int[this.largerSize + this.smallerSize];
        int positionA = 0;
        int positionB = 0;
        int nextA = 0;
        int nextB = 0;
        int positionAminusB = 0;
        int positionBminusA = 0;
        int positionSuper = 0;
        while (positionA < this.aSorted.length || positionB < this.bSorted.length) {
            nextA = positionA < this.aSorted.length ? this.aSorted[positionA] : Integer.MAX_VALUE;
            if (nextA < (nextB = positionB < this.bSorted.length ? this.bSorted[positionB] : Integer.MAX_VALUE)) {
                tempAminusB[positionAminusB++] = nextA;
                tempSuper[positionSuper++] = nextA;
                ++positionA;
                continue;
            }
            if (nextB < nextA) {
                tempBminusA[positionBminusA++] = nextB;
                tempSuper[positionSuper++] = nextB;
                ++positionB;
                continue;
            }
            tempSuper[positionSuper++] = nextA;
            ++positionA;
            ++positionB;
        }
        this.aMinusB = new int[positionAminusB];
        this.bMinusA = new int[positionBminusA];
        this.superSet = new int[positionSuper];
        System.arraycopy(tempAminusB, 0, this.aMinusB, 0, positionAminusB);
        System.arraycopy(tempBminusA, 0, this.bMinusA, 0, positionBminusA);
        System.arraycopy(tempSuper, 0, this.superSet, 0, positionSuper);
        this.computed = true;
    }

    public int[] getSetA() {
        return this.setA;
    }

    public int[] getSetB() {
        return this.setB;
    }

    public int[] getSetASorted() {
        this.computeIfNeeded();
        return this.aSorted;
    }

    public int[] getSetBSorted() {
        this.computeIfNeeded();
        return this.bSorted;
    }

    public int[] getAMinusB() {
        this.computeIfNeeded();
        return this.aMinusB;
    }

    public int[] getBMinusA() {
        this.computeIfNeeded();
        return this.bMinusA;
    }

    public int[] getSuperset() {
        this.computeIfNeeded();
        return this.superSet;
    }
}

