/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection;

import com.techempower.collection.MutableNamedValues;
import com.techempower.helper.NumberHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MutableNamedObjects
implements MutableNamedValues {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public Map<String, Object> getMap() {
        return new HashMap<String, Object>(this.map);
    }

    public <O> O getObject(String name, O defaultValue) {
        Object obj = this.map.get(name);
        return (O)(obj != null ? obj : defaultValue);
    }

    public <O> O getObject(String name) {
        return this.getObject(name, null);
    }

    public MutableNamedObjects putObject(String name, Object value) {
        this.map.put(name, value);
        return this;
    }

    @Override
    public boolean has(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public Set<String> names() {
        return this.map.keySet();
    }

    @Override
    public String get(String name) {
        return this.get(name, null);
    }

    @Override
    public String get(String name, String defaultValue) {
        try {
            String value = (String)this.map.get(name);
            if (value != null) {
                return value;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        try {
            Integer value = (Integer)this.map.get(name);
            if (value != null) {
                return value;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(this.getInt(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name, long defaultValue, long minimum, long maximum) {
        return NumberHelper.boundLong(this.getLong(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        try {
            Long value = (Long)this.map.get(name);
            if (value != null) {
                return value;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        try {
            Boolean value = (Boolean)this.map.get(name);
            if (value != null) {
                return value;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public MutableNamedValues put(String name, String value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues put(String name, int value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues put(String name, long value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues put(String name, boolean value) {
        return this.putObject(name, value);
    }

    @Override
    public MutableNamedValues remove(String name) {
        this.map.remove(name);
        return this;
    }

    @Override
    public MutableNamedValues clear() {
        this.map.clear();
        return this;
    }
}

