/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection;

import com.google.common.collect.Range;
import com.techempower.helper.StringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReflectiveFilter {
    private Map<String, Object> filteredFields;
    private Map<String, Object> filteredMethods;
    private boolean strict;

    public ReflectiveFilter() {
        this.reset();
    }

    public boolean allow(Object o) {
        return this.filterFields(o) && this.filterMethods(o);
    }

    public void reset() {
        this.resetFields();
        this.resetMethods();
        this.setStrict(false);
    }

    public void resetFields() {
        this.filteredFields = null;
    }

    public void resetMethods() {
        this.filteredMethods = null;
    }

    protected <V, F> boolean allow(V value, F filterValue) {
        if (filterValue instanceof Range && value instanceof Comparable && !((Range)filterValue).contains((Comparable)value)) {
            return false;
        }
        return filterValue.equals(value);
    }

    protected Field getFieldForName(String fieldName, Object o) throws NoSuchFieldException {
        return o.getClass().getField(fieldName);
    }

    protected boolean filterFields(Object o) {
        if (this.filteredFields == null) {
            return true;
        }
        Iterator<String> it = this.filteredFields.keySet().iterator();
        while (it.hasNext()) {
            if (this.filterField(it.next(), o)) continue;
            return false;
        }
        return true;
    }

    protected boolean filterField(String fieldName, Object o) {
        block6: {
            if (this.filteredFields == null) {
                return !this.isStrict();
            }
            try {
                Field field = o.getClass().getField(fieldName);
                if (!this.allow(field.get(o), this.filteredFields.get(fieldName))) {
                    return false;
                }
            }
            catch (IllegalAccessException e) {
                if (this.isStrict()) {
                    return false;
                }
            }
            catch (NoSuchFieldException e) {
                if (!this.isStrict()) break block6;
                return false;
            }
        }
        return true;
    }

    public void removeFilteredField(String fieldName) {
        if (this.filteredFields != null) {
            this.filteredFields.remove(fieldName);
        }
    }

    public void setFilteredField(String fieldName, Object value) {
        if (StringHelper.isEmpty(fieldName)) {
            return;
        }
        if (this.filteredFields == null) {
            this.filteredFields = new HashMap<String, Object>();
        }
        this.filteredFields.put(fieldName, value);
    }

    public <T extends Comparable<T>> void setFilteredField(String fieldName, T rangeStart, T rangeEnd) {
        this.setFilteredField(fieldName, ReflectiveFilter.newRange(rangeStart, rangeEnd));
    }

    public <T extends Comparable<T>> void setFilteredField(String fieldName, Range<T> range) {
        this.setFilteredField(fieldName, (Object)range);
    }

    protected Method getMethodForName(String methodName, Object o) throws NoSuchMethodException {
        return o.getClass().getMethod(methodName, null);
    }

    protected boolean filterMethods(Object o) {
        if (this.filteredMethods == null) {
            return true;
        }
        Iterator<String> it = this.filteredMethods.keySet().iterator();
        while (it.hasNext()) {
            if (this.filterMethod(it.next(), o)) continue;
            return false;
        }
        return true;
    }

    protected boolean filterMethod(String methodName, Object o) {
        block8: {
            if (this.filteredMethods == null) {
                return !this.isStrict();
            }
            try {
                Method method = this.getMethodForName(methodName, o);
                if (!this.allow(method.invoke(o, new Object[0]), this.filteredMethods.get(methodName))) {
                    return false;
                }
            }
            catch (InvocationTargetException e) {
                if (this.isStrict()) {
                    return false;
                }
            }
            catch (IllegalAccessException e) {
                if (this.isStrict()) {
                    return false;
                }
            }
            catch (NoSuchMethodException e) {
                if (!this.isStrict()) break block8;
                return false;
            }
        }
        return true;
    }

    public void removeFilteredMethod(String methodName) {
        if (this.filteredMethods != null) {
            this.filteredMethods.remove(methodName);
        }
    }

    public void setFilteredMethod(String methodName, Object value) {
        if (StringHelper.isEmpty(methodName)) {
            return;
        }
        if (this.filteredMethods == null) {
            this.filteredMethods = new HashMap<String, Object>();
        }
        this.filteredMethods.put(methodName, value);
    }

    public <T extends Comparable<T>> void setFilteredMethod(String methodName, T rangeStart, T rangeEnd) {
        this.setFilteredMethod(methodName, ReflectiveFilter.newRange(rangeStart, rangeEnd));
    }

    public <T extends Comparable<T>> void setFilteredMethod(String methodName, Range<T> range) {
        this.setFilteredMethod(methodName, (Object)range);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private static <T extends Comparable<? super T>> Range<T> newRange(T start, T end) {
        if (start == null) {
            if (end == null) {
                return Range.all();
            }
            return Range.atLeast(start);
        }
        if (end == null) {
            return Range.atMost(end);
        }
        return Range.closed(start, end);
    }
}

