/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection.relation;

import com.techempower.collection.relation.AbstractIntegerRelation;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.IntegerRelationIterator;
import com.techempower.helper.CollectionHelper;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.NoSuchElementException;

public class ManyToManyIntegerRelation
extends AbstractIntegerRelation {
    private final TIntObjectMap<TIntSet> leftMap = new TIntObjectHashMap();
    private final TIntObjectMap<TIntSet> rightMap;
    private int size;

    public ManyToManyIntegerRelation() {
        this(null, false);
    }

    public ManyToManyIntegerRelation(IntegerRelation relation) {
        this(relation, false);
    }

    public ManyToManyIntegerRelation(boolean doublyMapped) {
        this(null, doublyMapped);
    }

    public ManyToManyIntegerRelation(IntegerRelation relation, boolean doublyMapped) {
        this.rightMap = doublyMapped ? new TIntObjectHashMap() : null;
        this.addAll(relation);
    }

    @Override
    public boolean add(int left, int right) {
        if (this.contains(left, right)) {
            return false;
        }
        ++this.size;
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet == null) {
            rightSet = new TIntHashSet();
            this.leftMap.put(left, (Object)rightSet);
        }
        rightSet.add(right);
        if (this.rightMap != null) {
            TIntSet leftSet = (TIntSet)this.rightMap.get(right);
            if (leftSet == null) {
                leftSet = new TIntHashSet();
                this.rightMap.put(right, (Object)leftSet);
            }
            leftSet.add(left);
        }
        return true;
    }

    public boolean add(int left, Collection<Integer> rightIds) {
        boolean modified = false;
        for (Integer right : rightIds) {
            if (!this.add(left, right)) continue;
            modified = true;
            ++this.size;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.leftMap.clear();
        if (this.rightMap != null) {
            this.rightMap.clear();
        }
        this.size = 0;
    }

    @Override
    public Object clone() {
        return new ManyToManyIntegerRelation(this, this.rightMap != null);
    }

    @Override
    public boolean contains(int left, int right) {
        return this.leftMap.containsKey(left) && ((TIntSet)this.leftMap.get(left)).contains(right);
    }

    @Override
    public boolean containsLeftValue(int left) {
        return this.leftMap.containsKey(left);
    }

    @Override
    public boolean containsRightValue(int right) {
        if (this.rightMap != null) {
            return this.rightMap.containsKey(right);
        }
        TIntObjectIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (!((TIntSet)iter.value()).contains(right)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int leftSize(int right) {
        if (this.rightMap != null) {
            TIntSet leftSet = (TIntSet)this.rightMap.get(right);
            return leftSet == null ? 0 : leftSet.size();
        }
        int computedSize = 0;
        TIntObjectIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (!((TIntSet)iter.value()).contains(right)) continue;
            ++computedSize;
        }
        return computedSize;
    }

    @Override
    public int[] leftValues(int right) {
        if (this.rightMap != null) {
            TIntSet leftSet = (TIntSet)this.rightMap.get(right);
            if (leftSet != null) {
                int[] leftArray = new int[leftSet.size()];
                leftSet.toArray(leftArray);
                return leftArray;
            }
            return new int[0];
        }
        TIntObjectIterator iter = this.leftMap.iterator();
        TIntHashSet leftSet = new TIntHashSet();
        while (iter.hasNext()) {
            iter.advance();
            if (!((TIntSet)iter.value()).contains(right)) continue;
            leftSet.add(iter.key());
        }
        return leftSet.toArray();
    }

    @Override
    public boolean remove(int left, int right) {
        TIntSet leftSet;
        if (!this.contains(left, right)) {
            return false;
        }
        --this.size;
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet != null) {
            rightSet.remove(right);
            if (rightSet.isEmpty()) {
                this.leftMap.remove(left);
            }
        }
        if (this.rightMap != null && (leftSet = (TIntSet)this.rightMap.get(right)) != null) {
            leftSet.remove(left);
            if (leftSet.isEmpty()) {
                this.rightMap.remove(right);
            }
        }
        return true;
    }

    @Override
    public boolean removeLeftValue(int left) {
        if (!this.containsLeftValue(left)) {
            return false;
        }
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet != null) {
            this.size -= rightSet.size();
        }
        this.leftMap.remove(left);
        if (this.rightMap != null) {
            TIntObjectIterator iter = this.rightMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                ((TIntSet)iter.value()).remove(left);
                if (!((TIntSet)iter.value()).isEmpty()) continue;
                iter.remove();
            }
        }
        return true;
    }

    @Override
    public boolean removeRightValue(int right) {
        if (!this.containsRightValue(right)) {
            return false;
        }
        TIntObjectIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            boolean found = ((TIntSet)iter.value()).remove(right);
            if (!found) continue;
            --this.size;
            if (!((TIntSet)iter.value()).isEmpty()) continue;
            iter.remove();
        }
        if (this.rightMap != null) {
            this.rightMap.remove(right);
        }
        return true;
    }

    @Override
    public int rightSize(int left, Collection<Integer> filterRightIds) {
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet == null) {
            return 0;
        }
        if (CollectionHelper.isEmpty(filterRightIds)) {
            return rightSet.size();
        }
        int count = 0;
        TIntIterator iter = rightSet.iterator();
        while (iter.hasNext()) {
            if (!filterRightIds.contains(iter.next())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int rightSize(int left, TIntSet filterRightIds) {
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet == null) {
            return 0;
        }
        if (filterRightIds == null || filterRightIds.isEmpty()) {
            return rightSet.size();
        }
        int count = 0;
        TIntIterator iter = rightSet.iterator();
        while (iter.hasNext()) {
            if (!filterRightIds.contains(iter.next())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int[] rightValues(int left) {
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet != null) {
            int[] rightArray = new int[rightSet.size()];
            rightSet.toArray(rightArray);
            return rightArray;
        }
        return new int[0];
    }

    @Override
    public TIntSet rightValuesIntegerSet(int left) {
        TIntSet rightSet = (TIntSet)this.leftMap.get(left);
        if (rightSet != null) {
            return new TIntHashSet((TIntCollection)rightSet);
        }
        return new TIntHashSet(0);
    }

    @Override
    public IntegerRelationIterator iterator() {
        return new IntegerRelationIterator(){
            private int left = 0;
            private int right = 0;
            private TIntObjectIterator<TIntSet> mapIterator;
            private TIntIterator setIterator;
            {
                this.mapIterator = ManyToManyIntegerRelation.this.leftMap.iterator();
                this.setIterator = null;
            }

            @Override
            public boolean hasNext() {
                return this.setIterator != null && this.setIterator.hasNext() || this.mapIterator.hasNext();
            }

            @Override
            public int left() {
                if (this.setIterator == null) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.left;
            }

            @Override
            public void next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Attempt to iterate past iterator's last element.");
                }
                if (this.setIterator != null && this.setIterator.hasNext()) {
                    this.right = this.setIterator.next();
                } else {
                    this.mapIterator.advance();
                    TIntSet currentSet = (TIntSet)this.mapIterator.value();
                    this.setIterator = currentSet.iterator();
                    this.left = this.mapIterator.key();
                    this.right = this.setIterator.next();
                }
            }

            @Override
            public int right() {
                if (this.setIterator == null) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.right;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

