/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection.relation;

import com.techempower.collection.relation.AbstractIntegerRelation;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.IntegerRelationIterator;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.NoSuchElementException;

public class OneToManyIntegerRelation
extends AbstractIntegerRelation {
    private final TIntObjectMap<TIntSet> leftMap;
    private final TIntIntMap rightMap = new TIntIntHashMap();
    private int size;

    public OneToManyIntegerRelation() {
        this(null, false);
    }

    public OneToManyIntegerRelation(IntegerRelation relation) {
        this(relation, false);
    }

    public OneToManyIntegerRelation(boolean doublyMapped) {
        this(null, doublyMapped);
    }

    public OneToManyIntegerRelation(IntegerRelation relation, boolean doublyMapped) {
        this.leftMap = doublyMapped ? new TIntObjectHashMap() : null;
        this.addAll(relation);
    }

    @Override
    public boolean add(int left, int right) {
        if (this.containsRightValue(right)) {
            return false;
        }
        ++this.size;
        if (this.leftMap != null) {
            TIntSet rightSet = (TIntSet)this.leftMap.get(left);
            if (rightSet == null) {
                rightSet = new TIntHashSet();
                this.leftMap.put(left, (Object)rightSet);
            }
            rightSet.add(right);
        }
        this.rightMap.put(right, left);
        return true;
    }

    @Override
    public void clear() {
        if (this.leftMap != null) {
            this.leftMap.clear();
        }
        this.rightMap.clear();
        this.size = 0;
    }

    @Override
    public Object clone() {
        return new OneToManyIntegerRelation(this, this.leftMap != null);
    }

    @Override
    public boolean contains(int left, int right) {
        return this.rightMap.containsKey(right) && this.rightMap.get(right) == left;
    }

    @Override
    public boolean containsLeftValue(int left) {
        if (this.leftMap != null) {
            return this.leftMap.containsKey(left);
        }
        return this.rightMap.containsValue(left);
    }

    @Override
    public boolean containsRightValue(int right) {
        return this.rightMap.containsKey(right);
    }

    @Override
    public int leftSize(int right) {
        return this.rightMap.containsKey(right) ? 1 : 0;
    }

    @Override
    public int[] leftValues(int right) {
        if (this.rightMap.containsKey(right)) {
            return new int[]{this.rightMap.get(right)};
        }
        return new int[0];
    }

    @Override
    public boolean remove(int left, int right) {
        TIntSet rightSet;
        if (!this.contains(left, right)) {
            return false;
        }
        --this.size;
        if (this.leftMap != null && (rightSet = (TIntSet)this.leftMap.get(left)) != null) {
            rightSet.remove(right);
            if (rightSet.isEmpty()) {
                this.leftMap.remove(left);
            }
        }
        this.rightMap.remove(right);
        return true;
    }

    @Override
    public boolean removeLeftValue(int left) {
        if (!this.containsLeftValue(left)) {
            return false;
        }
        if (this.leftMap != null) {
            this.leftMap.remove(left);
        }
        TIntIntIterator iter = this.rightMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != left) continue;
            iter.remove();
            --this.size;
        }
        return true;
    }

    @Override
    public boolean removeRightValue(int right) {
        if (!this.containsRightValue(right)) {
            return false;
        }
        --this.size;
        if (this.leftMap != null) {
            TIntObjectIterator iter = this.leftMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                ((TIntSet)iter.value()).remove(right);
                if (!((TIntSet)iter.value()).isEmpty()) continue;
                iter.remove();
            }
        }
        this.rightMap.remove(right);
        return true;
    }

    @Override
    public int rightSize(int left) {
        if (this.leftMap != null) {
            TIntSet rightSet = (TIntSet)this.leftMap.get(left);
            return rightSet == null ? 0 : rightSet.size();
        }
        int computedSize = 0;
        TIntIntIterator iter = this.rightMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != left) continue;
            ++computedSize;
        }
        return computedSize;
    }

    @Override
    public int[] rightValues(int left) {
        if (this.leftMap != null) {
            TIntSet rightSet = (TIntSet)this.leftMap.get(left);
            if (rightSet != null) {
                int[] rightArray = new int[rightSet.size()];
                rightSet.toArray(rightArray);
                return rightArray;
            }
            return new int[0];
        }
        TIntHashSet rightSet = new TIntHashSet();
        TIntIntIterator iter = this.rightMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != left) continue;
            rightSet.add(iter.key());
        }
        return rightSet.toArray();
    }

    @Override
    public TIntSet rightValuesIntegerSet(int left) {
        if (this.leftMap != null) {
            TIntSet rightSet = (TIntSet)this.leftMap.get(left);
            if (rightSet != null) {
                return new TIntHashSet((TIntCollection)rightSet);
            }
            return new TIntHashSet(0);
        }
        TIntHashSet rightSet = new TIntHashSet();
        TIntIntIterator iter = this.rightMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != left) continue;
            rightSet.add(iter.key());
        }
        return new TIntHashSet((TIntCollection)rightSet);
    }

    @Override
    public IntegerRelationIterator iterator() {
        return new IntegerRelationIterator(){
            private boolean start = false;
            private int left = 0;
            private int right = 0;
            private TIntIntIterator mapIterator;
            {
                this.mapIterator = OneToManyIntegerRelation.this.rightMap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public int left() {
                if (!this.start) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.left;
            }

            @Override
            public void next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Attempt to iterate past iterator's last element.");
                }
                this.mapIterator.advance();
                this.left = this.mapIterator.value();
                this.right = this.mapIterator.key();
                this.start = true;
            }

            @Override
            public int right() {
                if (!this.start) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.right;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

