/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data;

import com.techempower.collection.ReflectiveFilter;
import com.techempower.data.mapping.DataFieldToMethodMap;
import com.techempower.data.mapping.DataFieldToVariableMap;
import com.techempower.data.mapping.DataMappingCache;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.Identifiable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DataEntityFilter
extends ReflectiveFilter {
    private Class<?> dataEntityClass = null;

    public DataEntityFilter(Identifiable entity) {
        this.bindToDataEntity(entity);
    }

    public DataEntityFilter(Class<?> entityClass) {
        this.bindToDataEntity(entityClass);
    }

    public void bindToDataEntity(Identifiable entity) {
        if (entity != null) {
            this.bindToDataEntity(entity.getClass());
        }
    }

    public void bindToDataEntity(Class<?> entityClass) {
        if (entityClass != null) {
            this.dataEntityClass = entityClass;
        }
    }

    protected boolean allow(Object value, Object filterValue) {
        if (!this.isStrict() && filterValue instanceof String && value instanceof String && !StringHelper.containsIgnoreCase((String)value, (String)filterValue)) {
            return false;
        }
        return super.allow(value, filterValue);
    }

    @Override
    protected Field getFieldForName(String fieldName, Object o) throws NoSuchFieldException {
        if (this.dataEntityClass == null) {
            throw new NoSuchFieldException();
        }
        DataFieldToVariableMap[] mappings = DataMappingCache.getFieldMappings(this.dataEntityClass);
        if (CollectionHelper.isEmpty(mappings)) {
            throw new NoSuchFieldException();
        }
        DataFieldToVariableMap[] dataFieldToVariableMapArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldToVariableMap map = dataFieldToVariableMapArray[n2];
            if (map.getFieldName().equalsIgnoreCase(fieldName)) {
                return map.getVariable();
            }
            ++n2;
        }
        throw new NoSuchFieldException();
    }

    @Override
    protected Method getMethodForName(String methodName, Object o) throws NoSuchMethodException {
        if (this.dataEntityClass == null) {
            throw new NoSuchMethodException();
        }
        DataFieldToMethodMap[] mappings = DataMappingCache.getGetMethodMappings(this.dataEntityClass);
        if (CollectionHelper.isEmpty(mappings)) {
            throw new NoSuchMethodException();
        }
        DataFieldToMethodMap[] dataFieldToMethodMapArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldToMethodMap map = dataFieldToMethodMapArray[n2];
            if (map.getFieldName().equalsIgnoreCase(methodName)) {
                return map.getMethod();
            }
            ++n2;
        }
        throw new NoSuchMethodException();
    }
}

