/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data;

import com.techempower.data.DatabaseConnector;
import com.techempower.data.mapping.DatabaseColumnMetaData;
import com.techempower.data.mapping.DatabaseTableMetaData;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;

public class DatabaseResultsPager
implements DatabaseConnector {
    public static final int DEFAULT_PAGE_SIZE = 20;
    private final DatabaseConnector dbConn;
    private final int rows;
    private int pageSize = 20;
    private int currentPage = 1;
    private boolean moreBehavior = true;

    public DatabaseResultsPager(DatabaseConnector dbConn) {
        this.dbConn = dbConn;
        dbConn.last();
        this.rows = dbConn.getRowNumber();
        dbConn.first();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        if (this.rows % this.pageSize == 0) {
            return this.rows / this.pageSize;
        }
        return this.rows / this.pageSize + 1;
    }

    public boolean setPage(int pageNumber) {
        if (pageNumber >= 1 && pageNumber <= this.getPageCount()) {
            this.moveAbsolute(this.pageSize * (pageNumber - 1));
            this.currentPage = pageNumber;
            return true;
        }
        return false;
    }

    public int getPage() {
        return this.currentPage;
    }

    public int getPageForRow(int rowNumber) {
        return (rowNumber - 1) / this.pageSize + 1;
    }

    public boolean moreOnPage() {
        if (this.currentPage == this.getPageCount()) {
            return this.getRowNumber() < this.rows + 1;
        }
        return this.getRowNumber() < this.getPage() * this.getPageSize() + 1;
    }

    public void setMorePagedBehavior(boolean pagedBehavior) {
        this.moreBehavior = pagedBehavior;
    }

    @Override
    public void close() {
        this.dbConn.close();
    }

    @Override
    public int[] executeBatch(Collection<String> sqlCommands) {
        return this.dbConn.executeBatch(sqlCommands);
    }

    @Override
    public void first() {
        this.dbConn.first();
    }

    @Override
    public boolean getBoolean(String fieldName) {
        return this.dbConn.getBoolean(fieldName);
    }

    @Override
    public BigDecimal getBigDecimal(String fieldName) {
        return this.dbConn.getBigDecimal(fieldName);
    }

    @Override
    public byte getByte(String fieldName) {
        return this.dbConn.getByte(fieldName);
    }

    @Override
    public String getClob(String fieldName) {
        return this.dbConn.getClob(fieldName);
    }

    @Override
    public Date getDate(String fieldName) {
        return this.dbConn.getDate(fieldName);
    }

    @Override
    public Calendar getDateAsCalendar(String fieldName) {
        return this.dbConn.getDateAsCalendar(fieldName);
    }

    @Override
    public double getDouble(String fieldName) {
        return this.dbConn.getDouble(fieldName);
    }

    @Override
    public String getField(String fieldName, String defaultValue) {
        return this.dbConn.getField(fieldName, defaultValue);
    }

    @Override
    public String getFieldByName(String fieldName) {
        return this.dbConn.getFieldByName(fieldName);
    }

    @Override
    public String[] getFieldNames() {
        return this.dbConn.getFieldNames();
    }

    @Override
    public int[] getFieldTypes() {
        return this.dbConn.getFieldTypes();
    }

    @Override
    public float getFloat(String fieldName) {
        return this.dbConn.getFloat(fieldName);
    }

    @Override
    public boolean getForwardOnly() {
        return this.dbConn.getForwardOnly();
    }

    @Override
    public int getInt(String fieldName) {
        return this.dbConn.getInt(fieldName);
    }

    @Override
    public int getInt(String fieldName, int defaultValue) {
        return this.dbConn.getInt(fieldName, defaultValue);
    }

    @Override
    public int getIntegerField(String fieldName) {
        return this.dbConn.getIntegerField(fieldName);
    }

    @Override
    public int getIntegerFieldByName(String fieldName) {
        return this.dbConn.getIntegerFieldByName(fieldName);
    }

    @Override
    public long getLong(String fieldName) {
        return this.dbConn.getLong(fieldName);
    }

    @Override
    public String getQuery() {
        return this.dbConn.getQuery();
    }

    @Override
    public boolean getReadOnly() {
        return this.dbConn.getReadOnly();
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getRowNumber() {
        return this.dbConn.getRowNumber();
    }

    @Override
    public short getShort(String fieldName) {
        return this.dbConn.getShort(fieldName);
    }

    @Override
    public Time getTime(String fieldName) {
        return this.dbConn.getTime(fieldName);
    }

    @Override
    public Timestamp getTimestamp(String fieldName) {
        return this.dbConn.getTimestamp(fieldName);
    }

    @Override
    public void last() {
        this.dbConn.last();
    }

    @Override
    public boolean more() {
        if (this.moreBehavior) {
            return this.dbConn.more() && this.moreOnPage();
        }
        return this.dbConn.more();
    }

    @Override
    public void moveAbsolute(int position) {
        this.dbConn.moveAbsolute(position);
    }

    @Override
    public void next() {
        this.dbConn.next();
    }

    @Override
    public int runQuery() {
        return this.dbConn.runQuery();
    }

    @Override
    public int runQuery(boolean safeMode) {
        return this.dbConn.runQuery(safeMode);
    }

    @Override
    public int runUpdateQuery() {
        return this.dbConn.runUpdateQuery();
    }

    @Override
    public int runUpdateQuery(boolean safeMode) {
        return this.dbConn.runUpdateQuery(safeMode);
    }

    @Override
    public void setForwardOnly(boolean forwardOnly) {
        this.dbConn.setForwardOnly(forwardOnly);
    }

    @Override
    public void setQuery(String query) {
        this.dbConn.setQuery(query);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.dbConn.setReadOnly(readOnly);
    }

    @Override
    public void setForceNewConnection(boolean newConnection) {
        this.dbConn.setForceNewConnection(newConnection);
    }

    @Override
    public Collection<DatabaseTableMetaData> getTableMetaData() {
        return this.dbConn.getTableMetaData();
    }

    @Override
    public DatabaseTableMetaData getTableMetaData(String tableName) {
        return this.dbConn.getTableMetaData(tableName);
    }

    @Override
    public Collection<DatabaseColumnMetaData> getColumnMetaDataForTable(String tableName) {
        return this.dbConn.getColumnMetaDataForTable(tableName);
    }

    @Override
    public Collection<DatabaseColumnMetaData> getColumnMetaDataFromResultSet() {
        return this.dbConn.getColumnMetaDataFromResultSet();
    }

    @Override
    public byte[] getBytes(String fieldName) {
        return this.dbConn.getBytes(fieldName);
    }

    @Override
    public boolean wasNull() {
        return this.dbConn.wasNull();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dbConn.getConnection();
    }

    @Override
    public ResultSet getResultSet() {
        return this.dbConn.getResultSet();
    }

    @Override
    public Object getObject(String fieldName) {
        return this.dbConn.getObject(fieldName);
    }

    @Override
    public void reconnect() {
        this.dbConn.reconnect();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.dbConn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.dbConn.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.dbConn.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.dbConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.dbConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.dbConn.prepareStatement(sql, columnNames);
    }
}

