/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.techempower.cache.CacheAware;
import com.techempower.cache.EntityStore;
import com.techempower.collection.ReflectiveComparator;
import com.techempower.data.ConnectionMonitor;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseConnector;
import com.techempower.data.EntityException;
import com.techempower.data.EntityMaker;
import com.techempower.data.mapping.DataFieldToMethodMap;
import com.techempower.data.mapping.DataFieldToObjectEntityMap;
import com.techempower.data.mapping.DataMappingCache;
import com.techempower.data.mapping.DatabaseColumnMetaData;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.reflect.TypeAdapter;
import com.techempower.util.Identifiable;
import com.techempower.util.Initializable;
import com.techempower.util.PersistenceAware;
import com.techempower.util.StringList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EntityGroup<T extends Identifiable> {
    private static final Comparator<Identifiable> ID_COMPARATOR = new Comparator<Identifiable>(){

        @Override
        public int compare(Identifiable o1, Identifiable o2) {
            return Integer.compare(o1.getId(), o2.getId());
        }
    };
    private static final TypeAdapter<Object, Object> NO_ADAPTER = new TypeAdapter<Object, Object>(){

        @Override
        public Object write(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object read(Object value) {
            throw new UnsupportedOperationException();
        }
    };
    private final EntityStore controller;
    private final ConnectorFactory cf;
    private final Class<T> type;
    private final String table;
    private final String id;
    private final String where;
    private final String[] whereArguments;
    private final EntityMaker<T> maker;
    private final Comparator<? super T> comparator;
    private final MethodAccess access;
    private final ComponentLog log;
    private final String quotedTable;
    private final String quotedIdField;
    private final String getSingleQuery;
    private final String deleteSingleQuery;
    private DataFieldToMethodMap[] setMethods = null;
    private DataFieldToMethodMap[] getMethods = null;
    private DataFieldToMethodMap[] getMethodsWithoutId = null;
    private String fieldPartsForUpdate = null;
    private final Map<String, TypeAdapter<?, ?>> typeAdaptersByFieldName = new ConcurrentHashMap();
    private int groupNumber;

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return NaturalOrderComparator.INSTANCE;
    }

    public static <C extends Identifiable> Comparator<? super C> defaultComparator(Class<C> type) {
        if (Comparable.class.isAssignableFrom(type)) {
            return EntityGroup.naturalOrder();
        }
        return ID_COMPARATOR;
    }

    protected EntityGroup(EntityStore controller, Class<T> type, String table, String id, EntityMaker<T> maker, Comparator<? super T> comparator, String where, String[] whereArguments) {
        this.type = type;
        this.access = MethodAccess.get(this.type);
        this.controller = controller;
        this.cf = controller.getConnectorFactory();
        this.maker = maker == null ? new EntityMaker<T>(){

            @Override
            public T make() {
                try {
                    return (Identifiable)EntityGroup.this.type.newInstance();
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    return null;
                }
            }
        } : maker;
        this.table = table == null ? type.getSimpleName().toLowerCase() : table;
        this.id = id == null ? "id" : id;
        this.where = where;
        this.whereArguments = whereArguments != null ? (String[])whereArguments.clone() : null;
        this.comparator = comparator == null ? EntityGroup.defaultComparator(type) : comparator;
        this.quotedIdField = this.enquote(this.id);
        this.quotedTable = this.enquote(this.table);
        this.getSingleQuery = "SELECT * FROM " + this.quotedTable + " WHERE " + this.quotedIdField + " = ?";
        this.deleteSingleQuery = "DELETE FROM " + this.quotedTable + " WHERE " + this.quotedIdField + " = ?";
        this.log = controller.getEntityLog();
    }

    public Class<T> type() {
        return this.type;
    }

    public String table() {
        return this.table;
    }

    public String id() {
        return this.id;
    }

    public EntityMaker<T> maker() {
        return this.maker;
    }

    public void reset() {
    }

    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(int groupNumber) {
        this.groupNumber = groupNumber;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Deprecated
    public int getSize() {
        return 0;
    }

    /*
     * Exception decompiling
     */
    public T get(int idToGet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(T object) {
        if (this.isPersisted((Identifiable)object)) {
            this.update(object);
        } else {
            this.insert(object);
        }
    }

    @SafeVarargs
    public final void putAll(T ... objects) {
        this.putAll((Collection<T>)CollectionHelper.toList(objects));
    }

    public void putAll(Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        if (objects.size() < 100) {
            for (Identifiable object : objects) {
                this.put(object);
            }
        } else {
            ArrayList<Identifiable> persisted = null;
            ArrayList<Identifiable> nonPersisted = null;
            for (Identifiable object : objects) {
                if (this.isPersisted(object)) {
                    if (persisted == null) {
                        persisted = new ArrayList<Identifiable>(objects.size());
                    }
                    persisted.add(object);
                    continue;
                }
                if (nonPersisted == null) {
                    nonPersisted = new ArrayList<Identifiable>(objects.size());
                }
                nonPersisted.add(object);
            }
            this.updateAll(persisted);
            this.insertAll(nonPersisted);
        }
    }

    public void remove(int idToRemove) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement(String.valueOf(this.deleteSingleQuery) + this.getWhereClause(" AND ") + ";");){
                        statement.setInt(1, idToRemove);
                        this.attachWhereArguments(2, statement);
                        statement.executeUpdate();
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new EntityException("Exception during DELETE.", e);
        }
    }

    public void removeAll(Collection<Integer> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedIdField + " IN (" + StringHelper.join(",", Collections.nCopies(ids.size(), "?")) + ")" + this.getWhereClause(" AND ") + ";");){
                        int i = 0;
                        for (int idToDelete : ids) {
                            statement.setInt(++i, idToDelete);
                        }
                        this.attachWhereArguments(ids.size() + 1, statement);
                        statement.executeUpdate();
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new EntityException("Exception during DELETE (removeAll).", e);
        }
    }

    /*
     * Exception decompiling
     */
    public int size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<T> list() {
        ArrayList<T> objects = new ArrayList<T>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("SELECT * FROM " + this.quotedTable + this.getWhereClause(" WHERE ") + ";", 1003, 1007);){
                        this.attachWhereArguments(1, statement);
                        Throwable throwable2 = null;
                        Object var7_12 = null;
                        try (ResultSet resultSet = statement.executeQuery();){
                            while (resultSet.next()) {
                                T object = this.make(resultSet);
                                objects.add(object);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new EntityException("Exception during SELECT (list).", e);
        }
        Collections.sort(objects, this.comparator);
        return objects;
    }

    public List<T> list(Collection<Integer> ids) {
        TIntObjectMap<T> map = this.map(ids);
        ArrayList<Identifiable> list = new ArrayList<Identifiable>(ids.size());
        for (int idToList : ids) {
            Identifiable object = (Identifiable)map.get(idToList);
            if (object == null) continue;
            list.add(object);
        }
        return list;
    }

    public TIntObjectMap<T> map() {
        TIntObjectHashMap objects = new TIntObjectHashMap();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("SELECT * FROM " + this.quotedTable + this.getWhereClause(" WHERE ") + ";", 1003, 1007);){
                        this.attachWhereArguments(1, statement);
                        Throwable throwable2 = null;
                        Object var7_12 = null;
                        try (ResultSet resultSet = statement.executeQuery();){
                            while (resultSet.next()) {
                                T object = this.make(resultSet);
                                objects.put(object.getId(), object);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new EntityException("Exception during SELECT (map).", e);
        }
        return objects;
    }

    public TIntObjectMap<T> map(Collection<Integer> ids) {
        if (ids.isEmpty()) {
            return new TIntObjectHashMap(0);
        }
        TIntObjectHashMap objects = new TIntObjectHashMap(ids.size());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("SELECT * FROM " + this.quotedTable + " WHERE " + this.quotedIdField + " IN (" + StringHelper.join(",", Collections.nCopies(ids.size(), "?")) + ")" + this.getWhereClause(" AND ") + ";", 1003, 1007);){
                        int i = 0;
                        for (int idToSet : ids) {
                            statement.setInt(++i, idToSet);
                        }
                        this.attachWhereArguments(ids.size() + 1, statement);
                        Throwable throwable2 = null;
                        Iterator<Integer> iterator = null;
                        try (ResultSet resultSet = statement.executeQuery();){
                            while (resultSet.next()) {
                                T object = this.make(resultSet);
                                objects.put(object.getId(), object);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new EntityException("Exception during SELECT (map).", e);
        }
        return objects;
    }

    public int lowest() {
        return this.identityAggregate("MIN");
    }

    public int highest() {
        return this.identityAggregate("MAX");
    }

    public List<T> query(String query, Object ... arguments) throws SQLException {
        ArrayList<T> objects = new ArrayList<T>();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            ConnectionMonitor monitor = this.cf.getConnectionMonitor();
            try {
                try (PreparedStatement statement = monitor.getConnection().prepareStatement(query);){
                    int index = 1;
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object argument = objectArray[n2];
                        if (argument instanceof java.util.Date) {
                            statement.setDate(index++, new Date(((java.util.Date)argument).getTime()));
                        } else {
                            statement.setObject(index++, argument);
                        }
                        ++n2;
                    }
                    Throwable throwable2 = null;
                    Object var10_16 = null;
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            T object = this.make(resultSet);
                            objects.add(object);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (monitor != null) {
                    monitor.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (monitor != null) {
                    monitor.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        return objects;
    }

    protected void insert(T object) {
        DataFieldToMethodMap[] fields = object.getId() > 0 ? this.getGetMethodMappingCache() : this.getGetMethodMappingCacheWithoutId();
        StringList fieldsPart = new StringList(", ");
        int i2 = 0;
        while (i2 < fields.length) {
            fieldsPart.add(this.enquote(fields[i2].getFieldName()));
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var5_8 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block31: {
                        try (PreparedStatement statement = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + fieldsPart.toString() + ") VALUES (" + StringHelper.join(", ", Collections.nCopies(fields.length, "?")) + ");", 1);){
                            int index = 1;
                            int i3 = 0;
                            while (i3 < fields.length) {
                                Object value = this.readValueForUpdate(object, fields[i3]);
                                this.applyValueToStatement(fields[i3], value, statement, index++);
                                ++i3;
                            }
                            statement.executeUpdate();
                            if (object instanceof PersistenceAware) {
                                ((PersistenceAware)object).setPersisted(true);
                            }
                            if (object.getId() > 0) break block31;
                            Throwable throwable = null;
                            Object var10_17 = null;
                            try (ResultSet resultSet = statement.getGeneratedKeys();){
                                if (resultSet.next()) {
                                    object.setId(resultSet.getInt(1));
                                    break block31;
                                }
                                throw new EntityException("Identity not returned from INSERT.");
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw i2;
                }
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (SQLException e) {
            throw new EntityException("Exception during INSERT.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void insertAll(Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        ArrayList<Identifiable> objectsWithId = new ArrayList<Identifiable>(objects.size());
        ArrayList<Identifiable> objectsWithoutId = new ArrayList<Identifiable>(objects.size());
        for (Identifiable object : objects) {
            if (object.getId() > 0) {
                objectsWithId.add(object);
                continue;
            }
            objectsWithoutId.add(object);
        }
        DataFieldToMethodMap[] cache = this.getGetMethodMappingCache();
        ArrayList<DataFieldToMethodMap> fieldsWithId = new ArrayList<DataFieldToMethodMap>();
        ArrayList<DataFieldToMethodMap> fieldsWithoutId = new ArrayList<DataFieldToMethodMap>();
        Object object = cache;
        int n = cache.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldToMethodMap field = object[n2];
            fieldsWithId.add(field);
            if (!field.getFieldName().equalsIgnoreCase(this.id)) {
                fieldsWithoutId.add(field);
            }
            ++n2;
        }
        StringList fieldsPartWithId = new StringList(", ");
        for (DataFieldToMethodMap field : fieldsWithId) {
            fieldsPartWithId.add(this.enquote(field.getFieldName()));
        }
        StringList fieldsPartWithoutId = new StringList(", ");
        for (DataFieldToMethodMap dataFieldToMethodMap : fieldsWithoutId) {
            fieldsPartWithoutId.add(this.enquote(dataFieldToMethodMap.getFieldName()));
        }
        try {
            Throwable throwable = null;
            object = null;
            try (ConnectionMonitor monitor = this.cf.getConnectionMonitor();){
                Throwable throwable2 = null;
                Object var13_25 = null;
                try (PreparedStatement statementWithId = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + fieldsPartWithId.toString() + ") VALUES (" + StringHelper.join(", ", Collections.nCopies(fieldsWithId.size(), "?")) + ");");){
                    Throwable throwable3 = null;
                    Object var16_30 = null;
                    try (PreparedStatement statementWithoutId = monitor.getConnection().prepareStatement("INSERT INTO " + this.quotedTable + " (" + fieldsPartWithoutId.toString() + ") VALUES (" + StringHelper.join(", ", Collections.nCopies(fieldsWithoutId.size(), "?")) + ");", 1);){
                        Object value;
                        int index;
                        for (Identifiable identifiable : objectsWithId) {
                            index = 1;
                            for (DataFieldToMethodMap field2 : fieldsWithId) {
                                value = this.readValueForUpdate(identifiable, field2);
                                this.applyValueToStatement(field2, value, statementWithId, index++);
                            }
                            statementWithId.addBatch();
                        }
                        for (Identifiable identifiable : objectsWithoutId) {
                            index = 1;
                            for (DataFieldToMethodMap field : fieldsWithoutId) {
                                value = this.readValueForUpdate(identifiable, field);
                                this.applyValueToStatement(field, value, statementWithoutId, index++);
                            }
                            statementWithoutId.addBatch();
                        }
                        if (!objectsWithId.isEmpty()) {
                            statementWithId.executeBatch();
                        }
                        if (!objectsWithoutId.isEmpty()) {
                            statementWithoutId.executeBatch();
                            Throwable throwable4 = null;
                            Iterator<Object> iterator = null;
                            try (ResultSet resultSet = statementWithoutId.getGeneratedKeys();){
                                int i = 0;
                                while (resultSet.next()) {
                                    int identity = resultSet.getInt(1);
                                    ((Identifiable)objectsWithoutId.get(i++)).setId(identity);
                                }
                                if (i != objectsWithoutId.size()) {
                                    throw new EntityException("One or more identities not returned after INSERT.");
                                }
                            }
                            catch (Throwable throwable5) {
                                void var18_41;
                                if (throwable4 == null) {
                                    Throwable throwable6 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw var18_41;
                            }
                        }
                        for (Identifiable identifiable : objects) {
                            if (!(identifiable instanceof PersistenceAware)) continue;
                            ((PersistenceAware)((Object)identifiable)).setPersisted(true);
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable3 == null) {
                            throwable3 = throwable7;
                        } else if (throwable3 != throwable7) {
                            throwable3.addSuppressed(throwable7);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable2 == null) {
                        throwable2 = throwable8;
                    } else if (throwable2 != throwable8) {
                        throwable2.addSuppressed(throwable8);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable9) {
                void var9_16;
                if (throwable == null) {
                    Throwable throwable10 = throwable9;
                } else if (throwable != throwable9) {
                    throwable.addSuppressed(throwable9);
                }
                throw var9_16;
            }
        }
        catch (SQLException sQLException) {
            throw new EntityException("Exception during INSERT.", sQLException);
        }
    }

    protected void update(T object) {
        DataFieldToMethodMap[] fields = this.getGetMethodMappingCacheWithoutId();
        String fieldParts = this.getFieldPartsForUpdate();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("UPDATE " + this.quotedTable + " SET " + fieldParts + " WHERE " + this.quotedIdField + " = ?" + this.getWhereClause(" AND ") + ";");){
                        statement.setInt(fields.length + 1, object.getId());
                        this.attachWhereArguments(fields.length + 2, statement);
                        int index = 1;
                        DataFieldToMethodMap[] dataFieldToMethodMapArray = fields;
                        int n = fields.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DataFieldToMethodMap field = dataFieldToMethodMapArray[n2];
                            Object value = this.readValueForUpdate(object, field);
                            this.applyValueToStatement(field, value, statement, index++);
                            ++n2;
                        }
                        statement.executeUpdate();
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException("Exception during UPDATE.", e);
        }
    }

    protected void updateAll(Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        DataFieldToMethodMap[] fields = this.getGetMethodMappingCacheWithoutId();
        String fieldParts = this.getFieldPartsForUpdate();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("UPDATE " + this.quotedTable + " SET " + fieldParts + " WHERE " + this.quotedIdField + " = ?" + this.getWhereClause(" AND ") + ";");){
                        for (Identifiable object : objects) {
                            statement.setInt(fields.length + 1, object.getId());
                            this.attachWhereArguments(fields.length + 2, statement);
                            int index = 1;
                            DataFieldToMethodMap[] dataFieldToMethodMapArray = fields;
                            int n = fields.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DataFieldToMethodMap field = dataFieldToMethodMapArray[n2];
                                Object value = this.readValueForUpdate(object, field);
                                this.applyValueToStatement(field, value, statement, index++);
                                ++n2;
                            }
                            statement.addBatch();
                        }
                        statement.executeBatch();
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException("Exception during UPDATE.", e);
        }
    }

    protected int identityAggregate(String sqlAggregateFunction) {
        int result = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement statement = monitor.getConnection().prepareStatement("SELECT " + sqlAggregateFunction + "(" + this.quotedIdField + ") " + "AS Result FROM " + this.quotedTable + ";", 1003, 1007);){
                        Throwable throwable2 = null;
                        Object var8_13 = null;
                        try (ResultSet resultSet = statement.executeQuery();){
                            if (resultSet.next()) {
                                result = resultSet.getInt(1);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException("Exception during identity aggregate.", e);
        }
        return result;
    }

    public void reorder(int ... ids) {
    }

    public void refresh(int ... ids) {
    }

    private String getWhereClause(String prefix) {
        if (this.where != null) {
            return String.valueOf(prefix) + "(" + this.where + ")";
        }
        return "";
    }

    private int attachWhereArguments(int startingIndex, PreparedStatement statement) throws SQLException {
        int index = startingIndex;
        if (this.whereArguments != null) {
            String[] stringArray = this.whereArguments;
            int n = this.whereArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                statement.setString(index++, argument);
                ++n2;
            }
        }
        return index;
    }

    public void readMap(T object, Map<String, Object> properties) {
        DataFieldToMethodMap[] dataFieldToMethodMapArray = this.getSetMethodMappingCache(null);
        int n = dataFieldToMethodMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldToMethodMap map = dataFieldToMethodMapArray[n2];
            try {
                Object value = properties.get(map.getFieldName());
                if (value instanceof String && map.getMethod().getParameterTypes()[0].isEnum()) {
                    value = Enum.valueOf(map.getMethod().getParameterTypes()[0], String.valueOf(value));
                }
                this.access.invoke(object, map.getMethodIndex(), new Object[]{value});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public T newObjectFromMap(Map<String, Object> properties) {
        T object = this.maker().make();
        this.readMap(object, properties);
        return object;
    }

    public T updateObjectFromMap(T object, Map<String, Object> properties) {
        this.readMap(object, properties);
        return object;
    }

    public Map<String, Object> writeMap(T object) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        DataFieldToMethodMap[] dataFieldToMethodMapArray = this.getGetMethodMappingCache();
        int n = dataFieldToMethodMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldToMethodMap map = dataFieldToMethodMapArray[n2];
            try {
                Object value = this.access.invoke(object, map.getMethodIndex(), EntityStore.NO_VALUES);
                if (value != null && map.getMethod().getReturnType().isEnum()) {
                    value = ((Enum)value).name();
                }
                properties.put(map.getFieldName(), value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
        return properties;
    }

    public Map<String, String> writeStringMap(T object) {
        Map<String, Object> map = this.writeMap(object);
        HashMap<String, String> stringMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            stringMap.put(entry.getKey(), "" + entry.getValue());
        }
        return stringMap;
    }

    private Object readValueForUpdate(T object, DataFieldToMethodMap field) {
        Object value = null;
        try {
            value = this.access.invoke(object, field.getMethodIndex(), EntityStore.NO_VALUES);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.serialize(field, value);
    }

    private TypeAdapter<Object, Object> getTypeAdapter(DataFieldToMethodMap field, boolean isGetMethod) {
        TypeAdapter<Object, Object> knownAdapter = this.typeAdaptersByFieldName.get(field.getFieldName());
        if (knownAdapter == null) {
            for (TypeAdapter<?, ?> adapter : this.controller.getTypeAdapters()) {
                if ((!isGetMethod || !adapter.appliesToGetMethod(field.getMethod())) && (isGetMethod || !adapter.appliesToSetMethod(field.getMethod()))) continue;
                knownAdapter = adapter;
                break;
            }
            if (knownAdapter == null) {
                this.typeAdaptersByFieldName.put(field.getFieldName(), NO_ADAPTER);
            }
        }
        return knownAdapter == NO_ADAPTER ? null : knownAdapter;
    }

    private Object serialize(DataFieldToMethodMap field, Object value) {
        Object toRet = value;
        if (value instanceof Enum) {
            toRet = ((Enum)value).name();
        } else if (value instanceof Calendar) {
            toRet = ((Calendar)value).getTime();
        } else if (value instanceof Character) {
            toRet = ((Character)value).toString();
        }
        TypeAdapter<Object, Object> adapter = this.getTypeAdapter(field, true);
        if (adapter != null) {
            toRet = adapter.write(value);
        }
        return toRet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserialize(DataFieldToMethodMap field, ResultSet resultSet) throws SQLException {
        Object value = null;
        DataFieldToMethodMap.Type fieldType = field.getType();
        if (field.isPrimitive()) {
            if (fieldType == DataFieldToMethodMap.Type.IntPrimitive) {
                value = resultSet.getInt(field.getFieldName());
            } else if (fieldType == DataFieldToMethodMap.Type.LongPrimitive) {
                value = resultSet.getLong(field.getFieldName());
            } else if (fieldType == DataFieldToMethodMap.Type.BooleanPrimitive) {
                value = resultSet.getBoolean(field.getFieldName());
            } else if (fieldType == DataFieldToMethodMap.Type.DoublePrimitive) {
                value = resultSet.getDouble(field.getFieldName());
            } else if (fieldType == DataFieldToMethodMap.Type.FloatPrimitive) {
                value = Float.valueOf(resultSet.getFloat(field.getFieldName()));
            } else if (fieldType == DataFieldToMethodMap.Type.BytePrimitive) {
                value = resultSet.getByte(field.getFieldName());
            } else if (fieldType == DataFieldToMethodMap.Type.CharPrimitive) {
                value = Character.valueOf(StringHelper.emptyDefault(resultSet.getString(field.getFieldName()), "\u0000").charAt(0));
            } else {
                if (fieldType != DataFieldToMethodMap.Type.ShortPrimitive) throw new AssertionError((Object)"Unknown primitive type.");
                value = resultSet.getShort(field.getFieldName());
            }
        } else if (fieldType == DataFieldToMethodMap.Type.String) {
            value = resultSet.getString(field.getFieldName());
        } else {
            value = resultSet.getObject(field.getFieldName());
            if (value != null) {
                if (fieldType == DataFieldToMethodMap.Type.IntegerObject) {
                    value = resultSet.getInt(field.getFieldName());
                } else if (fieldType == DataFieldToMethodMap.Type.LongObject) {
                    value = resultSet.getLong(field.getFieldName());
                } else if (fieldType == DataFieldToMethodMap.Type.Date) {
                    java.util.Date temporary = new java.util.Date();
                    temporary.setTime(((java.util.Date)value).getTime());
                    value = temporary;
                } else if (fieldType == DataFieldToMethodMap.Type.Calendar) {
                    value = DateHelper.getCalendarInstance(((java.util.Date)value).getTime());
                } else if (fieldType == DataFieldToMethodMap.Type.BooleanObject) {
                    value = resultSet.getBoolean(field.getFieldName());
                } else if (fieldType == DataFieldToMethodMap.Type.DoubleObject) {
                    value = resultSet.getDouble(field.getFieldName());
                } else if (fieldType == DataFieldToMethodMap.Type.FloatObject) {
                    value = Float.valueOf(resultSet.getFloat(field.getFieldName()));
                } else if (fieldType == DataFieldToMethodMap.Type.ShortObject) {
                    value = resultSet.getShort(field.getFieldName());
                } else if (fieldType == DataFieldToMethodMap.Type.ByteObject) {
                    value = resultSet.getByte(field.getFieldName());
                } else if (fieldType == DataFieldToMethodMap.Type.CharacterObject) {
                    value = Character.valueOf(StringHelper.emptyDefault(resultSet.getString(field.getFieldName()), "\u0000").charAt(0));
                } else if (fieldType == DataFieldToMethodMap.Type.Enum) {
                    value = !StringHelper.isEmpty(String.valueOf(value)) ? Enum.valueOf(field.getJavaFieldType(), String.valueOf(value)) : null;
                }
            }
        }
        TypeAdapter<Object, Object> adapter = this.getTypeAdapter(field, false);
        if (adapter == null) return value;
        return adapter.read(value);
    }

    private void applyValueToStatement(DataFieldToObjectEntityMap field, Object value, PreparedStatement statement, int index) throws SQLException {
        if (field.getFieldType() == 93) {
            java.util.Date dateValue = (java.util.Date)value;
            statement.setTimestamp(index, dateValue == null ? null : new Timestamp(dateValue.getTime()));
        } else {
            statement.setObject(index, value, field.getFieldType());
        }
    }

    private DataFieldToMethodMap[] getGetMethodMappingCache() {
        if (this.getMethods == null) {
            this.bindToDatabase(null);
        }
        return this.getMethods;
    }

    private DataFieldToMethodMap[] getGetMethodMappingCacheWithoutId() {
        if (this.getMethodsWithoutId == null) {
            DataFieldToMethodMap[] cache = this.getGetMethodMappingCache();
            ArrayList<DataFieldToMethodMap> fields = new ArrayList<DataFieldToMethodMap>(cache.length - 1);
            DataFieldToMethodMap[] dataFieldToMethodMapArray = cache;
            int n = cache.length;
            int n2 = 0;
            while (n2 < n) {
                DataFieldToMethodMap field = dataFieldToMethodMapArray[n2];
                if (!field.getFieldName().equalsIgnoreCase(this.id)) {
                    fields.add(field);
                }
                ++n2;
            }
            DataFieldToMethodMap[] result = new DataFieldToMethodMap[fields.size()];
            this.getMethodsWithoutId = fields.toArray(result);
        }
        return this.getMethodsWithoutId;
    }

    private String getFieldPartsForUpdate() {
        if (this.fieldPartsForUpdate == null) {
            DataFieldToMethodMap[] fields;
            StringList fieldParts = new StringList(", ");
            DataFieldToMethodMap[] dataFieldToMethodMapArray = fields = this.getGetMethodMappingCacheWithoutId();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                DataFieldToMethodMap field = dataFieldToMethodMapArray[n2];
                fieldParts.add(String.valueOf(this.enquote(field.getFieldName())) + " = ?");
                ++n2;
            }
            this.fieldPartsForUpdate = fieldParts.toString();
        }
        return this.fieldPartsForUpdate;
    }

    private DataFieldToMethodMap[] getSetMethodMappingCache(ResultSet resultSet) {
        if (this.setMethods == null) {
            this.bindToDatabase(resultSet);
        }
        return this.setMethods;
    }

    private void bindToDatabase(ResultSet resultSet) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DatabaseConnector connector = this.cf.getConnector();){
            Collection<DatabaseColumnMetaData> metaData = connector.getColumnMetaDataForTable(this.table);
            if (CollectionHelper.isEmpty(metaData)) {
                if (resultSet != null) {
                    try {
                        ResultSetMetaData rsmd = resultSet.getMetaData();
                        metaData = new ArrayList<DatabaseColumnMetaData>();
                        int i = 1;
                        while (i <= rsmd.getColumnCount()) {
                            DatabaseColumnMetaData dcmd = new DatabaseColumnMetaData(rsmd.getColumnName(i), rsmd.getColumnType(i));
                            metaData.add(dcmd);
                            ++i;
                        }
                    }
                    catch (SQLException rsmd) {
                        // empty catch block
                    }
                }
                if (CollectionHelper.isEmpty(metaData)) {
                    throw new EntityException("Could not read meta data for table \"" + this.table + "\".");
                }
            }
            Method[] methods = this.type.getMethods();
            ArrayList<DataFieldToMethodMap> setMethodList = new ArrayList<DataFieldToMethodMap>(metaData.size());
            ArrayList<DataFieldToMethodMap> getMethodList = new ArrayList<DataFieldToMethodMap>(metaData.size());
            for (DatabaseColumnMetaData columnInfo : metaData) {
                String columnName = columnInfo.getColumnName();
                int columnIndex = columnInfo.getOrdinalPosition();
                int dataType = columnInfo.getDataType();
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    int index;
                    Method method = methodArray[n2];
                    if (method.getParameterTypes().length == 1) {
                        if (method.getName().equalsIgnoreCase("set" + columnName)) {
                            index = this.access.getIndex(method.getName(), new Class[]{method.getParameterTypes()[0]});
                            setMethodList.add(new DataFieldToMethodMap(method, columnName, columnIndex, dataType, index));
                        }
                    } else if (method.getParameterTypes().length == 0 && (method.getName().equalsIgnoreCase("get" + columnName) || method.getName().equalsIgnoreCase("is" + columnName) || method.getName().equalsIgnoreCase("has" + columnName))) {
                        index = this.access.getIndex(method.getName(), (Class[])EntityStore.NO_PARAMETERS);
                        getMethodList.add(new DataFieldToMethodMap(method, columnName, columnIndex, dataType, index));
                    }
                    ++n2;
                }
            }
            DataFieldToMethodMap[] sets = new DataFieldToMethodMap[setMethodList.size()];
            setMethodList.toArray(sets);
            this.setMethods = sets;
            DataFieldToMethodMap[] gets = new DataFieldToMethodMap[getMethodList.size()];
            getMethodList.toArray(gets);
            this.getMethods = gets;
            DataMappingCache.putGetMethodMappings(this.type, getMethodList);
            DataMappingCache.putSetMethodMappings(this.type, setMethodList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public T make(ResultSet resultSet) {
        T object = this.maker.make();
        try {
            int idValue = resultSet.getInt(this.id);
            object.setId(idValue);
        }
        catch (SQLException e) {
            throw new EntityException("Exception while fetching identity during object initialization.", e);
        }
        DataFieldToMethodMap[] mappings = this.getSetMethodMappingCache(resultSet);
        if (mappings == null) {
            throw new IllegalStateException("No set method mappings available for " + this.type.getSimpleName());
        }
        DataFieldToMethodMap[] dataFieldToMethodMapArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldToMethodMap map = dataFieldToMethodMapArray[n2];
            try {
                Object value = this.deserialize(map, resultSet);
                this.access.invoke(object, map.getMethodIndex(), new Object[]{value});
            }
            catch (Exception e) {
                throw new EntityException("Exception during object initialization (" + map.getMethod().getName() + ").", e);
            }
            ++n2;
        }
        if (object instanceof PersistenceAware) {
            ((PersistenceAware)object).setPersisted(true);
        }
        if (object instanceof CacheAware) {
            ((CacheAware)object).setCacheController(this.controller);
        }
        if (object instanceof Initializable) {
            ((Initializable)object).initialize();
        }
        return object;
    }

    private String enquote(String tableOrColumn) {
        String quote = this.cf.getIdentifierQuoteString();
        return new StringBuilder(tableOrColumn.length() + 2).append(quote).append(tableOrColumn).append(quote).toString();
    }

    protected boolean isPersisted(Identifiable entity) {
        if (entity instanceof PersistenceAware) {
            return ((PersistenceAware)((Object)entity)).isPersisted();
        }
        return entity.getId() != 0;
    }

    public String toString() {
        return "EntityGroup [" + this.type.getSimpleName() + "]";
    }

    public static <T extends Identifiable> Builder<T> of(Class<T> type) {
        return new Builder<T>(type);
    }

    public static class Builder<T extends Identifiable> {
        protected final Class<T> type;
        protected String table;
        protected String id;
        protected EntityMaker<T> maker;
        protected Comparator<? super T> comparator;
        protected String where;
        protected String[] whereArguments;

        protected Builder(Class<T> type) {
            if (type == null) {
                throw new NullPointerException();
            }
            this.type = type;
        }

        public EntityGroup<T> build(EntityStore controller) {
            if (controller == null) {
                throw new EntityException("Builder.build: Controller argument is null.");
            }
            return new EntityGroup<T>(controller, this.type, this.table, this.id, this.maker, this.comparator, this.where, this.whereArguments);
        }

        public Builder<T> table(String tableName) {
            this.table = tableName;
            return this;
        }

        public Builder<T> id(String idField) {
            this.id = idField;
            return this;
        }

        public Builder<T> maker(EntityMaker<T> entityMaker) {
            this.maker = entityMaker;
            return this;
        }

        public Builder<T> comparator(Comparator<? super T> entityComparator) {
            this.comparator = entityComparator;
            return this;
        }

        public Builder<T> comparator(String methodName) {
            this.comparator = new ReflectiveComparator<T>(methodName, 2);
            return this;
        }

        public Builder<T> where(String whereClause, String ... arguments) {
            this.where = whereClause;
            this.whereArguments = arguments;
            return this;
        }

        public <O> Builder<T> constructorArgs(final O ... arguments) {
            Constructor<T> constructor;
            Class[] classes = new Class[arguments.length];
            int index = 0;
            O[] OArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                O arg = OArray[n2];
                classes[index++] = arg.getClass();
                ++n2;
            }
            try {
                constructor = this.type.getConstructor(classes);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("Cannot find specified constructor.", nsme);
            }
            this.maker = new EntityMaker<T>(){

                @Override
                public T make() {
                    try {
                        return (Identifiable)constructor.newInstance(arguments);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                        return null;
                    }
                }
            };
            return this;
        }
    }

    static enum NaturalOrderComparator implements Comparator<Comparable<Object>>
    {
        INSTANCE;


        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }
    }
}

