/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.jdbc;

import com.techempower.TechEmpowerApplication;
import com.techempower.asynchronous.Asynchronous;
import com.techempower.data.ConnectionMonitor;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseAffinity;
import com.techempower.data.DatabaseConnectionListener;
import com.techempower.data.DatabaseConnector;
import com.techempower.data.jdbc.JdbcConnectionAttributes;
import com.techempower.data.jdbc.JdbcConnectionManager;
import com.techempower.data.jdbc.JdbcConnector;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class BasicConnectorFactory
implements ConnectorFactory,
Configurable,
DatabaseConnectionListener,
Asynchronous {
    public static final String COMPONENT_CODE = "cnfc";
    public static final String DEFAULT_PROPERY_PREFIX = "db.";
    public static final long DEFAULT_QUERY_COUNT_FREQUENCY = 1000L;
    public static final int DEFAULT_MAX_RETRIES = 0;
    public static final long DEFAULT_RETRY_SLEEP = 0L;
    private final String propertyPrefix;
    private volatile JdbcConnectionAttributes attributes = null;
    private volatile JdbcConnectionManager connectionManager = null;
    private final TechEmpowerApplication app;
    private final ComponentLog log;
    private final AtomicLong queryCount = new AtomicLong(0L);
    private boolean enabled = true;
    private boolean safeMode = false;
    private boolean queryCounting = false;
    private long queryCountFrequency = 1000L;
    private int maxRetries = 0;
    private long retrySleep = 0L;
    private String identifierQuoteString = " ";
    private DatabaseConnectionListener dbListener = null;

    public BasicConnectorFactory(TechEmpowerApplication application, String propertyPrefix) {
        this.propertyPrefix = StringHelper.isNonEmpty(propertyPrefix) ? propertyPrefix : DEFAULT_PROPERY_PREFIX;
        this.app = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.dbListener = this;
    }

    @Override
    public void configure(EnhancedProperties rawProps) {
        EnhancedProperties.Focus props = rawProps.focus(this.propertyPrefix);
        this.enabled = props.getYesNoProperty("Enabled", true);
        this.safeMode = props.getYesNoProperty("SafeMode", false);
        this.queryCounting = props.getYesNoProperty("QueryCounting", false);
        this.queryCountFrequency = props.getLongProperty("QueryCountFrequency", 1000L);
        this.maxRetries = props.getIntegerProperty("MaxRetries", 0);
        this.retrySleep = props.getLongProperty("RetrySleep", 0L);
        if (this.enabled) {
            JdbcConnectionManager oldManager = this.connectionManager;
            this.attributes = new JdbcConnectionAttributes(rawProps, this.dbListener, this.app, this.propertyPrefix);
            this.connectionManager = new JdbcConnectionManager(this.attributes);
            this.connectionManager.begin();
            if (oldManager != null) {
                oldManager.end();
            }
            this.debug("Configured using \"" + this.propertyPrefix + "\" prefix.");
            if (StringHelper.isNonEmpty(this.attributes.getConnectString())) {
                this.debug("Database connect string: " + this.attributes.getConnectString());
                this.debug("Database connection pool size: " + this.attributes.getMinimumPoolSize() + " to " + this.attributes.getMaximumPoolSize() + ".");
                this.debug("Database timers: " + this.attributes.getStaleTimeout() + "ms until stale; " + this.attributes.getAbortTimeout() + "ms until abort.");
                this.checkForCommonConfigurationMistakes(this.attributes);
            } else {
                this.debug("No connect string specified with \"" + this.propertyPrefix + "\" prefix.");
            }
            if (this.dbListener != null && this.dbListener != this) {
                this.dbListener.configure(rawProps);
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (DatabaseConnector connector = this.getConnector();){
                    this.identifierQuoteString = connector.getConnection().getMetaData().getIdentifierQuoteString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.debug("Exception while reading identifier quote string.", e);
            }
        } else {
            this.log.log("Database connector factory disabled.");
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
        if (this.connectionManager != null) {
            this.connectionManager.end();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void debug(String logString) {
        this.debug(logString, null);
    }

    protected void debug(String logString, Throwable e) {
        if (this.log != null) {
            this.log.log(logString, e);
        }
    }

    protected void checkForCommonConfigurationMistakes(JdbcConnectionAttributes jca) {
        String conn = jca.getConnectString();
        String un = jca.getUsername();
        String pw = jca.getPassword();
        if (jca.getMinimumPoolSize() == 1) {
            this.debug("ONLY 1 database connection is specified by " + this.propertyPrefix + "Driver.Pooling!");
        }
        if (StringHelper.isEmpty(jca.getJdbcURLPrefix())) {
            this.debug("WARNING: " + this.propertyPrefix + "Driver.UrlPrefix not specified.");
        }
        if (!conn.equals(conn.trim())) {
            this.debug("WARNING: " + this.propertyPrefix + "ConnectString contains extraneous white space.");
        }
        if (!un.equals(un.trim())) {
            this.debug("WARNING: " + this.propertyPrefix + "LoginName contains extraneous white space.");
        }
        if (!pw.equals(pw.trim())) {
            this.debug("WARNING: " + this.propertyPrefix + "LoginPass contains extraneous white space.");
        }
    }

    public JdbcConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionMonitor getConnectionMonitor() {
        return this.getConnectionManager().getConnectionMonitor();
    }

    @Override
    public DatabaseConnector getConnector(String query) {
        JdbcConnector connector = new JdbcConnector(this.getConnectionManager(), query);
        connector.setSafeMode(this.safeMode);
        this.count();
        return connector;
    }

    @Override
    public DatabaseConnector getConnector() {
        JdbcConnector connector = new JdbcConnector(this.getConnectionManager(), "");
        connector.setSafeMode(this.safeMode);
        this.count();
        return connector;
    }

    public JdbcConnector getUniqueConnector(String query) {
        JdbcConnector connector = new JdbcConnector(this.getConnectionManager(), query);
        connector.setForceNewConnection(true);
        connector.setForwardOnly(false);
        connector.setSafeMode(this.safeMode);
        return connector;
    }

    @Override
    public DatabaseConnector getScrollingConnector(String query) {
        JdbcConnector connector = new JdbcConnector(this.getConnectionManager(), query);
        connector.setForwardOnly(false);
        connector.setSafeMode(this.safeMode);
        this.count();
        return connector;
    }

    @Override
    public DatabaseConnector getScrollingConnector() {
        JdbcConnector connector = new JdbcConnector(this.getConnectionManager(), "");
        connector.setForwardOnly(false);
        connector.setSafeMode(this.safeMode);
        this.count();
        return connector;
    }

    @Override
    public void setDatabaseConnectionListener(DatabaseConnectionListener dbConnListener) {
        this.dbListener = dbConnListener;
    }

    protected void count() {
        long count;
        if (this.queryCounting && (count = this.queryCount.incrementAndGet()) % this.queryCountFrequency == 0L) {
            this.log.log(String.valueOf(count) + " queries executed.");
        }
    }

    @Override
    public int exceptionInRunQuery(SQLException exc, JdbcConnector conn) {
        if (this.checkRetry(exc, conn)) {
            return this.delayedRetry();
        }
        return 0;
    }

    @Override
    public int exceptionInRunUpdateQuery(SQLException exc, JdbcConnector conn) {
        if (this.checkRetry(exc, conn)) {
            return this.delayedRetry();
        }
        return 0;
    }

    @Override
    public int exceptionInExecuteBatch(SQLException exc, JdbcConnector conn) {
        if (this.checkRetry(exc, conn)) {
            return this.delayedRetry();
        }
        return 0;
    }

    @Override
    public void queryStarting() {
    }

    @Override
    public void queryCompleting() {
    }

    protected boolean checkRetry(SQLException exc, JdbcConnector conn) {
        int tryCount = conn.getTryCount();
        return tryCount <= this.maxRetries;
    }

    protected int delayedRetry() {
        if (this.retrySleep > 0L) {
            this.log.log("Retrying query in " + this.retrySleep + "ms.", 70);
            try {
                Thread.sleep(this.retrySleep);
            }
            catch (InterruptedException e) {
                return 0;
            }
        }
        this.log.log("Retrying query.", 70);
        return 5000;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public DatabaseAffinity getDatabaseAffinity() {
        return this.attributes.getDatabaseAffinity();
    }
}

