/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.jdbc;

import com.techempower.TechEmpowerApplication;
import com.techempower.data.DatabaseAffinity;
import com.techempower.data.DatabaseConnectionListener;
import com.techempower.data.jdbc.JdbcHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;

class JdbcConnectionAttributes {
    public static final String COMPONENT_CODE = "jdCA";
    public static final int DEFAULT_MINIMUM_POOL_SIZE = 3;
    public static final int DEFAULT_MAXIMUM_POOL_MULTIPLIER = 5;
    public static final int DEFAULT_WARNING_LEVEL = 70;
    public static final DatabaseAffinity DEFAULT_DATABASE_AFFINITY = DatabaseAffinity.MYSQL;
    public static final String DEFAULT_TEST_QUERY = "SELECT 1 AS Result";
    public static final String DEFAULT_TEST_VALUE = "1";
    public static final long DEFAULT_TEST_INTERVAL = 60000L;
    public static final long MAXIMUM_TEST_INTERVAL = 86400000L;
    public static final long MINIMUM_TEST_INTERVAL = 60000L;
    public static final long DEFAULT_STALE_TIMEOUT = 600000L;
    public static final long DEFAULT_ABORT_TIMEOUT = 3600000L;
    private final String jdbcURLPrefix;
    private final String connectString;
    private final String displayName;
    private final String username;
    private final String password;
    private final String driverClassName;
    private final ComponentLog log;
    private final TechEmpowerApplication application;
    private final int minimumPoolSize;
    private final int maximumPoolSize;
    private final boolean logWarnings;
    private final int warningLogLevel;
    private final DatabaseAffinity databaseAffinity;
    private final boolean testEnabled;
    private final String testQuery;
    private final String testValue;
    private final long testInterval;
    private final long staleTimeout;
    private final long abortTimeout;
    private final DatabaseConnectionListener listener;

    public JdbcConnectionAttributes(EnhancedProperties props, DatabaseConnectionListener listener, TechEmpowerApplication application, String prefix) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        EnhancedProperties.Focus focus = props.focus(prefix);
        this.connectString = focus.getProperty("ConnectString");
        this.displayName = focus.getProperty("DisplayName", StringHelper.truncateEllipsis(this.connectString, 25));
        this.username = focus.getProperty("LoginName");
        this.password = focus.getProperty("LoginPass");
        this.jdbcURLPrefix = focus.getProperty("Driver.UrlPrefix");
        this.minimumPoolSize = focus.getIntegerProperty("Driver.Pooling", 3);
        this.maximumPoolSize = focus.getIntegerProperty("Driver.MaxPooling", 5 * this.minimumPoolSize);
        this.driverClassName = focus.getProperty("Driver.Class");
        this.logWarnings = focus.getYesNoProperty("LogWarnings", true);
        this.warningLogLevel = focus.getIntegerProperty("WarningLogLevel", 70);
        this.databaseAffinity = focus.getEnumProperty("DatabaseAffinity", DatabaseAffinity.class, DatabaseAffinity.MYSQL);
        this.testEnabled = focus.getYesNoProperty("TestEnabled", true);
        this.testQuery = focus.getProperty("TestQuery", DEFAULT_TEST_QUERY);
        this.testValue = focus.getProperty("TestValue", DEFAULT_TEST_VALUE);
        this.testInterval = focus.getLongProperty("TestInterval", 60000L, 60000L, 86400000L);
        this.staleTimeout = focus.getLongProperty("Driver.StaleTimeout", 600000L);
        this.abortTimeout = focus.getLongProperty("Driver.AbortTimeout", 3600000L);
        this.listener = listener;
        JdbcHelper.loadDriver(this.driverClassName, this.log);
    }

    protected String getConnectString() {
        return this.connectString;
    }

    protected String getJdbcURLPrefix() {
        return this.jdbcURLPrefix;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getUsername() {
        return this.username;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected DatabaseConnectionListener getListener() {
        return this.listener;
    }

    protected TechEmpowerApplication getApplication() {
        return this.application;
    }

    public boolean getLogWarnings() {
        return this.logWarnings;
    }

    public int getWarningLogLevel() {
        return this.warningLogLevel;
    }

    public DatabaseAffinity getDatabaseAffinity() {
        return this.databaseAffinity;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public boolean isTestEnabled() {
        return this.testEnabled;
    }

    public String getTestValue() {
        return this.testValue;
    }

    public long getTestInterval() {
        return this.testInterval;
    }

    public long getStaleTimeout() {
        return this.staleTimeout;
    }

    public long getAbortTimeout() {
        return this.abortTimeout;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "JdbcConnectionAttributes [" + this.getConnectString() + "; " + this.driverClassName + "; " + this.getMinimumPoolSize() + "; " + this.getMaximumPoolSize() + "]";
    }
}

