/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.jdbc;

import com.techempower.data.DatabaseConnector;
import com.techempower.data.jdbc.JdbcConnectionManager;
import com.techempower.data.jdbc.JdbcConnectionProfile;
import com.techempower.data.jdbc.JdbcConnectorError;
import com.techempower.data.mapping.DatabaseColumnMetaData;
import com.techempower.data.mapping.DatabaseTableMetaData;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class JdbcConnector
implements DatabaseConnector {
    public static final String COMPONENT_CODE = "jdbc";
    public static final String NULL_VALUE_REPLACE = "[none]";
    private final JdbcConnectionManager manager;
    private final ComponentLog componentLog;
    private int tryCount = 0;
    private Statement statement = null;
    private ResultSet resultSet = null;
    private boolean nextThrewException = true;
    private boolean readOnly = true;
    private boolean forwardOnly = false;
    private boolean safeMode = false;
    private String query = null;
    private int rowCount = -1;
    private JdbcConnectionProfile connectionProfile = null;
    private JdbcConnectionProfile forcedConnectionProfile = null;
    private boolean forceNewConnection = false;
    private Connection forcedConnection = null;

    protected JdbcConnector(JdbcConnectionManager manager, String query, boolean readOnly, boolean forwardOnly) {
        this.manager = manager;
        this.componentLog = manager.getLog();
        this.setReadOnly(readOnly);
        this.setForwardOnly(forwardOnly);
        this.query = query;
    }

    protected JdbcConnector(JdbcConnectionManager manager, String query) {
        this(manager, query, true, true);
    }

    @Override
    public void setQuery(String query) {
        this.log("setQuery: " + query, 10);
        this.close(false);
        this.query = query;
        this.nextThrewException = true;
        this.tryCount = 0;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    protected void log(String toLog, int logLevel) {
        this.componentLog.log(toLog, logLevel);
    }

    protected void log(String toLog, int logLevel, Throwable t) {
        this.componentLog.log(toLog, logLevel, t);
    }

    public int getTryCount() {
        return this.tryCount;
    }

    @Override
    public void setForceNewConnection(boolean forceNewConnection) {
        this.forceNewConnection = forceNewConnection;
    }

    public boolean getForceNewConnection() {
        return this.forceNewConnection;
    }

    @Override
    public void setForwardOnly(boolean forwardOnly) {
        this.forwardOnly = forwardOnly;
    }

    @Override
    public boolean getForwardOnly() {
        return this.forwardOnly;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public boolean getSafeMode() {
        return this.safeMode;
    }

    @Override
    public void first() {
        if (this.forwardOnly) {
            this.log("Call to first on a forward-only query.", 50);
            return;
        }
        try {
            this.nextThrewException = !this.resultSet.first();
        }
        catch (SQLException exc) {
            this.log("Exception on first(): " + exc, 50);
            this.nextThrewException = true;
        }
    }

    @Override
    public void last() {
        if (this.forwardOnly) {
            this.log("Call to last on a forward-only query.", 50);
            return;
        }
        try {
            this.nextThrewException = !this.resultSet.last();
        }
        catch (Exception exc) {
            this.log("Exception on last(): " + exc, 50);
            this.nextThrewException = true;
        }
    }

    @Override
    public void next() {
        try {
            if (this.resultSet == null) {
                this.nextThrewException = true;
                return;
            }
            this.nextThrewException = !this.resultSet.next();
        }
        catch (SQLException exc) {
            this.nextThrewException = true;
        }
    }

    @Override
    public boolean more() {
        return this.resultSet != null && !this.nextThrewException;
    }

    @Override
    public void moveAbsolute(int position) {
        if (this.forwardOnly) {
            this.log("Call to moveAbsolute on a forward-only query.", 50);
            return;
        }
        try {
            this.resultSet.absolute(position + 1);
        }
        catch (SQLException exc) {
            this.log("Exception while moving to absolute position " + position + ": " + exc, 50);
        }
    }

    @Override
    public int getRowNumber() {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException exc) {
            this.log("Exception while getting row number: " + exc, 50);
            return 0;
        }
    }

    @Override
    public String[] getFieldNames() {
        try {
            ResultSetMetaData metadata = this.resultSet.getMetaData();
            int fieldCount = metadata.getColumnCount();
            String[] toReturn = new String[fieldCount];
            int i = 1;
            while (i < fieldCount + 1) {
                toReturn[i - 1] = metadata.getColumnName(i);
                ++i;
            }
            return toReturn;
        }
        catch (SQLException exc) {
            this.log("Exception while gathering field names: " + exc, 50);
            return new String[0];
        }
    }

    @Override
    public int[] getFieldTypes() {
        try {
            ResultSetMetaData metadata = this.resultSet.getMetaData();
            int fieldCount = metadata.getColumnCount();
            int[] toReturn = new int[fieldCount];
            int i = 1;
            while (i < fieldCount + 1) {
                toReturn[i - 1] = metadata.getColumnType(i);
                ++i;
            }
            return toReturn;
        }
        catch (SQLException exc) {
            this.log("Exception while gathering field names: " + exc, 50);
            return new int[0];
        }
    }

    @Override
    public String getFieldByName(String fieldName) {
        try {
            return this.resultSet.getString(fieldName);
        }
        catch (SQLException exc) {
            this.log("Exception while retrieving field " + fieldName + ": " + exc, 50);
            return null;
        }
    }

    @Override
    public String getField(String fieldName, String defaultValue) {
        String result = this.getFieldByName(fieldName);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    @Override
    public int getIntegerFieldByName(String fieldName) {
        try {
            return this.resultSet.getInt(fieldName);
        }
        catch (SQLException exc) {
            return 0;
        }
    }

    @Override
    public int getIntegerField(String fieldName) {
        return this.getIntegerFieldByName(fieldName);
    }

    @Override
    public int getInt(String fieldName) {
        return this.getIntegerFieldByName(fieldName);
    }

    @Override
    public int getInt(String fieldName, int defaultValue) {
        try {
            return this.resultSet.getInt(fieldName);
        }
        catch (SQLException exc) {
            return defaultValue;
        }
    }

    @Override
    public String getClob(String fieldName) {
        try {
            int length = Long.valueOf(this.resultSet.getClob(fieldName).length()).intValue();
            return this.resultSet.getClob(fieldName).getSubString(1L, length);
        }
        catch (SQLException exc) {
            return null;
        }
    }

    public byte[] getBlob(String fieldName) {
        try {
            return this.resultSet.getBlob(fieldName).getBytes(0L, (int)this.resultSet.getBlob(fieldName).length());
        }
        catch (SQLException exc) {
            return null;
        }
    }

    @Override
    public Date getDate(String fieldName) {
        try {
            return this.resultSet.getDate(fieldName);
        }
        catch (SQLException exc) {
            return null;
        }
    }

    @Override
    public Calendar getDateAsCalendar(String fieldName) {
        Timestamp date = this.getTimestamp(fieldName);
        if (date != null) {
            Calendar cal = DateHelper.getCalendarInstance();
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    @Override
    public Time getTime(String fieldName) {
        try {
            return this.resultSet.getTime(fieldName);
        }
        catch (SQLException exc) {
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(String fieldName) {
        try {
            return this.resultSet.getTimestamp(fieldName);
        }
        catch (SQLException exc) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(String fieldName) {
        try {
            return this.resultSet.getBoolean(fieldName);
        }
        catch (SQLException exc) {
            return false;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String fieldName) {
        try {
            return this.resultSet.getBigDecimal(fieldName);
        }
        catch (SQLException exc) {
            return null;
        }
    }

    @Override
    public float getFloat(String fieldName) {
        try {
            return this.resultSet.getFloat(fieldName);
        }
        catch (SQLException exc) {
            return 0.0f;
        }
    }

    @Override
    public double getDouble(String fieldName) {
        try {
            return this.resultSet.getDouble(fieldName);
        }
        catch (SQLException exc) {
            return 0.0;
        }
    }

    @Override
    public byte getByte(String fieldName) {
        try {
            return this.resultSet.getByte(fieldName);
        }
        catch (SQLException exc) {
            return 0;
        }
    }

    @Override
    public short getShort(String fieldName) {
        try {
            return this.resultSet.getShort(fieldName);
        }
        catch (SQLException exc) {
            return 0;
        }
    }

    @Override
    public long getLong(String fieldName) {
        try {
            return this.resultSet.getLong(fieldName);
        }
        catch (SQLException exc) {
            return 0L;
        }
    }

    @Override
    public int getRowCount() {
        if (this.resultSet != null) {
            if (this.rowCount > -1) {
                return this.rowCount;
            }
            this.rowCount = 0;
            this.first();
            while (this.more()) {
                ++this.rowCount;
                this.next();
            }
            this.first();
            return this.rowCount;
        }
        return 0;
    }

    @Override
    public void close() {
        this.close(true);
    }

    public void close(boolean closeConnection) {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sqlexc) {
                this.log("Exception while closing result set: " + sqlexc, 70);
            }
            this.resultSet = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sqlexc) {
                this.log("Exception while closing statement: " + sqlexc, 70);
            }
            this.statement = null;
        }
        if (this.connectionProfile != null) {
            this.connectionProfile.release();
            this.connectionProfile = null;
        }
        if (closeConnection && this.forcedConnection != null) {
            try {
                this.forcedConnection.close();
            }
            catch (SQLException sqlexc) {
                this.log("Exception while closing forced connection: " + sqlexc, 70);
            }
            this.forcedConnection = null;
        }
    }

    @Override
    public int runUpdateQuery() {
        return this.runUpdateQuery(this.safeMode);
    }

    public int runUpdateQuerySafe() {
        return this.runUpdateQuery(true);
    }

    public int runUpdateQueryUnsafe() {
        return this.runUpdateQuery(false);
    }

    /*
     * Loose catch block
     */
    @Override
    public int runUpdateQuery(boolean safe) {
        this.close(false);
        int updateRowCount = -1;
        this.connectionProfile = this.getDbConnection();
        if (this.connectionProfile != null) {
            try {
                int instruction = 5000;
                while (instruction == 5000) {
                    block18: {
                        instruction = 0;
                        ++this.tryCount;
                        try {
                            Connection connection = this.connectionProfile.getConnection();
                            if (connection != null) {
                                this.statement = connection.createStatement();
                                this.logWarnings(this.statement);
                                break block18;
                            }
                            this.log("runUpdateQuery: ConnectionProfile's Connection is null!", 90);
                            return -1;
                        }
                        catch (SQLException sqlexc) {
                            if (safe) {
                                throw new JdbcConnectorError("runUpdateQuery: Could not create statement.", sqlexc);
                            }
                            this.log("runUpdateQuery: SQL Exception while creating statement: " + sqlexc, 70);
                            this.notifyListener(2, sqlexc);
                            this.close(false);
                            return -1;
                        }
                    }
                    try {
                        this.logWarnings(this.statement);
                        this.statement.execute(this.query);
                        updateRowCount = this.statement.getUpdateCount();
                        this.logWarnings(this.statement);
                        continue;
                    }
                    catch (SQLException sqlexc) {
                        try {
                            this.statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.statement = null;
                        this.checkForDisconnectExceptions(sqlexc, this.connectionProfile);
                        if (safe) {
                            throw new JdbcConnectorError("runUpdateQuery: Could not execute the query.", sqlexc);
                        }
                        this.log("runUpdateQuery: SQL Exception executing query: " + sqlexc, 70);
                        instruction = this.notifyListener(2, sqlexc);
                        if (instruction != 0) continue;
                        this.close(false);
                        return -1;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.close(false);
            }
        }
        if (safe) {
            throw new JdbcConnectorError("runUpdateQuery: No valid connection available, aborting query.", null);
        }
        this.log("runUpdateQuery: No valid connection available, aborting query.", 90);
        return updateRowCount;
    }

    @Override
    public int runQuery() {
        return this.runQuery(this.safeMode);
    }

    public int runQuerySafe() {
        return this.runQuery(true);
    }

    public int runQueryUnsafe() {
        return this.runQuery(false);
    }

    @Override
    public int runQuery(boolean safe) {
        this.close(false);
        this.rowCount = -1;
        this.connectionProfile = this.getDbConnection();
        if (this.connectionProfile != null) {
            if (safe) {
                try {
                    this.generateStatement(this.connectionProfile);
                }
                catch (SQLException sqlexc) {
                    this.log("SQL Exception while creating statement: " + sqlexc, 70);
                    this.connectionProfile.close();
                    throw new JdbcConnectorError("Creation of statement failed.", sqlexc);
                }
                this.logWarnings(this.statement);
                try {
                    this.generateResults();
                }
                catch (SQLException sqlexc) {
                    try {
                        this.statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.statement = null;
                    this.log("SQL Exception while running query: " + sqlexc, 70);
                    this.log("Query was: " + this.getQuery(), 70);
                    throw new JdbcConnectorError("runQuery failed.", sqlexc);
                }
            }
            boolean exceptionEncountered = false;
            int instruction = 5000;
            while (instruction == 5000) {
                exceptionEncountered = false;
                instruction = 0;
                ++this.tryCount;
                try {
                    this.generateStatement(this.connectionProfile);
                }
                catch (SQLException sqlexc) {
                    try {
                        this.statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.statement = null;
                    this.log("SQL Exception while creating statement: " + sqlexc, 70);
                    this.connectionProfile.close();
                    exceptionEncountered = true;
                    instruction = this.notifyListener(1, sqlexc);
                }
                if (exceptionEncountered) continue;
                try {
                    this.generateResults();
                }
                catch (SQLException sqlexc) {
                    try {
                        this.statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.statement = null;
                    this.checkForDisconnectExceptions(sqlexc, this.connectionProfile);
                    this.log("SQL Exception while running query: " + sqlexc, 70);
                    this.log("Query was: " + this.getQuery(), 70);
                    instruction = this.notifyListener(1, sqlexc);
                }
            }
            if (exceptionEncountered) {
                return -1;
            }
        } else {
            this.log("No valid connection available, aborting query.", 90);
            return -1;
        }
        return 0;
    }

    protected void checkForDisconnectExceptions(SQLException sqlexc, JdbcConnectionProfile profile) {
        if (sqlexc.getSQLState().startsWith("08")) {
            this.log("SQL state: " + sqlexc.getSQLState() + "; closing connection.", 10);
            profile.close();
        } else {
            String sqlexcString = sqlexc.toString();
            if (sqlexcString.indexOf("onnection reset by peer") >= 0 || sqlexcString.indexOf("socket write error") >= 0) {
                this.log("Exception text suggests connection error; closing connection.", 10);
                profile.close();
            }
        }
    }

    public int[] executeBatch(Collection<String> sqlCommands, boolean safe) {
        int[] affectedRowCounts = null;
        if (sqlCommands == null || sqlCommands.isEmpty()) {
            this.log("executeBatch: No batch commands defined.", 70);
        } else {
            this.close(false);
            this.connectionProfile = this.getDbConnection();
            if (this.connectionProfile != null) {
                try {
                    int instruction = 5000;
                    while (instruction == 5000) {
                        instruction = 0;
                        ++this.tryCount;
                        if (safe) {
                            try {
                                this.generateStatement(this.connectionProfile);
                            }
                            catch (SQLException sqlexc) {
                                this.log("SQL Exception while creating statement: " + sqlexc, 70);
                                this.connectionProfile.close();
                                throw new JdbcConnectorError("Creation of statement failed.", sqlexc);
                            }
                            try {
                                Iterator<String> iterator = sqlCommands.iterator();
                                while (iterator.hasNext()) {
                                    this.statement.addBatch(iterator.next());
                                }
                                affectedRowCounts = this.statement.executeBatch();
                                this.statement.clearBatch();
                                continue;
                            }
                            catch (SQLException sqlexc) {
                                try {
                                    this.statement.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.statement = null;
                                this.log("SQL Exception while running query: " + sqlexc, 70);
                                this.log("Query was: " + this.getQuery(), 70);
                                throw new JdbcConnectorError("executeBatch failed.", sqlexc);
                            }
                        }
                        boolean exceptionEncountered = false;
                        try {
                            this.generateStatement(this.connectionProfile);
                        }
                        catch (SQLException sqlexc) {
                            this.connectionProfile.close();
                            this.log("SQL Exception while creating statement: " + sqlexc, 70);
                            instruction = this.notifyListener(3, sqlexc);
                            exceptionEncountered = true;
                        }
                        if (exceptionEncountered) continue;
                        try {
                            for (String batch : sqlCommands) {
                                this.statement.addBatch(batch);
                            }
                            affectedRowCounts = this.statement.executeBatch();
                            this.statement.clearBatch();
                        }
                        catch (SQLException sqlexc) {
                            try {
                                this.statement.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.statement = null;
                            this.log("SQL Exception while running query: " + sqlexc, 70);
                            this.log("Query was: " + this.getQuery(), 70);
                            this.checkForDisconnectExceptions(sqlexc, this.connectionProfile);
                            instruction = this.notifyListener(3, sqlexc);
                        }
                    }
                }
                finally {
                    this.close(false);
                }
            }
        }
        return affectedRowCounts;
    }

    public SQLWarning getWarnings() {
        if (this.statement != null) {
            try {
                return this.statement.getWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public SQLWarning getConnectionWarnings() {
        if (this.statement != null) {
            try {
                return this.statement.getConnection().getWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return "JdbcConn [q: " + this.query + "]";
    }

    @Override
    public int[] executeBatch(Collection<String> sqlCommands) {
        return this.executeBatch(sqlCommands, this.safeMode);
    }

    protected void generateStatement(JdbcConnectionProfile dbConnectionToUse) throws SQLException {
        try {
            this.logWarnings(dbConnectionToUse.getConnection());
            int resultSetType = 1004;
            int resultSetConcurrency = 1007;
            if (this.forwardOnly) {
                resultSetType = 1003;
            }
            if (!this.readOnly) {
                resultSetConcurrency = 1008;
            }
            this.statement = dbConnectionToUse.getConnection().createStatement(resultSetType, resultSetConcurrency);
            this.logWarnings(this.statement);
        }
        catch (SQLException sqlexc) {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
            this.log("SQLException in generateStatement: " + sqlexc, 70);
            this.nextThrewException = true;
            this.resultSet = null;
            throw sqlexc;
        }
    }

    protected void generateResults() throws SQLException {
        try {
            this.resultSet = this.statement.executeQuery(this.query);
            this.next();
            this.logWarnings(this.resultSet);
        }
        catch (SQLException sqlexc) {
            this.nextThrewException = true;
            this.resultSet = null;
            throw sqlexc;
        }
    }

    protected JdbcConnectionProfile getDbConnection() {
        JdbcConnectionProfile theConnectionProfile = null;
        if (this.forceNewConnection) {
            if (this.forcedConnectionProfile == null) {
                theConnectionProfile = this.manager.getDetachedProfile();
                if (!theConnectionProfile.isConnectionAvailable()) {
                    theConnectionProfile = null;
                } else {
                    this.forcedConnectionProfile = theConnectionProfile;
                    this.forcedConnection = theConnectionProfile.getConnection();
                }
            } else {
                theConnectionProfile = this.forcedConnectionProfile;
            }
        } else {
            theConnectionProfile = this.manager.getProfile();
        }
        return theConnectionProfile;
    }

    protected int notifyListener(int methodType, SQLException exc) {
        if (this.manager.getListener() != null) {
            if (methodType == 1) {
                return this.manager.getListener().exceptionInRunQuery(exc, this);
            }
            if (methodType == 3) {
                return this.manager.getListener().exceptionInExecuteBatch(exc, this);
            }
            if (methodType == 2) {
                return this.manager.getListener().exceptionInRunUpdateQuery(exc, this);
            }
        }
        return 0;
    }

    @Override
    public Collection<DatabaseTableMetaData> getTableMetaData() {
        return this.getTableMetaData(this.safeMode);
    }

    public Collection<DatabaseTableMetaData> getTableMetaData(boolean safe) {
        this.close(false);
        this.rowCount = -1;
        this.connectionProfile = this.getDbConnection();
        if (this.connectionProfile != null) {
            try {
                int instruction = 5000;
                while (instruction == 5000) {
                    ArrayList<DatabaseTableMetaData> tables;
                    DatabaseMetaData metaData;
                    instruction = 0;
                    if (!safe) {
                        ++this.tryCount;
                    }
                    try {
                        metaData = this.connectionProfile.getConnectionMetaData();
                        if (metaData == null) {
                            return null;
                        }
                        tables = new ArrayList<DatabaseTableMetaData>();
                    }
                    catch (SQLException e) {
                        this.log("SQL Exception while getting meta data for tables: " + e, 70);
                        this.connectionProfile.close();
                        if (safe) {
                            throw new JdbcConnectorError("Failed to get meta data for tables.", e);
                        }
                        instruction = this.notifyListener(1, e);
                        continue;
                    }
                    this.resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE"});
                    this.next();
                    while (this.more()) {
                        DatabaseTableMetaData tableInfo = new DatabaseTableMetaData(this.getField("TABLE_NAME", ""));
                        tableInfo.setCatalogName(this.getField("TABLE_CAT", ""));
                        tableInfo.setSchemaName(this.getField("TABLE_SCHEM", ""));
                        tableInfo.setTableType(this.getField("TABLE_TYPE", "TABLE"));
                        tables.add(tableInfo);
                        this.next();
                    }
                    ArrayList<DatabaseTableMetaData> arrayList = tables;
                    return arrayList;
                }
            }
            finally {
                this.close(false);
            }
        } else {
            this.log("No valid connection available, aborting query.", 90);
        }
        this.log("Returning from getTableMetaData.", 0);
        return null;
    }

    @Override
    public DatabaseTableMetaData getTableMetaData(String tableName) {
        return this.getTableMetaData(tableName, this.safeMode);
    }

    public DatabaseTableMetaData getTableMetaData(String tableName, boolean safe) {
        this.close(false);
        this.rowCount = -1;
        this.connectionProfile = this.getDbConnection();
        if (this.connectionProfile != null) {
            try {
                int instruction = 5000;
                while (instruction == 5000) {
                    DatabaseMetaData metaData;
                    block11: {
                        instruction = 0;
                        if (!safe) {
                            ++this.tryCount;
                        }
                        try {
                            metaData = this.connectionProfile.getConnectionMetaData();
                            if (metaData != null) break block11;
                            return null;
                        }
                        catch (SQLException e) {
                            this.log("SQL Exception while getting meta data for tables: " + e, 70);
                            this.connectionProfile.close();
                            if (safe) {
                                throw new JdbcConnectorError("Failed to get meta data for tables.", e);
                            }
                            instruction = this.notifyListener(1, e);
                            continue;
                        }
                    }
                    this.resultSet = metaData.getTables(null, null, tableName, new String[]{"TABLE"});
                    if (!this.more()) continue;
                    DatabaseTableMetaData tableInfo = new DatabaseTableMetaData(this.getField("TABLE_NAME", ""));
                    tableInfo.setCatalogName(this.getField("TABLE_CAT", ""));
                    tableInfo.setSchemaName(this.getField("TABLE_SCHEM", ""));
                    tableInfo.setTableType(this.getField("TABLE_TYPE", "TABLE"));
                    DatabaseTableMetaData databaseTableMetaData = tableInfo;
                    return databaseTableMetaData;
                }
            }
            finally {
                this.close(false);
            }
        }
        this.log("No valid connection available, aborting query.", 90);
        this.log("Returning from getTableMetaData.", 0);
        return null;
    }

    @Override
    public Collection<DatabaseColumnMetaData> getColumnMetaDataForTable(String tableName) {
        return this.getColumnMetaDataForTable(tableName, this.safeMode);
    }

    public Collection<DatabaseColumnMetaData> getColumnMetaDataForTable(String tableName, boolean safe) {
        this.close(false);
        this.rowCount = -1;
        this.connectionProfile = this.getDbConnection();
        if (this.connectionProfile != null) {
            try {
                int instruction = 5000;
                while (instruction == 5000) {
                    ArrayList<DatabaseColumnMetaData> columns;
                    DatabaseMetaData metaData;
                    instruction = 0;
                    if (!safe) {
                        ++this.tryCount;
                    }
                    try {
                        metaData = this.connectionProfile.getConnectionMetaData();
                        if (metaData == null) {
                            return null;
                        }
                        columns = new ArrayList<DatabaseColumnMetaData>();
                    }
                    catch (SQLException e) {
                        this.log("SQL Exception while getting meta data for columns of table '" + tableName + "': " + e, 70);
                        this.connectionProfile.close();
                        if (safe) {
                            throw new JdbcConnectorError("Failed to get meta data for columns of table '" + tableName + "'.", e);
                        }
                        instruction = this.notifyListener(1, e);
                        continue;
                    }
                    this.resultSet = metaData.getColumns(null, null, StringHelper.replaceSubstrings(tableName, "`", ""), "%");
                    this.next();
                    while (this.more()) {
                        DatabaseColumnMetaData columnInfo = new DatabaseColumnMetaData(this.getField("COLUMN_NAME", ""), this.getInt("DATA_TYPE", 1111));
                        columnInfo.setCatalogName(this.getField("TABLE_CAT", ""));
                        columnInfo.setSchemaName(this.getField("TABLE_SCHEM", ""));
                        columnInfo.setTableName(this.getField("TABLE_NAME", ""));
                        columnInfo.setColumnSize(this.getInt("COLUMN_SIZE", -1));
                        columnInfo.setDecimalDigits(this.getInt("DECIMAL_DIGITS", -1));
                        columnInfo.setRadix(this.getInt("NUM_PREC_RADIX", -1));
                        columnInfo.setNullable(StringHelper.equalsIgnoreCase(this.getField("IS_NULLABLE", ""), "yes"));
                        columnInfo.setOrdinalPosition(this.getInt("ORDINAL_POSITION", -1));
                        columns.add(columnInfo);
                        this.next();
                    }
                    ArrayList<DatabaseColumnMetaData> arrayList = columns;
                    return arrayList;
                }
            }
            finally {
                this.close(false);
            }
        } else {
            this.log("No valid connection available, aborting query.", 90);
        }
        this.log("Returning from getColumnMetaDataForTable.", 0);
        return null;
    }

    @Override
    public Collection<DatabaseColumnMetaData> getColumnMetaDataFromResultSet() {
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            ArrayList<DatabaseColumnMetaData> columns = new ArrayList<DatabaseColumnMetaData>(metaData.getColumnCount());
            int i = 1;
            while (i <= metaData.getColumnCount()) {
                DatabaseColumnMetaData columnInfo = new DatabaseColumnMetaData(metaData.getColumnName(i), metaData.getColumnType(i));
                columnInfo.setCatalogName(metaData.getCatalogName(i));
                columnInfo.setSchemaName(metaData.getSchemaName(i));
                columnInfo.setTableName(metaData.getTableName(i));
                columnInfo.setDecimalDigits(metaData.getPrecision(i));
                columnInfo.setNullable(metaData.isNullable(i) == 1);
                columnInfo.setOrdinalPosition(i);
                columns.add(columnInfo);
                ++i;
            }
            return columns;
        }
        catch (SQLException e) {
            this.log("Exception while gathering meta data from result set: " + e, 50);
            return null;
        }
    }

    @Override
    public byte[] getBytes(String fieldName) {
        try {
            return this.resultSet.getBytes(fieldName);
        }
        catch (SQLException exc) {
            return new byte[0];
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.close(false);
        this.connectionProfile = this.getDbConnection();
        return this.connectionProfile.getConnection();
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean wasNull() {
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException e) {
            this.log("Exception while calling wasNull() on the result set: " + e, 50);
            return false;
        }
    }

    @Override
    public Object getObject(String fieldName) {
        try {
            return this.resultSet.getObject(fieldName);
        }
        catch (SQLException exc) {
            return null;
        }
    }

    @Override
    public void reconnect() {
        if (this.connectionProfile != null) {
            this.connectionProfile.close();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getConnection().prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.getConnection().prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.getConnection().prepareStatement(sql, columnNames);
    }

    private void logWarnings(Connection c) {
        if (!this.manager.getAttributes().getLogWarnings()) {
            return;
        }
        try {
            if (c != null) {
                this.logWarnings(c.getWarnings());
            }
        }
        catch (SQLException exc) {
            this.log("Exception while logging warnings on Connection " + c, 70, exc);
        }
    }

    private void logWarnings(Statement s) {
        if (!this.manager.getAttributes().getLogWarnings()) {
            return;
        }
        try {
            if (s != null) {
                this.logWarnings(s.getWarnings());
                this.logWarnings(s.getConnection());
            }
        }
        catch (SQLException exc) {
            this.log("Exception while logging warnings on Statement " + s, 70, exc);
        }
    }

    private void logWarnings(ResultSet rs) {
        if (!this.manager.getAttributes().getLogWarnings()) {
            return;
        }
        try {
            if (rs != null) {
                this.logWarnings(rs.getWarnings());
                this.logWarnings(rs.getStatement());
            }
        }
        catch (SQLException exc) {
            this.log("Exception while logging warnings on ResultSet " + rs, 70, exc);
        }
    }

    private void logWarnings(SQLWarning warning) {
        if (!this.manager.getAttributes().getLogWarnings()) {
            return;
        }
        SQLWarning w = warning;
        while (w != null) {
            this.log("Warning: Error " + w.getErrorCode() + ", SQL state " + w.getSQLState() + ", message " + w.getMessage(), this.manager.getAttributes().getWarningLogLevel(), w.getCause());
            w = w.getNextWarning();
        }
    }
}

