/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.mapping;

import com.techempower.data.mapping.DataFieldToObjectEntityMap;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;

public class DataFieldToMethodMap
extends DataFieldToObjectEntityMap {
    private final Method method;
    private final int methodIndex;
    private final Class<?> javaFieldType;
    private final int columnIndex;
    private final boolean primitive;
    private final Type type;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataFieldToMethodMap(Method method, String columnName, int columnIndex, int fieldType, int methodIndex) {
        super(columnName, fieldType);
        this.method = method;
        this.methodIndex = methodIndex;
        this.columnIndex = columnIndex;
        if (method.getParameterTypes().length > 0) {
            this.javaFieldType = method.getParameterTypes()[0];
            if (this.javaFieldType.isPrimitive()) {
                this.primitive = true;
                if (this.javaFieldType == Boolean.TYPE) {
                    this.type = Type.BooleanPrimitive;
                    return;
                } else if (this.javaFieldType == Byte.TYPE) {
                    this.type = Type.BytePrimitive;
                    return;
                } else if (this.javaFieldType == Character.TYPE) {
                    this.type = Type.CharPrimitive;
                    return;
                } else if (this.javaFieldType == Double.TYPE) {
                    this.type = Type.DoublePrimitive;
                    return;
                } else if (this.javaFieldType == Float.TYPE) {
                    this.type = Type.FloatPrimitive;
                    return;
                } else if (this.javaFieldType == Integer.TYPE) {
                    this.type = Type.IntPrimitive;
                    return;
                } else if (this.javaFieldType == Long.TYPE) {
                    this.type = Type.LongPrimitive;
                    return;
                } else {
                    if (this.javaFieldType != Short.TYPE) throw new AssertionError((Object)("Unknown primitive type: " + this.javaFieldType.getName()));
                    this.type = Type.ShortPrimitive;
                }
                return;
            } else {
                this.primitive = false;
                this.type = this.javaFieldType == String.class ? Type.String : (this.javaFieldType == Integer.class ? Type.IntegerObject : (this.javaFieldType == Long.class ? Type.LongObject : (this.javaFieldType == Short.class ? Type.ShortObject : (this.javaFieldType == Boolean.class ? Type.BooleanObject : (this.javaFieldType == Byte.class ? Type.ByteObject : (this.javaFieldType == Character.class ? Type.CharacterObject : (this.javaFieldType == Double.class ? Type.DoubleObject : (this.javaFieldType == Float.class ? Type.FloatObject : (this.javaFieldType.isEnum() ? Type.Enum : (this.javaFieldType == Date.class ? Type.Date : (this.javaFieldType.isAssignableFrom(Calendar.class) ? Type.Calendar : Type.Unknown)))))))))));
            }
            return;
        } else {
            this.javaFieldType = null;
            this.type = Type.Unknown;
            this.primitive = true;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Class<?> getJavaFieldType() {
        return this.javaFieldType;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "DFTMM [" + this.getFieldName() + "; " + this.getFieldType() + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataFieldToMethodMap)) {
            return false;
        }
        return ((DataFieldToMethodMap)o).getFieldName().equals(this.getFieldName()) && ((DataFieldToMethodMap)o).method.equals(this.method);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static enum Type {
        Unknown,
        BooleanPrimitive,
        BytePrimitive,
        CharPrimitive,
        DoublePrimitive,
        FloatPrimitive,
        IntPrimitive,
        LongPrimitive,
        ShortPrimitive,
        String,
        IntegerObject,
        ByteObject,
        LongObject,
        ShortObject,
        BooleanObject,
        CharacterObject,
        DoubleObject,
        FloatObject,
        Enum,
        Date,
        Calendar;

    }
}

