/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.mapping;

import com.techempower.data.mapping.DataFieldToMethodMap;
import com.techempower.data.mapping.DataFieldToVariableMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class DataMappingCache {
    private static final ConcurrentHashMap<Class<?>, DataFieldToVariableMap[]> FIELD_MAPPINGS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, DataFieldToMethodMap[]> SET_METHOD_MAPPINGS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, DataFieldToMethodMap[]> GET_METHOD_MAPPINGS = new ConcurrentHashMap();

    public static DataFieldToVariableMap[] getFieldMappings(Class<?> someClass) {
        return FIELD_MAPPINGS.get(someClass);
    }

    public static DataFieldToMethodMap[] getSetMethodMappings(Class<?> someClass) {
        return SET_METHOD_MAPPINGS.get(someClass);
    }

    public static DataFieldToMethodMap[] getGetMethodMappings(Class<?> someClass) {
        return GET_METHOD_MAPPINGS.get(someClass);
    }

    public static void putFieldMappings(Class<?> someClass, List<DataFieldToVariableMap> mappings) {
        DataFieldToVariableMap[] array = new DataFieldToVariableMap[mappings.size()];
        mappings.toArray(array);
        FIELD_MAPPINGS.put(someClass, array);
    }

    public static void putSetMethodMappings(Class<?> someClass, List<DataFieldToMethodMap> mappings) {
        DataFieldToMethodMap[] array = new DataFieldToMethodMap[mappings.size()];
        mappings.toArray(array);
        SET_METHOD_MAPPINGS.put(someClass, array);
    }

    public static void putGetMethodMappings(Class<?> someClass, List<DataFieldToMethodMap> mappings) {
        DataFieldToMethodMap[] array = new DataFieldToMethodMap[mappings.size()];
        mappings.toArray(array);
        GET_METHOD_MAPPINGS.put(someClass, array);
    }

    private DataMappingCache() {
    }
}

