/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.mapping;

import com.techempower.data.DatabaseConnector;
import com.techempower.data.mapping.DatabaseColumnMetaData;
import com.techempower.helper.StringHelper;
import java.util.Collection;

public class DatabaseTableMetaData {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String tableType;
    private Collection<DatabaseColumnMetaData> columnData;

    public DatabaseTableMetaData() {
        this("", "", "", "");
    }

    public DatabaseTableMetaData(String tableName) {
        this("", "", tableName, "TABLE");
    }

    public DatabaseTableMetaData(String tableName, String tableType) {
        this("", "", tableName, tableType);
    }

    public DatabaseTableMetaData(String catalogName, String schemaName, String tableName, String tableType) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.columnData = null;
    }

    public void loadColumnData(DatabaseConnector connector) {
        if (StringHelper.isNonEmpty(this.tableName)) {
            this.columnData = connector.getColumnMetaDataForTable(this.tableName);
        }
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public Collection<DatabaseColumnMetaData> getColumnData() {
        return this.columnData;
    }
}

