/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.util;

import com.techempower.data.DatabaseConnector;
import com.techempower.data.util.TabularColumn;
import gnu.trove.map.TIntObjectMap;

public class DatabaseColumn
implements TabularColumn {
    private final String displayFieldName;
    private final String dbFieldName;
    private final String defaultValue;
    private final Object labelFields;

    public DatabaseColumn(String displayName, String dbFieldName, String defaultValue, Object labelFields) {
        this.displayFieldName = displayName;
        this.labelFields = labelFields;
        this.dbFieldName = dbFieldName;
        this.defaultValue = defaultValue;
    }

    public DatabaseColumn(String displayName, String dbFieldName, String defaultValue) {
        this.displayFieldName = displayName;
        this.dbFieldName = dbFieldName;
        this.defaultValue = defaultValue;
        this.labelFields = null;
    }

    @Override
    public String getValue(Object source) {
        if (source instanceof DatabaseConnector) {
            String dbValue;
            DatabaseConnector conn = (DatabaseConnector)source;
            if (this.labelFields != null) {
                int dbInt = conn.getInt(this.dbFieldName);
                if (this.labelFields instanceof TIntObjectMap) {
                    TIntObjectMap labelFieldsMap = (TIntObjectMap)this.labelFields;
                    dbValue = (String)labelFieldsMap.get(dbInt);
                    if (dbValue == null) {
                        dbValue = this.defaultValue;
                    }
                } else {
                    String[] labelFieldsString = (String[])this.labelFields;
                    dbValue = dbInt >= 0 && dbInt < labelFieldsString.length ? labelFieldsString[dbInt] : this.defaultValue;
                }
            } else {
                dbValue = conn.getField(this.dbFieldName, this.defaultValue);
            }
            return dbValue;
        }
        return this.defaultValue;
    }

    @Override
    public String getDisplayName() {
        return this.displayFieldName;
    }
}

