/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.util;

import com.techempower.data.util.ObjectColumn;
import com.techempower.data.util.TabularColumn;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class ReflectiveColumn
implements TabularColumn {
    public static final String TEMPLATE_MARKER = "$V";
    private final ObjectColumn odf;
    private final String template;

    public ReflectiveColumn(String methodName, String columnName, String defaultValue, String template) {
        this.odf = new ObjectColumn(columnName, methodName, defaultValue);
        this.template = template;
    }

    public ReflectiveColumn(String methodName, String columnName, String defaultValue) {
        this(methodName, columnName, defaultValue, null);
    }

    public String getTemplate() {
        return this.template;
    }

    public static ReflectiveColumn[] constructArray(String[] source) {
        int arrayInterval = 3;
        if (source.length % arrayInterval == 0) {
            ReflectiveColumn[] toReturn = new ReflectiveColumn[source.length / arrayInterval];
            int index = 0;
            int i = 0;
            while (i < source.length) {
                toReturn[index++] = new ReflectiveColumn(source[i], source[i + 1], source[i + 2]);
                i += arrayInterval;
            }
            return toReturn;
        }
        return new ReflectiveColumn[0];
    }

    public static ReflectiveColumn[] constructArrayWithTemplates(String[] source) {
        int arrayInterval = 4;
        if (source.length % arrayInterval == 0) {
            ReflectiveColumn[] toReturn = new ReflectiveColumn[source.length / arrayInterval];
            int index = 0;
            int i = 0;
            while (i < source.length) {
                toReturn[index++] = new ReflectiveColumn(source[i], source[i + 1], source[i + 2], source[i + 3]);
                i += arrayInterval;
            }
            return toReturn;
        }
        return new ReflectiveColumn[0];
    }

    @Override
    public String getValue(Object object) {
        if (StringHelper.isNonEmpty(this.template)) {
            return StringHelper.replaceSubstrings(this.template, TEMPLATE_MARKER, NetworkHelper.escapeStringForHtml(this.getRawValue(object)));
        }
        return this.getRawValue(object);
    }

    @Override
    public String getDisplayName() {
        return this.odf.getDisplayName();
    }

    public String getRawValue(Object object) {
        return this.odf.getValue(object);
    }
}

