/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.classloader.PackageClassLoader;
import com.techempower.gemini.Context;
import com.techempower.gemini.DispatchListener;
import com.techempower.gemini.Dispatcher;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.annotation.AnnotationHandler;
import com.techempower.gemini.annotation.CMD;
import com.techempower.gemini.annotation.Default;
import com.techempower.gemini.annotation.Role;
import com.techempower.gemini.annotation.URL;
import com.techempower.gemini.annotation.injector.ParameterInjector;
import com.techempower.gemini.annotation.intercept.HandlerIntercept;
import com.techempower.gemini.annotation.response.HandlerResponse;
import com.techempower.gemini.exceptionhandler.ExceptionHandler;
import com.techempower.gemini.handler.BasicHandler;
import com.techempower.gemini.prehandler.Prehandler;
import com.techempower.helper.ThrowableHelper;
import com.techempower.log.ComponentLog;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;

public class BasicDispatcher
implements Dispatcher {
    public static final String COMPONENT_CODE = "disp";
    public static final int REDISPATCH_LIMIT = 5;
    public static final int REDISPATCH_ABORT_LIMIT = 15;
    public static final String INTERNAL_ERROR_PAGE = "internal-error-handler";
    private final ComponentLog log;
    private final GeminiApplication application;
    private final CopyOnWriteArrayList<Handler<? extends BasicDispatcher, ? extends Context>> dispatchHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ExceptionHandler> exceptionHandlers = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, Handler<? extends BasicDispatcher, ? extends Context>> roledHandlers = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<Prehandler> prehandlers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<DispatchListener> listeners;
    private Handler<BasicDispatcher, LegacyContext> defaultHandler = new BasicHandler();
    private ConcurrentHashMap<String, Method> registeredCommands = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<HandlerIntercept<? extends BasicDispatcher, ? extends Context>> intercepts = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, HandlerIntercept<? extends BasicDispatcher, ? extends Context>> roledIntercepts = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<ParameterInjector<? extends BasicDispatcher, ? extends Context>> injectors = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, ParameterInjector<? extends BasicDispatcher, ? extends Context>> roledInjectors = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<HandlerResponse<? extends BasicDispatcher, ? extends Context>> responses = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, HandlerResponse<? extends BasicDispatcher, ? extends Context>> roledResponses = new ConcurrentHashMap();

    public BasicDispatcher(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.installHandlers();
    }

    protected void installHandlers() {
    }

    public ComponentLog getLog() {
        return this.log;
    }

    public void addListener(DispatchListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList();
        }
        this.listeners.add(listener);
    }

    public void addHandler(String role, Handler<? extends Dispatcher, ? extends Context> handler) {
        this.addHandler(handler);
        this.roledHandlers.put(role, handler);
        this.addHandler((Object)handler);
    }

    public void addHandler(Handler<? extends Dispatcher, ? extends Context> handler) {
        this.dispatchHandlers.add(handler);
        this.addHandler((Object)handler);
    }

    public void addHandler(Object handler) {
        Method[] methods;
        Class<?> c = handler.getClass();
        Method[] methodArray = methods = c.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!Modifier.isPublic(method.getModifiers())) {
                this.log.log("Error: Trying to use a non-public method as an annotateed handler: " + c.getSimpleName() + "." + method.getName());
            } else {
                Role role;
                Default defaultAnnotation;
                URL url;
                int n3;
                AnnotationHandler annotatedHandler = null;
                CMD cmd = method.getAnnotation(CMD.class);
                if (cmd != null) {
                    String[] commands = cmd.value();
                    annotatedHandler = new AnnotationHandler(this.application, this, handler, method, commands);
                    this.dispatchHandlers.add(annotatedHandler);
                    if (commands != null && commands.length > 0) {
                        String[] stringArray = commands;
                        n3 = commands.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String command = stringArray[n4];
                            this.registeredCommands.put(command, method);
                            ++n4;
                        }
                    }
                }
                if ((url = method.getAnnotation(URL.class)) != null) {
                    String[] urls;
                    String[] stringArray = urls = url.value();
                    int n5 = urls.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String rule = stringArray[n3];
                        this.application.getUrlRewriter().addRule(rule, rule);
                        annotatedHandler = new AnnotationHandler(this.application, this, handler, method, new String[]{rule});
                        this.dispatchHandlers.add(annotatedHandler);
                        this.registeredCommands.put(rule, method);
                        ++n3;
                    }
                }
                if ((defaultAnnotation = method.getAnnotation(Default.class)) != null) {
                    this.defaultHandler = annotatedHandler != null ? annotatedHandler : new AnnotationHandler(this.application, this, handler, method, null);
                }
                if ((role = method.getAnnotation(Role.class)) != null && annotatedHandler != null) {
                    this.roledHandlers.put(role.value(), annotatedHandler);
                }
            }
            ++n2;
        }
    }

    public void addHandler(Handler<? extends Dispatcher, ? extends Context> handler, int index) {
        this.dispatchHandlers.add(index, handler);
        this.addHandler((Object)handler);
    }

    public void addHandlers(String packageName) {
        try {
            for (Class<?> clazz : PackageClassLoader.getClasses(packageName)) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) continue;
                boolean isAnnotated = false;
                Method[] methodArray = clazz.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(CMD.class)) {
                        isAnnotated = true;
                        break;
                    }
                    ++n2;
                }
                if (!isAnnotated) continue;
                Object obj = null;
                try {
                    Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                    int n3 = constructorArray.length;
                    n = 0;
                    while (n < n3) {
                        Constructor<?> constructor = constructorArray[n];
                        if (constructor.getParameterTypes().length == 1 && GeminiApplication.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
                            obj = constructor.newInstance(this.application);
                            break;
                        }
                        ++n;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                    this.log.log("Warning: Class " + clazz.getName() + " could not be instantiated.", e);
                }
                if (obj == null) {
                    try {
                        obj = clazz.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        this.log.log("Warning: Class " + clazz.getName() + " could not be instantiated.", e);
                    }
                }
                if (obj == null) {
                    this.log.log("Warning: class " + clazz + " is an annotated handler without a valid constructor, so it has not been added as a handler.");
                    continue;
                }
                this.addHandler((Object)obj);
            }
        }
        catch (ClassNotFoundException e) {
            this.log.log("Warning: could not locate package " + packageName + ", aborting addHandlers", e);
        }
        catch (IOException e) {
            this.log.log("Warning: exception while accessing " + packageName + ", aborting addHandlers", e);
        }
    }

    public void addIntercept(HandlerIntercept<? extends BasicDispatcher, ? extends Context> intercept) {
        this.intercepts.add(intercept);
    }

    public void addIntercept(String role, HandlerIntercept<? extends BasicDispatcher, ? extends Context> intercept) {
        this.roledIntercepts.put(role, intercept);
        this.addIntercept(intercept);
    }

    public void addInjector(ParameterInjector<? extends BasicDispatcher, ? extends Context> injector) {
        this.injectors.add(injector);
    }

    public void addInjector(String role, ParameterInjector<? extends BasicDispatcher, ? extends Context> injector) {
        this.roledInjectors.put(role, injector);
        this.addInjector(injector);
    }

    public void addResponse(HandlerResponse<? extends BasicDispatcher, ? extends Context> response) {
        this.responses.add(response);
    }

    public void addResponse(String role, HandlerResponse<? extends BasicDispatcher, ? extends Context> response) {
        this.roledResponses.put(role, response);
        this.addResponse(response);
    }

    protected void addPrehandler(Prehandler pHandler) {
        if (pHandler == null) {
            throw new IllegalArgumentException("Prehandler may not be null.");
        }
        this.prehandlers.add(pHandler);
    }

    private boolean prehandle(Context context) {
        CopyOnWriteArrayList<Prehandler> prehandlerList = this.prehandlers;
        int i = 0;
        while (i < prehandlerList.size()) {
            Prehandler p = (Prehandler)prehandlerList.get(i);
            if (p.prehandle(context)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDefaultHandler(Handler<? extends BasicDispatcher, ? extends LegacyContext> handler) {
        this.defaultHandler = handler;
    }

    public String[] getHandlerDescriptions() {
        String[] descriptions = new String[this.dispatchHandlers.size()];
        int i = 0;
        while (i < descriptions.length) {
            Handler<? extends BasicDispatcher, ? extends Context> handler = this.dispatchHandlers.get(i);
            if (handler == null) {
                this.log.log("Handler " + i + " is null!");
            } else {
                descriptions[i] = handler.getDescription();
            }
            ++i;
        }
        return descriptions;
    }

    public void displayHandlerDescriptions() {
        String[] descriptions = this.getHandlerDescriptions();
        int i = 0;
        while (i < descriptions.length) {
            this.log.log(String.valueOf(i) + ": " + descriptions[i]);
            ++i;
        }
    }

    public void addExceptionHandler(ExceptionHandler excHandler) {
        this.exceptionHandlers.add(excHandler);
    }

    protected void displayDispatch(Context context, String command) {
        this.log.log(String.valueOf(context.getClientID()) + "; dispatching: " + command);
    }

    protected String gatherCommand(Context context) {
        String toReturn = context.query().get(this.getCommandParameterName(), this.getDefaultCommand());
        ((LegacyContext)context).setCommand(toReturn);
        return toReturn;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dispatch(Context rawContext) {
        LegacyContext context = (LegacyContext)rawContext;
        if (context != null) {
            String command = null;
            command = context.getCommand();
            if (command == null) {
                command = this.gatherCommand(context);
            }
            this.notifyListenersDispatchStarting(context, command);
            try {
                if (command != null) {
                    this.displayDispatch(context, command);
                    if (this.prehandle(context)) {
                        return true;
                    }
                    CopyOnWriteArrayList<Handler<? extends BasicDispatcher, ? extends Context>> handlers = this.dispatchHandlers;
                    int i = 0;
                    while (i < handlers.size()) {
                        Handler handler = (Handler)handlers.get(i);
                        boolean accept = handler.acceptRequest(this, context, command);
                        if (accept) {
                            int originalPriority = -1000;
                            if (handler.getPriority() != -1000) {
                                originalPriority = Thread.currentThread().getPriority();
                                if (originalPriority != handler.getPriority()) {
                                    BasicDispatcher.setThreadPriority(handler.getPriority());
                                } else {
                                    originalPriority = -1000;
                                }
                            }
                            boolean successfullyHandled = false;
                            try {
                                successfullyHandled = handler.handleRequest(this, context, command);
                            }
                            finally {
                                if (originalPriority != -1000) {
                                    BasicDispatcher.setThreadPriority(originalPriority);
                                }
                            }
                            if (successfullyHandled) {
                                return true;
                            }
                        }
                        ++i;
                    }
                    this.log.log("No handler for: " + command);
                } else {
                    this.log.log(String.valueOf(context.getClientID()) + "; dispatching with no command specified.");
                }
                if (command == null) {
                    command = this.getDefaultCommand();
                }
                if (this.defaultHandler.handleRequest(this, context, command)) {
                    return true;
                }
                this.log.log("Default handler's handleRequest method returned false!");
                return false;
            }
            catch (Throwable exc) {
                this.dispatchException(context, exc, null);
                return true;
            }
        }
        this.log.log("Error: dispatch() called with a null Context.");
        return false;
    }

    private static void setThreadPriority(int priority) {
        Thread.currentThread().setPriority(5);
    }

    public boolean redispatch(Context rawContext, String command) {
        LegacyContext context = (LegacyContext)rawContext;
        String previousCommand = context.getCommand();
        context.incrementDispatches();
        int redispatchCount = context.getDispatches();
        this.log.log("Redispatching: " + command + " (" + redispatchCount + ")");
        if (redispatchCount <= 5) {
            context.setCommand(command);
        } else {
            if (redispatchCount > 15) {
                try {
                    this.log.log("Dispatcher redispatched " + redispatchCount + " times.");
                    this.log.log("Redispatch abort limit hit!  Sending basic error message to user.");
                    context.print(this.getRedispatchAbortMessage());
                }
                catch (Error | Exception throwable) {
                    // empty catch block
                }
                return true;
            }
            this.log.log("Dispatcher redispatched " + redispatchCount + " times.");
            this.log.log("This is likely the cause of a dispatch loop; redirecting to " + this.getRedispatchLimitCommand() + ".");
            context.setCommand(this.getRedispatchLimitCommand());
        }
        this.notifyListenersRedispatch(context, previousCommand, command);
        return this.dispatch(context);
    }

    public GeminiApplication getApplication() {
        return this.application;
    }

    public String getCommandParameterName() {
        return "cmd";
    }

    public String getDefaultCommand() {
        return "home";
    }

    public Handler<? extends BasicDispatcher, ? extends Context> getDefaultHandler() {
        return this.defaultHandler;
    }

    public List<Handler<? extends BasicDispatcher, ? extends Context>> getDispatchHandlers() {
        return this.dispatchHandlers;
    }

    public Handler<? extends BasicDispatcher, ? extends Context> getRoledHandler(String role) {
        return this.roledHandlers.get(role);
    }

    public Handler<? extends BasicDispatcher, ? extends Context> getDispatchHandler(String description) {
        int i = 0;
        while (i < this.dispatchHandlers.size()) {
            Handler<? extends BasicDispatcher, ? extends Context> handler = this.dispatchHandlers.get(i);
            if (handler != null && handler.getDescription().equals(description)) {
                return handler;
            }
            ++i;
        }
        return null;
    }

    public HandlerIntercept<? extends BasicDispatcher, ? extends Context> getIntercept(Class<?> clazz) {
        for (HandlerIntercept<? extends BasicDispatcher, ? extends Context> intercept : this.intercepts) {
            if (intercept.getClass() != clazz) continue;
            return intercept;
        }
        return null;
    }

    public HandlerIntercept<? extends BasicDispatcher, ? extends Context> getRoledIntercept(String role) {
        return this.roledIntercepts.get(role);
    }

    public ParameterInjector<? extends BasicDispatcher, ? extends Context> getInjector(Class<?> clazz) {
        for (ParameterInjector<? extends BasicDispatcher, ? extends Context> injector : this.injectors) {
            if (injector.getClass() != clazz) continue;
            return injector;
        }
        return null;
    }

    public ParameterInjector<? extends BasicDispatcher, ? extends Context> getRoledInjector(String role) {
        return this.roledInjectors.get(role);
    }

    public HandlerResponse<? extends BasicDispatcher, ? extends Context> getResponse(Class<?> clazz) {
        for (HandlerResponse<? extends BasicDispatcher, ? extends Context> response : this.responses) {
            if (response.getClass() != clazz) continue;
            return response;
        }
        return null;
    }

    public HandlerResponse<? extends BasicDispatcher, ? extends Context> getRoledResponse(String role) {
        return this.roledResponses.get(role);
    }

    public String getRedispatchLimitCommand() {
        return "home";
    }

    public Map<String, Method> getRegisteredCommands() {
        return new HashMap<String, Method>(this.registeredCommands);
    }

    public String getRedispatchAbortMessage() {
        return "<html><head><title>Error</title></head><boby><h2>Error</h2><p>Sorry, we cannot process your request at this time.  Please try again in a few moments.</p></body></html>";
    }

    protected String getErrorHandlerPage() {
        return null;
    }

    protected boolean showExceptionTraces() {
        return false;
    }

    @Override
    public void dispatchException(Context context, Throwable exception, String description) {
        if (this.exceptionHandlers.size() > 0) {
            this.dispatchExceptionToHandlers(context, exception, description);
        } else {
            this.dispatchExceptionDefault(context, exception, description);
        }
    }

    protected void dispatchExceptionDefault(Context rawContext, Throwable exception, String description) {
        String localDescription = description;
        if (localDescription == null) {
            localDescription = "No detail available.";
        }
        if (exception instanceof ServletException) {
            ServletException servletException = (ServletException)exception;
            this.log.log("InfrastructureServlet caught exception:\n" + servletException.getRootCause());
            if (this.showExceptionTraces()) {
                this.log.log(ThrowableHelper.getStackTrace(servletException.getRootCause()));
            }
        } else {
            this.log.log("InfrastructureServlet caught exception:\n" + exception);
            if (this.showExceptionTraces()) {
                this.log.log(ThrowableHelper.getStackTrace(exception));
            }
        }
        if (rawContext != null) {
            LegacyContext context = (LegacyContext)rawContext;
            String errorHandler = this.getErrorHandlerPage();
            if (!context.getReferencedRender().equals(errorHandler) && !context.getReferencedRender().equals(INTERNAL_ERROR_PAGE)) {
                if (errorHandler != null) {
                    rawContext.delivery().putObject("Exception", exception);
                    rawContext.delivery().put("Description", localDescription);
                    context.setReferencedRender(errorHandler);
                    context.render(errorHandler);
                } else {
                    context.setReferencedRender(INTERNAL_ERROR_PAGE);
                    rawContext.print("<html>");
                    rawContext.print("<head><title>Internal error</title>");
                    rawContext.print("<style>");
                    rawContext.print("body { background-color: white; color: black; }");
                    rawContext.print("p { font-family: Arial, Helvetica, Sans-serif; font-size: 12px; }");
                    rawContext.print("h2 { font-family: Arial, Helvetica, Sans-serif; font-size: 14px; font-weight: bold; }");
                    rawContext.print("pre { font-size: 9px; }");
                    rawContext.print("</style>");
                    rawContext.print("</head>");
                    rawContext.print("<body>");
                    rawContext.print("<h2>Internal error</h2>");
                    rawContext.print("<p>An exception was caught by the application infrastructure:</p>");
                    rawContext.print("<p>" + localDescription + "</p>");
                    rawContext.print("<p><pre>");
                    context.printException(exception);
                    rawContext.print("");
                    rawContext.print("</pre></p>");
                    if (exception instanceof ServletException) {
                        ServletException servletException = (ServletException)exception;
                        if (servletException.getRootCause() != null) {
                            rawContext.print("<p>Root cause:</p>");
                            rawContext.print("<p><pre>");
                            context.printException(servletException.getRootCause());
                            rawContext.print("");
                            rawContext.print("</pre></p>");
                        } else {
                            rawContext.print("<p>No root cause provided.</p>");
                        }
                    }
                    rawContext.print("</body>");
                    rawContext.print("</html>");
                }
            } else {
                this.log.log("Exception received from error handler.  Not processing.");
            }
        }
    }

    protected void dispatchExceptionToHandlers(Context context, Throwable exception, String description) {
        try {
            if (this.exceptionHandlers != null && this.exceptionHandlers.size() > 0) {
                for (ExceptionHandler handler : this.exceptionHandlers) {
                    if (description != null) {
                        handler.handleException(context, exception, description);
                        continue;
                    }
                    handler.handleException(context, exception);
                }
            } else {
                this.log.log("Cannot dispatch exception; no ExceptionHandlers have been specified.");
            }
        }
        catch (Exception exc) {
            this.log.log("Exception while processing earlier exception: " + exc);
        }
    }

    @Override
    public void dispatchComplete(Context context) {
        this.notifyListenersDispatchComplete(context);
    }

    protected void notifyListenersDispatchStarting(Context context, String command) {
        CopyOnWriteArrayList<DispatchListener> theListeners = this.listeners;
        if (theListeners != null) {
            int i = 0;
            while (i < theListeners.size()) {
                ((DispatchListener)theListeners.get(i)).dispatchStarting(this, context, command);
                ++i;
            }
        }
    }

    protected void notifyListenersRedispatch(Context context, String previousCommand, String newCommand) {
        CopyOnWriteArrayList<DispatchListener> theListeners = this.listeners;
        if (theListeners != null) {
            int i = 0;
            while (i < theListeners.size()) {
                ((DispatchListener)theListeners.get(i)).redispatchOccurring(this, context, previousCommand, newCommand);
                ++i;
            }
        }
    }

    protected void notifyListenersDispatchComplete(Context context) {
        CopyOnWriteArrayList<DispatchListener> theListeners = this.listeners;
        if (theListeners != null) {
            int i = 0;
            while (i < theListeners.size()) {
                ((DispatchListener)theListeners.get(i)).dispatchComplete(this, context);
                ++i;
            }
        }
    }

    @Override
    public void renderStarting(Context context, String jspName) {
        CopyOnWriteArrayList<DispatchListener> theListeners = this.listeners;
        if (this.listeners != null) {
            int i = 0;
            while (i < theListeners.size()) {
                ((DispatchListener)theListeners.get(i)).renderStarting(this, jspName);
                ++i;
            }
        }
    }

    @Override
    public void renderComplete(Context context) {
        CopyOnWriteArrayList<DispatchListener> theListeners = this.listeners;
        if (this.listeners != null) {
            int i = 0;
            while (i < theListeners.size()) {
                ((DispatchListener)theListeners.get(i)).renderComplete(this, context);
                ++i;
            }
        }
    }
}

