/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.Version;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.InitConfig;
import com.techempower.gemini.InitializationTask;
import com.techempower.gemini.cluster.client.handler.ClientConfigurationHandler;
import com.techempower.gemini.configuration.ConfigurationProvider;
import com.techempower.gemini.configuration.FileConfigurationProvider;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class Configurator
implements InitializationTask {
    public static final String COMPONENT_CODE = "conf";
    public static final String CONFIGURATION_FILENAME_EXT = ".conf";
    public static final String PROP_WEBINF = "Servlet.WebInf";
    public static final String PROP_CONTEXTNAME = "Servlet.ContextName";
    public static final String PROP_DEPLOYMENTROOT = "Servlet.DeploymentRoot";
    public static final String PROP_MACHINENAME = "Servlet.MachineName";
    public static final String PROP_APPROOT = "Servlet.ApplicationRoot";
    public static final String PROP_APPROOT_LASTDIR = "Servlet.ApplicationRoot.LastDir";
    public static final String PROP_SERVLETPARAM_PREFIX = "Servlet.Parameter.";
    public static final String PROP_SERVLETATTRIB_PREFIX = "Servlet.Attribute.";
    private final List<Configurable> configurableComponents = new CopyOnWriteArrayList<Configurable>();
    private final GeminiApplication application;
    private final ComponentLog log;
    private final List<ConfigurationProvider> providers = new ArrayList<ConfigurationProvider>(2);
    private boolean configured = false;
    private EnhancedProperties lastProps = null;

    protected Configurator(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.addStandardProviders();
        application.addInitializationTask(this);
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected void addStandardProviders() {
        this.addProvider(new FileConfigurationProvider());
        this.addProvider(new ClientConfigurationHandler(this.application));
    }

    protected void addProvider(ConfigurationProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void taskInitialize(GeminiApplication app) {
        try {
            this.configureIfNecessary();
        }
        catch (Exception exc) {
            this.log.log("Configuration failed.", 90, exc);
        }
    }

    @Override
    public boolean isTaskReady(GeminiApplication app) {
        return this.isConfigured();
    }

    @Override
    public void taskRemediate(GeminiApplication app, int attemptNumber) {
        try {
            this.configureIfNecessary();
        }
        catch (Exception exc) {
            this.log.log("Configuration failed.  See earlier report.");
        }
    }

    public static String getMachineName() {
        String machineName = System.getenv("COMPUTERNAME");
        if (machineName == null) {
            try {
                machineName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (machineName != null) {
            machineName = machineName.toUpperCase();
        }
        return machineName;
    }

    public boolean configure() {
        Version version = this.application.getVersion();
        this.log.log("Configuring " + version.getAbbreviatedProductName() + " application.");
        EnhancedProperties props = this.getConfigurationFromProviders();
        if (props != null && props.size() > 0) {
            this.addStandardProperties(props, this.application);
            this.configureWithProps(props, version);
            this.configured = true;
            this.lastProps = props;
            this.log.log("Configuration complete.");
            return true;
        }
        this.log.log("Configuration failed; unable to read configuration file(s).", 90);
        return false;
    }

    public void configure(Configurable configurable) {
        configurable.configure(this.getLastProperties());
    }

    protected EnhancedProperties constructProperties() {
        EnhancedProperties props = new EnhancedProperties(this.application);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            props.put("Environment." + entry.getKey(), entry.getValue());
        }
        return props;
    }

    protected EnhancedProperties getConfigurationFromProviders() {
        EnhancedProperties props = null;
        for (ConfigurationProvider provider : this.providers) {
            boolean loaded = provider.load(this.application, this.log, props = this.constructProperties());
            if (!loaded) continue;
            return props;
        }
        return null;
    }

    public void addStandardProperties(EnhancedProperties props, GeminiApplication app) {
        String machineName;
        block8: {
            InitConfig config = app.getServletConfig();
            if (config != null) {
                String name;
                Enumeration<String> enumeration = config.getInitParameterNames();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    name = enumeration.nextElement();
                    props.put(PROP_SERVLETPARAM_PREFIX + name, config.getInitParameter(name));
                }
                enumeration = config.getAttributeNames();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    name = enumeration.nextElement();
                    props.put(PROP_SERVLETATTRIB_PREFIX + name, config.getAttribute(name).toString());
                }
                if (config.getRealPath("/") != null) {
                    props.put(PROP_DEPLOYMENTROOT, config.getRealPath("/"));
                }
                if (config.getRealPath("/WEB-INF") != null) {
                    props.put(PROP_WEBINF, config.getRealPath("/WEB-INF"));
                }
                try {
                    File deployRoot = new File(config.getRealPath("/"));
                    String appRootPath = deployRoot.getParent();
                    props.put(PROP_APPROOT, appRootPath);
                    File appRoot = new File(appRootPath);
                    props.put(PROP_APPROOT_LASTDIR, appRoot.getName());
                }
                catch (Exception exc) {
                    if (config.getRealPath("/") == null) break block8;
                    props.put(PROP_APPROOT, config.getRealPath("/"));
                }
            }
        }
        if ((machineName = Configurator.getMachineName()) != null) {
            props.put(PROP_MACHINENAME, machineName);
        }
    }

    public EnhancedProperties getLastProperties() {
        return this.lastProps;
    }

    protected boolean configureIfNecessary() {
        if (!this.isConfigured()) {
            return this.configure();
        }
        return true;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    protected void configureWithProps(EnhancedProperties props, Version version) {
        this.application.getApplicationLog().configure(props, version);
        this.application.configure(props);
        this.configureConfigurables(props);
        this.customConfiguration(props);
    }

    public void addConfigurable(Configurable configurable) {
        this.configurableComponents.add(configurable);
    }

    public void removeConfigurable(Configurable configurable) {
        this.configurableComponents.remove(configurable);
    }

    protected void configureConfigurables(EnhancedProperties props) {
        int size = this.configurableComponents.size();
        this.log.log("Configuring " + size + " Configurable" + StringHelper.pluralize(size) + ".", 10);
        for (Configurable configurable : this.configurableComponents) {
            this.log.log("Configuring " + configurable + ".", 10);
            configurable.configure(props);
        }
        this.log.log("Done configuring Configurables.", 10);
    }

    protected void customConfiguration(EnhancedProperties props) {
        this.customConfiguration(props, null);
    }

    @Deprecated
    protected void customConfiguration(EnhancedProperties props, Version version) {
    }
}

