/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.data.DatabaseConnector;
import com.techempower.data.DatabaseConnectorIterator;
import com.techempower.data.util.TabularColumn;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.InitConfig;
import com.techempower.helper.DatabaseHelper;
import com.techempower.helper.StringHelper;
import com.techempower.js.JavaScriptWriter;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import com.techempower.util.StringList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class GeminiHelper {
    public static final int BUFFER_SIZE = 4096;
    private static final String[] HTML_FINDS = new String[]{"<BR>", "<br>", "<P>", "<p>", "&nbsp;"};
    private static final String[] HTML_REPLACEMENTS = new String[]{"\n", "\n", "\n", "\n", " "};

    public static boolean dataDump(GeminiApplication application, Context context, List<? extends TabularColumn> fieldAttribs, String query, String exportFilename, ComponentLog log) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (DatabaseConnector conn = application.getConnectorFactory().getConnector(query);){
            conn.runQuery();
            DatabaseConnectorIterator dbConnIter = new DatabaseConnectorIterator(conn);
            return GeminiHelper.dataDump(application, context, fieldAttribs, dbConnIter, exportFilename, log);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean dataDump(GeminiApplication application, Context context, List<? extends TabularColumn> fieldAttribs, Iterator<?> sourceIterator, String exportFilename, ComponentLog log) {
        String mimeType;
        boolean setContentType = false;
        InitConfig servletConfig = application.getServletConfig();
        if (servletConfig != null && (mimeType = servletConfig.getMimeType(exportFilename)) != null) {
            context.setContentType(mimeType);
            setContentType = true;
        }
        if (!setContentType) {
            context.setContentType("text/plain;name=\"" + exportFilename + "\"");
        }
        context.headers().put("Content-disposition", "attachment; filename=\"" + exportFilename + "\"");
        try {
            OutputStream os = context.getOutputStream();
            StringList line = new StringList();
            int i = 0;
            while (i < fieldAttribs.size()) {
                TabularColumn dumpField = fieldAttribs.get(i);
                line.add(DatabaseHelper.prepareDoubleQuote(dumpField.getDisplayName()));
                ++i;
            }
            String toWrite = String.valueOf(line.toString()) + "\r\n";
            os.write(toWrite.getBytes(), 0, toWrite.length());
            while (sourceIterator.hasNext()) {
                Object source = sourceIterator.next();
                line = new StringList();
                int i2 = 0;
                while (i2 < fieldAttribs.size()) {
                    TabularColumn dumpField = fieldAttribs.get(i2);
                    String dumpString = DatabaseHelper.prepareDoubleQuote(dumpField.getValue(source));
                    dumpString = StringHelper.replaceSubstrings(dumpString, "\r\n", "\\n");
                    line.add(dumpString);
                    ++i2;
                }
                toWrite = String.valueOf(line.toString()) + "\r\n";
                os.write(toWrite.getBytes(), 0, toWrite.length());
            }
            os.flush();
            return true;
        }
        catch (IOException ioexc) {
            log.log("IOException while dumping data: " + ioexc);
            return false;
        }
    }

    public static Map<String, String> getAllRequestParameters(Context context) {
        return GeminiHelper.getAllRequestParameters(context.getQueryString());
    }

    public static Map<String, String> getAllRequestParameters(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String decoded = URLDecoder.decode(query, StandardCharsets.UTF_8.name());
            StringTokenizer tokenizer = new StringTokenizer(decoded, "?&");
            while (tokenizer.hasMoreElements()) {
                String piece = tokenizer.nextToken();
                int equalsPosition = piece.indexOf(61);
                if (equalsPosition > 0) {
                    if (equalsPosition == piece.length() - 1) {
                        map.put(piece.substring(0, equalsPosition), null);
                        continue;
                    }
                    map.put(piece.substring(0, equalsPosition), piece.substring(equalsPosition + 1));
                    continue;
                }
                if (equalsPosition != -1) continue;
                map.put(piece, null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return map;
    }

    public static boolean sendJson(Context context, Object object) {
        return GeminiHelper.sendJson(context, null, object, null);
    }

    public static boolean sendJson(Context context, Object object, JavaScriptWriter jsw) {
        return GeminiHelper.sendJson(context, null, object, jsw);
    }

    public static boolean sendJson(Context context, String objectName, Object object) {
        return GeminiHelper.sendJson(context, objectName, object, null);
    }

    public static boolean sendJson(Context context, String objectName, Object object, JavaScriptWriter jsw) {
        JavaScriptWriter writer = jsw != null ? jsw : context.getApplication().getJavaScriptWriter();
        context.setContentType("application/json");
        if (StringHelper.isNonEmpty(objectName)) {
            context.print(String.valueOf('{') + writer.write(objectName) + ':' + writer.write(object) + '}');
        } else {
            context.print(writer.write(object));
        }
        return true;
    }

    @Deprecated
    public static boolean sendSingleJsonObject(Context context, String objectName, Object object) {
        return GeminiHelper.sendJson(context, objectName, object, null);
    }

    @Deprecated
    public static boolean sendSingleJsonObject(Context context, String objectName, Object object, JavaScriptWriter jsw) {
        return GeminiHelper.sendJson(context, objectName, object, jsw);
    }

    @Deprecated
    public static boolean sendJsonMap(Context context, Map<?, ?> map) {
        return GeminiHelper.sendJson(context, map);
    }

    @Deprecated
    public static boolean sendJsonMap(Context context, Map<?, ?> map, JavaScriptWriter jsw) {
        return GeminiHelper.sendJson(context, map, jsw);
    }

    public static boolean sendPlaintext(Context context, String text) {
        context.setContentType("text/plain");
        context.print(text);
        return true;
    }

    @Deprecated
    public static String convertHTMLToText(String textValue) {
        return GeminiHelper.convertHtmlToText(textValue);
    }

    public static String convertHtmlToText(String textValue) {
        String firstPass = StringHelper.replaceSubstrings(textValue, HTML_FINDS, HTML_REPLACEMENTS);
        StringBuilder toReturn = new StringBuilder();
        char[] characters = firstPass.toCharArray();
        boolean inTag = false;
        int i = 0;
        while (i < characters.length) {
            if (inTag) {
                if (characters[i] == '>') {
                    inTag = false;
                }
            } else if (characters[i] == '<') {
                inTag = true;
            } else {
                toReturn.append(characters[i]);
            }
            ++i;
        }
        return toReturn.toString();
    }

    public static String generateJavaScriptValidName(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        String firstChar = s.substring(0, 1);
        firstChar = firstChar.replaceAll("[^a-zA-Z_$]", "_");
        if (s.length() == 1) {
            return firstChar;
        }
        String rest = s.substring(1);
        rest = rest.replaceAll("[^0-9a-zA-Z_$]", "_");
        return String.valueOf(firstChar) + rest;
    }

    public static EnhancedProperties convertServletConfigToProps(InitConfig config) {
        EnhancedProperties props = new EnhancedProperties();
        Enumeration<String> params = config.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = params.nextElement();
            props.put(name, config.getInitParameter(name));
        }
        return props;
    }

    public static boolean isJsonRequest(Context context) {
        return StringHelper.containsNullSafe(context.headers().accept(), "application/json") || "json".equals(context.query().get("format", ""));
    }

    public static boolean sendJsonError(Context context, String error, String errorType, String errorMessage, String errorDescription, Map<String, String> ancillary) {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("error", error);
        map.put("errorType", errorType);
        map.put("errorMessage", errorMessage);
        map.put("errorDescription", StringHelper.isNonEmpty(errorDescription) ? errorDescription : "No detail available.");
        if (ancillary != null) {
            for (String key : ancillary.keySet()) {
                map.put(key, ancillary.get(key));
            }
        }
        context.setStatus(500);
        return GeminiHelper.sendJson(context, map);
    }

    private GeminiHelper() {
    }
}

