/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.Version;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.HttpInitConfig;
import com.techempower.gemini.HttpRequest;
import com.techempower.gemini.RequestListener;
import com.techempower.gemini.log.GeminiComponentLog;
import com.techempower.helper.CollectionHelper;
import com.techempower.log.ComponentLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class InfrastructureServlet
extends HttpServlet {
    private static final long serialVersionUID = 8642344935L;
    public static final String COMPONENT_CODE = "svlt";
    private final GeminiApplication application = this.getApplication();
    private final ComponentLog log = this.application.getLog("svlt");
    private final Version version = this.application.getVersion();
    private RequestListener[] listeners = new RequestListener[0];

    public void init() {
        this.application.setServlet(this);
        HttpInitConfig config = HttpInitConfig.createHttpInitConfig(this.getServletConfig(), this.getServletContext());
        this.application.initialize(config);
    }

    public abstract GeminiApplication getApplication();

    public void destroy() {
        super.destroy();
        this.application.end();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    /*
     * Unable to fully structure code
     */
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block17: {
            if (this.application.isRunning()) {
                httpRequest = new HttpRequest(request, response, this.getServletContext(), this.application);
                i = 0;
                while (i < this.listeners.length) {
                    try {
                        this.listeners[i].requestStarting(httpRequest);
                    }
                    catch (Exception var5_6) {
                        // empty catch block
                    }
                    ++i;
                }
                context = this.application.getContext(httpRequest);
                i = 0;
                while (i < this.listeners.length) {
                    try {
                        this.listeners[i].contextCreated(context);
                    }
                    catch (Exception var6_9) {
                        // empty catch block
                    }
                    ++i;
                }
                try {
                    this.handleRequest(context);
                }
                finally {
                    i = 0;
                    ** while (i < this.listeners.length)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.listeners[i].requestCompleting(context.getRequest(), context);
                    }
                    catch (Exception var7_13) {
                        // empty catch block
                    }
                    ++i;
                    continue;
lbl35:
                    // 1 sources

                    break block17;
                }
            }
            if (this.application.getState() == GeminiApplication.OperationalState.NEW) {
                this.handleError(request, response, "Application not yet initialized.");
            } else {
                this.handleError(request, response, "Application not running.");
            }
        }
    }

    public void handleRequest(Context context) {
        String threadName = null;
        if (this.application.isRequestCounting()) {
            threadName = Thread.currentThread().getName();
            long requestNumber = this.application.incrementRequestCount();
            Thread.currentThread().setName(String.valueOf(threadName) + " (Request " + requestNumber + ")");
            context.setRequestNumber(requestNumber);
        }
        try {
            GeminiComponentLog.setContextInformation(context);
            this.application.getDispatcher().dispatch(context);
        }
        finally {
            this.application.getDispatcher().dispatchComplete(context);
            GeminiComponentLog.clearContextInformation();
            Context.complete();
            if (this.application.isRequestCounting() && threadName != null) {
                Thread.currentThread().setName(threadName);
            }
        }
    }

    public void handleError(HttpServletRequest request, HttpServletResponse response, String error) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<html>");
        ((Writer)writer).write("<head><title>Temporarily Unavailable</title>");
        ((Writer)writer).write("<style>");
        ((Writer)writer).write("body { background-color: white; color: black; }");
        ((Writer)writer).write("p { font-family: Arial, Helvetica, Sans-serif; font-size: 12px; }");
        ((Writer)writer).write("h2 { font-family: Arial, Helvetica, Sans-serif; font-size: 14px; font-weight: bold; }");
        ((Writer)writer).write("pre { font-size: 9px; }");
        ((Writer)writer).write("</style>");
        ((Writer)writer).write("</head>");
        ((Writer)writer).write("<body>");
        ((Writer)writer).write("<h2>Temporarily Unavailable</h2>\r\n");
        ((Writer)writer).write("<p>This web site is temporarily unavailable due to maintenance work.  Please check back later.</p>\r\n");
        ((Writer)writer).write("<!-- " + error + " -->" + "\r\n");
        ((Writer)writer).write("</body></html>");
    }

    public String getServletName() {
        return String.valueOf(this.version.getAbbreviatedProductName()) + " Servlet version " + this.version.getVersionString();
    }

    public String getServletInfo() {
        return String.valueOf(this.getServletName()) + " - Copyright (c) " + this.version.getCopyrightYears() + " " + this.version.getClientName() + " - developed by " + this.version.getDeveloperName() + ".";
    }

    public void addRequestListener(RequestListener listener) {
        if (this.listeners.length == 0 || !CollectionHelper.arrayContains(this.listeners, listener)) {
            RequestListener[] temp = new RequestListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, temp, 0, this.listeners.length);
            temp[temp.length - 1] = listener;
            this.listeners = temp;
        }
    }

    protected void displayInitParameters() {
        Enumeration enumeration = this.getServletConfig().getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.log.log("Servlet initialization parameters:");
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                this.log.log(String.valueOf(name) + ": " + this.getServletConfig().getInitParameter(name));
            }
        } else {
            this.log.log("No Servlet initialization parameters set.");
        }
        ServletContext servletContext = this.getServletConfig().getServletContext();
        enumeration = servletContext.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.log.log("ServletContext initialization parameters:");
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                this.log.log(String.valueOf(name) + ": " + servletContext.getInitParameter(name));
            }
        } else {
            this.log.log("No ServletContext initialization parameters set.");
        }
    }
}

