/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.InitConfig;
import com.techempower.gemini.log.GeminiComponentLog;
import com.techempower.gemini.pyxis.BasicUser;
import com.techempower.gemini.simulation.GetSimRequest;
import com.techempower.gemini.simulation.PostSimRequest;
import com.techempower.gemini.simulation.SimClient;
import com.techempower.gemini.simulation.SimConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Simulation {
    public static final String COMPONENT_CODE = "simu";
    private final GeminiApplication application = this.getApplication();
    private final String docroot = this.getDocroot();

    public Simulation() {
        this.init();
    }

    public void init() {
        InitConfig config = null;
        if (this.getServletConfig() != null) {
            config = this.getServletConfig();
        }
        this.application.initialize(config);
    }

    public InitConfig getServletConfig() {
        return new SimConfig(this.docroot);
    }

    public Context postRequest(SimClient client, String url, Map<String, String> parameters) {
        if (this.application.isRunning()) {
            PostSimRequest request = new PostSimRequest(this, url, parameters, client, this.application);
            Context context = this.application.getContext(request);
            this.handleRequest(context);
            return context;
        }
        if (this.application.getState() == GeminiApplication.OperationalState.NEW) {
            HashMap<String, String> toReturn = new HashMap<String, String>();
            toReturn.put("Error", "Application not yet initialized.");
            return null;
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put("Error", "Application not running.");
        return null;
    }

    public Context getRequest(SimClient client, String url, Map<String, String> parameters) {
        if (this.application.isRunning()) {
            GetSimRequest request = new GetSimRequest(this, url, parameters, client, this.application);
            Context context = this.application.getContext(request);
            this.handleRequest(context);
            return context;
        }
        if (this.application.getState() == GeminiApplication.OperationalState.NEW) {
            HashMap<String, String> toReturn = new HashMap<String, String>();
            toReturn.put("Error", "Application not yet initialized.");
            return null;
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put("Error", "Application not running.");
        return null;
    }

    public void handleRequest(Context context) {
        String threadName = null;
        if (this.application.isRequestCounting()) {
            threadName = Thread.currentThread().getName();
            long requestNumber = this.application.incrementRequestCount();
            Thread.currentThread().setName(String.valueOf(threadName) + " (Request " + requestNumber + ")");
            context.setRequestNumber(requestNumber);
        }
        try {
            GeminiComponentLog.setContextInformation(context);
            this.application.getDispatcher().dispatch(context);
        }
        finally {
            this.application.getDispatcher().dispatchComplete(context);
            GeminiComponentLog.clearContextInformation();
            Context.complete();
            if (this.application.isRequestCounting() && threadName != null) {
                Thread.currentThread().setName(threadName);
            }
        }
    }

    public boolean login(SimClient client, String username) {
        PostSimRequest request = new PostSimRequest(this, "", null, client, this.application);
        Context context = this.application.getContext(request);
        BasicUser user = null;
        List<? extends BasicUser> users = this.application.getStore().list(this.getUserClass());
        for (BasicUser basicUser : users) {
            if (!basicUser.getUserUsername().equals(username)) continue;
            user = basicUser;
            break;
        }
        if (user != null) {
            this.application.getSecurity().login(context, user);
            return true;
        }
        return false;
    }

    public void destroy() {
        this.application.end();
    }

    public abstract GeminiApplication getApplication();

    protected abstract String getDocroot();

    protected abstract Class<? extends BasicUser> getUserClass();
}

