/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini;

import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class UrlRule {
    private List<UrlParam> params;
    private String originalRule;
    private String processedRule;
    private String ruleTemplate;
    private String command;

    public UrlRule(String rule, String command) {
        this.command = command;
        this.originalRule = rule;
        this.params = new ArrayList<UrlParam>();
        this.processRule();
    }

    private void processRule() {
        this.processedRule = this.originalRule.replaceAll("\\(\\?<.+?>", "(");
        try {
            Pattern.compile(this.processedRule);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex: " + this.originalRule);
        }
        this.ruleTemplate = this.originalRule;
        Pattern p = Pattern.compile("(\\(\\?<.+?>.+?\\))");
        Matcher m = p.matcher(this.originalRule);
        while (m.find()) {
            Pattern named;
            Matcher mNamed;
            String group;
            if (m.groupCount() <= 0 || !(group = m.group(1)).startsWith("(?<") || !(mNamed = (named = Pattern.compile("<(.+)>")).matcher(group)).find() || mNamed.groupCount() <= 0) continue;
            String name = mNamed.group(1);
            if (StringHelper.isEmptyTrimmed(name)) {
                throw new IllegalArgumentException("Named Parameters must have a non-empty name: " + group);
            }
            String regex = group.substring(group.indexOf(62) + 1, group.length() - 1);
            this.params.add(new UrlParam(name, regex));
            this.ruleTemplate = this.ruleTemplate.replaceFirst(Pattern.quote(group), "<" + name + ">");
        }
    }

    public boolean matches(String url) {
        Pattern p = Pattern.compile(this.processedRule);
        Matcher m = p.matcher(url);
        return m.matches();
    }

    public boolean matches(Map<String, String> toReplace) {
        boolean matchingParams = true;
        block0: for (UrlParam param : this.params) {
            for (Map.Entry<String, String> entry : toReplace.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(param.getName()) || entry.getValue().matches(param.getRegex())) continue;
                matchingParams = false;
                continue block0;
            }
        }
        return matchingParams;
    }

    public Map<String, String> parseParams(String url) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        Pattern p = Pattern.compile(this.processedRule);
        Matcher m = p.matcher(url);
        if (m.matches()) {
            int i = 1;
            while (i <= m.groupCount()) {
                toReturn.put(this.params.get(i - 1).getName(), m.group(i));
                ++i;
            }
        }
        return toReturn;
    }

    public String toUrl(Map<String, String> parameters) {
        if (!this.matches(parameters)) {
            return "/";
        }
        String url = "/" + this.ruleTemplate;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            url = url.replaceFirst("<" + entry.getKey() + ">", entry.getValue());
        }
        return url;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getRule() {
        return this.originalRule;
    }

    public static void main(String[] args) {
        String rule = "Articles/(?<year>\\d+)/Sports-(?<section>\\d+)-(?<chapter>\\d*)/(?<author>[a-zA-Z]+)";
        UrlRule myrule = new UrlRule(rule, "cmd");
        String url = "Articles/1/Sports-12-/abc";
        Map<String, String> params = null;
        if (myrule.matches(url)) {
            params = myrule.parseParams(url);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                System.out.println(String.valueOf(entry.getKey()) + ": " + entry.getValue());
            }
        }
        if (myrule.matches(params)) {
            String converted = myrule.toUrl(params);
            System.out.println(converted);
            System.out.println(converted.equals(url));
        }
    }

    private class UrlParam {
        protected String name;
        protected String regex;

        public UrlParam(String name, String regex) {
            this.name = name;
            this.regex = regex;
        }

        public String getName() {
            return this.name;
        }

        public String getRegex() {
            return this.regex;
        }
    }
}

