/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.AdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;

public abstract class BasicAdminFunction
implements AdminFunction {
    private final String name;
    private final String description;
    private final String category;
    private final String pathSegment;
    private final boolean displayOnMenu;
    private final boolean isDefault;

    public BasicAdminFunction(String pathSegment, String name, String description, String category) {
        this.name = name;
        this.description = description;
        this.pathSegment = pathSegment;
        this.category = category;
        this.displayOnMenu = true;
        this.isDefault = false;
    }

    public BasicAdminFunction(String pathSegment, String name, String description, String category, boolean displayOnMenu, boolean isDefault) {
        this.name = name;
        this.description = description;
        this.pathSegment = pathSegment;
        this.category = category;
        this.displayOnMenu = displayOnMenu;
        this.isDefault = isDefault;
    }

    @Override
    public String getPathSegment() {
        return this.pathSegment;
    }

    @Override
    public String getFunctionName() {
        return this.name;
    }

    public String getTemplateName() {
        return String.valueOf(this.getFunctionCategory()) + "-" + this.getPathSegment();
    }

    @Override
    public String getRelativeUri() {
        return "/" + this.getFunctionCategory() + "/" + this.getPathSegment();
    }

    @Override
    public String getFunctionDescription() {
        return this.description;
    }

    @Override
    public String getFunctionCategory() {
        return this.category;
    }

    @Override
    public boolean displayOnMenu() {
        return this.displayOnMenu;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public abstract boolean handle(Context var1, BasicAdminHandler<?> var2, GeminiApplication var3, ComponentLog var4);

    @Override
    public void configure(EnhancedProperties props, BasicAdminHandler<?> bah) {
    }
}

