/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin;

import com.techempower.cache.EntityStore;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.AdminFunction;
import com.techempower.gemini.admin.AdminFunctionCategory;
import com.techempower.gemini.path.BasicPathHandler;
import com.techempower.gemini.path.PathSegments;
import com.techempower.gemini.pyxis.BasicUserGroup;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.gemini.pyxis.authorization.Authorizer;
import com.techempower.helper.StringHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BasicAdminHandler<C extends Context>
extends BasicPathHandler<C>
implements Configurable {
    public static final String COMPONENT_CODE = "hAdm";
    public static final String DEFAULT_CONFIG_PREFIX = "Admin.";
    public static final String REQUEST_ADMIN_NONCE = "arc";
    public static final String SESSION_ADMIN_NONCE = "GeminiAdmin-Nonce";
    public static final String DEFAULT_PATH = "admin/";
    public static final String TEMPLATE_MENU = "menu";
    public static final String TEMPLATE_CONFIRMATION = "confirmation";
    public static final String TEMPLATE_INFORMATION = "information";
    public static final int SEVERITY_LOW = 0;
    public static final int SEVERITY_MEDIUM = 5;
    public static final int SEVERITY_HIGH = 10;
    public static final int ADMIN_NONCE_LENGTH = 10;
    private final EntityStore store;
    private final PyxisSecurity security;
    private final String configPrefix;
    private String templatePath = "admin/";
    private Map<String, AdminFunction> functions;
    private Map<String, AdminFunctionCategory> categories;
    private Map<String, AdminCategoryMenu> categoryMenus;
    private final Class<? extends PyxisUser> userClass;
    private final Class<? extends PyxisUserGroup> groupClass;
    protected static final Authorizer ADMIN_AUTHORIZER = new Authorizer(){

        @Override
        public boolean isAuthorized(PyxisUser user) {
            return user.isAdministrator();
        }
    };

    public BasicAdminHandler(GeminiApplication app, String configurationPrefix, Class<? extends PyxisUser> userClass, Class<? extends PyxisUserGroup> groupClass) {
        super(app);
        this.store = app.getStore();
        this.userClass = userClass;
        this.groupClass = groupClass;
        this.security = app.getSecurity();
        this.configPrefix = StringHelper.isNonEmpty(configurationPrefix) ? configurationPrefix : DEFAULT_CONFIG_PREFIX;
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus(this.configPrefix);
        this.templatePath = focus.getProperty("TemplatePath", DEFAULT_PATH);
        if (this.categories != null) {
            Iterator<AdminFunctionCategory> cat = this.categories.values().iterator();
            while (cat.hasNext()) {
                cat.next().configure(props, this);
            }
        }
        if (this.functions != null) {
            Iterator<AdminFunction> func = this.functions.values().iterator();
            while (func.hasNext()) {
                func.next().configure(props, this);
            }
        }
    }

    public void addFunction(AdminFunction function) {
        String catName = function.getFunctionCategory();
        this.lazyInitializeFunctions();
        if (function.displayOnMenu()) {
            this.lazyInitializeCategories();
            AdminCategoryMenu menu = this.categoryMenus.get(catName);
            if (menu == null && (menu = this.categoryMenus.get(catName = "misc")) == null) {
                AdminFunctionCategory miscCat = new AdminFunctionCategory("misc", "Miscellaneous");
                menu = new AdminCategoryMenu(miscCat);
                this.categoryMenus.put("misc", menu);
            }
            menu.addFunction(function);
        }
        this.functions.put(String.valueOf(catName) + "-" + function.getPathSegment(), function);
        if (function.isDefault()) {
            this.functions.put(catName, function);
        }
    }

    public void addFunctionCategory(AdminFunctionCategory category) {
        this.lazyInitializeCategories();
        this.categories.put(category.getName(), category);
        this.categoryMenus.put(category.getName(), new AdminCategoryMenu(category));
        AdminFunction[] catFuncs = category.getStandardFunctions();
        if (catFuncs != null) {
            AdminFunction[] adminFunctionArray = catFuncs;
            int n = catFuncs.length;
            int n2 = 0;
            while (n2 < n) {
                AdminFunction func = adminFunctionArray[n2];
                this.addFunction(func);
                ++n2;
            }
        }
    }

    protected void lazyInitializeFunctions() {
        if (this.functions == null) {
            this.functions = new HashMap<String, AdminFunction>();
        }
    }

    protected void lazyInitializeCategories() {
        if (this.categories == null) {
            this.categories = new HashMap<String, AdminFunctionCategory>();
            this.categoryMenus = new TreeMap<String, AdminCategoryMenu>();
        }
    }

    public AdminFunctionCategory getFunctionCategory(String name) {
        if (this.categories != null) {
            return this.categories.get(name);
        }
        return null;
    }

    public AdminFunction getFunction(String name) {
        if (this.functions != null) {
            return this.functions.get(name);
        }
        return null;
    }

    @Override
    public boolean handle(PathSegments segments, C context) {
        if (this.security.authCheck((Context)context, ADMIN_AUTHORIZER, this.security.getForceLoginRejector())) {
            BasicAdminHandler.setupAdminSession(context);
            return this.internalDispatch(segments, context);
        }
        return true;
    }

    protected boolean internalDispatch(PathSegments segments, C context) {
        String lookup;
        AdminFunction function;
        this.delivery().put("baseUri", this.getBaseUri());
        if (this.functions != null && segments.getCount() >= 1 && (function = this.functions.get(lookup = String.valueOf(segments.get(0)) + (segments.getCount() >= 2 ? "-" + segments.get(1) : ""))) != null) {
            return function.handle((Context)context, this, this.app(), this.log());
        }
        return this.handleMenu((Context)context);
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public String getConfigPrefix() {
        return this.configPrefix;
    }

    public Class<? extends PyxisUser> getUserClass() {
        return this.userClass;
    }

    public Class<? extends PyxisUserGroup> getUserGroupClass() {
        return this.groupClass;
    }

    public BasicWebUser getUser(int id) {
        return (BasicWebUser)this.store.get(this.userClass, id);
    }

    public BasicUserGroup getUserGroup(int id) {
        BasicUserGroup group;
        if (id > 0) {
            group = (BasicUserGroup)this.store().get(this.groupClass, id);
        } else {
            group = (BasicUserGroup)this.security.constructUserGroup();
            group.setType(2);
        }
        return group;
    }

    @Override
    public boolean mustache(String template, Object object) {
        return super.mustache(String.valueOf(this.getTemplatePath()) + template, object);
    }

    protected boolean handleMenu(Context context) {
        this.delivery().putObject(TEMPLATE_MENU, this.categoryMenus.values());
        return this.mustache(TEMPLATE_MENU);
    }

    protected void addSeverityDelivery(int severity) {
        this.delivery().put("severity", String.valueOf(severity));
        if (severity < 5) {
            this.delivery().put("low-severity", true);
        } else if (severity > 5) {
            this.delivery().put("high-severity", true);
        } else {
            this.delivery().put("medium-severity", true);
        }
    }

    public boolean handleInformation(Context context, int severity, String message) {
        this.addSeverityDelivery(severity);
        this.delivery().put("message", message);
        return this.mustache(TEMPLATE_INFORMATION);
    }

    public boolean handleConfirmation(Context context, int severity, String message, String confirmUri) {
        this.addSeverityDelivery(severity);
        boolean questionMark = confirmUri.indexOf(63) >= 0;
        String fullConfirmUri = String.valueOf(confirmUri) + (questionMark ? (char)'&' : '?') + BasicAdminHandler.getNonce(context);
        this.delivery().put("message", message).put("confirm", fullConfirmUri);
        return this.mustache(TEMPLATE_CONFIRMATION);
    }

    protected static void setupAdminSession(Context context) {
        String nonce = context.session().get(SESSION_ADMIN_NONCE);
        if (nonce == null) {
            nonce = StringHelper.getRandomAlphaNumeric(10);
            context.session().put(SESSION_ADMIN_NONCE, nonce);
        }
    }

    public static boolean isNonceCorrect(Context context) {
        String sessionNonce = context.session().get(SESSION_ADMIN_NONCE);
        String requestNonce = context.query().get(REQUEST_ADMIN_NONCE);
        return sessionNonce != null && requestNonce != null && sessionNonce.equals(requestNonce);
    }

    public static String getNonce(Context context) {
        String sessionNonce = context.session().get(SESSION_ADMIN_NONCE);
        if (sessionNonce != null) {
            return "arc=" + sessionNonce;
        }
        return "";
    }

    public static class AdminCategoryMenu
    implements Comparable<AdminCategoryMenu> {
        private AdminFunctionCategory category;
        private List<AdminFunction> functions = new ArrayList<AdminFunction>(2);

        public AdminCategoryMenu(AdminFunctionCategory category) {
            this.category = category;
        }

        public void addFunction(AdminFunction function) {
            this.functions.add(function);
        }

        public String getName() {
            return this.category.getName();
        }

        public String getDescription() {
            return this.category.getDescription();
        }

        public Iterator<AdminFunction> getFunctions() {
            return this.functions.iterator();
        }

        public int size() {
            return this.functions.size();
        }

        @Override
        public int compareTo(AdminCategoryMenu arg) {
            return StringHelper.compareToIgnoreCase(this.getName(), arg.getName());
        }
    }
}

