/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.log.ComponentLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectiveAdminFunction
extends BasicAdminFunction {
    private static final Class<?>[] METHOD_SIG = new Class[]{BasicDispatcher.class, Context.class, BasicAdminHandler.class, GeminiApplication.class, ComponentLog.class};
    private final Object object;
    private final Method method;
    private final String methodName;

    public ReflectiveAdminFunction(String commandSuffix, String name, String description, String category, boolean displayOnMenu, Object object, String methodName) {
        super(commandSuffix, name, description, category, displayOnMenu, false);
        this.object = object;
        this.methodName = methodName;
        try {
            this.method = object.getClass().getMethod(methodName, METHOD_SIG);
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalArgumentException("Could not find method " + methodName + " with correct signature.", exc);
        }
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        if (this.method != null) {
            try {
                Object[] params = new Object[]{context, bah, app, log};
                return (Boolean)this.method.invoke(this.object, params);
            }
            catch (IllegalAccessException | InvocationTargetException exc) {
                log.log("Cannot call " + this.methodName + ": ", exc);
            }
        } else {
            log.log("Cannot find " + this.methodName + ".");
        }
        return false;
    }
}

