/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.logmonitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.AdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.logmonitor.LogMonitorChannel;
import com.techempower.gemini.admin.logmonitor.LogMonitorItem;
import com.techempower.gemini.websocket.BasicWebsocketProcessor;
import com.techempower.gemini.websocket.WebsocketAdapter;
import com.techempower.js.JavaScriptWriter;
import com.techempower.js.Visitors;
import com.techempower.log.AbstractLogListener;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;

public class LogMonitor
extends AbstractLogListener
implements AdminFunction {
    public static final int CAPTURE_BUFFER_SIZE = 120;
    private final GeminiApplication app;
    private final JavaScriptWriter jsw;
    private final List<LogMonitorChannel> channelList = new ArrayList<LogMonitorChannel>();
    private final WebsocketAdapter adapter;
    private final Executor executor;
    private final List<Processor> processors;
    private LogMonitorChannel[] channels = new LogMonitorChannel[0];
    private final Runnable notifier = new Runnable(){

        @Override
        public void run() {
            for (Processor processor : LogMonitor.this.processors) {
                processor.update();
            }
        }
    };

    public LogMonitor(GeminiApplication app, WebsocketAdapter adapter) {
        super(app);
        this.app = app;
        this.jsw = JavaScriptWriter.custom().addVisitorFactory(LogMonitorItem.class, Visitors.forClass(LogMonitorItem.class, "level", "getLevel", "text", "getText")).addVisitorFactory(LogMonitorChannel.Updates.class, Visitors.forClass(LogMonitorChannel.Updates.class, "uid", "getUid", "items", "getItems")).addVisitorFactory(LogMonitorChannel.class, Visitors.forClass(LogMonitorChannel.class, "min", "getMin", "max", "getMax", "name", "getName", "contains", "getContains", "regex", "getRegex", "size", "getSize", "last", "getLastCapture", "count", "getUid")).build();
        this.adapter = adapter;
        this.executor = Executors.newSingleThreadExecutor();
        this.processors = new CopyOnWriteArrayList<Processor>();
    }

    @Override
    public void configure(EnhancedProperties props, BasicAdminHandler<?> bah) {
        this.app.getApplicationLog().addListener(this);
    }

    public String getOptionalFunctionName() {
        return "Log monitoring using AJAX and Resin 4 WebSockets";
    }

    @Override
    public String getPathSegment() {
        return "log-monitor";
    }

    @Override
    public String getRelativeUri() {
        return "/" + this.getFunctionCategory() + "/" + this.getPathSegment();
    }

    @Override
    public String getFunctionName() {
        return "Log Monitor";
    }

    @Override
    public String getFunctionDescription() {
        return "Real-time log display";
    }

    @Override
    public String getFunctionCategory() {
        return "monitor";
    }

    @Override
    public boolean displayOnMenu() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication unused, ComponentLog log) {
        int channelID = context.query().getInt("ch", 0, 0, this.channels.length - 1);
        LogMonitorChannel channel = this.channels[channelID];
        context.delivery().put("ChannelID", channelID);
        String action = context.query().get("act");
        if ("ajax".equalsIgnoreCase(action)) {
            int sinceUID = context.query().getInt("since");
            LogMonitorChannel.Updates updates = channel.getUpdatesSince(sinceUID);
            return GeminiHelper.sendJson(context, updates, this.jsw);
        }
        if ("ws".equalsIgnoreCase(action)) {
            if (this.adapter != null) {
                try {
                    Processor proc = this.addProcessor(channel);
                    this.adapter.promoteToWebsocket(proc, context.getRequest().getRawRequest());
                    log.log("LogMonitor WebSocket started.");
                }
                catch (UnsupportedOperationException | ServletException exc) {
                    log.log("Cannot promote LogMonitor request to WebSocket.", exc);
                }
            } else {
                context.sendError(403);
            }
        } else {
            if ("view".equalsIgnoreCase(action)) {
                context.delivery().put("Channels", this.jsw.write(this.channels));
                return bah.mustache(String.valueOf(this.getFunctionCategory()) + "-" + this.getPathSegment());
            }
            context.delivery().put("Channels", this.jsw.write(this.channels));
            return bah.mustache(String.valueOf(this.getFunctionCategory()) + "-" + this.getPathSegment() + "-list");
        }
        return true;
    }

    public void addChannel(LogMonitorChannel channel) {
        this.channelList.add(channel);
        this.channels = this.channelList.toArray(this.channels);
    }

    @Override
    public String getName() {
        return "WebSocket/AJAX Log";
    }

    @Override
    public void log(String componentCode, String debugString, int debugLevel) {
        if (debugString.indexOf("log-monitor") < 0) {
            this.capture(componentCode, debugString, debugLevel);
        }
    }

    protected void capture(String componentCode, String debugString, int debugLevel) {
        this.computeTimestamps();
        StringBuilder buffer = new StringBuilder(120);
        buffer.append(this.getApplication().getVersion().getProductCode());
        buffer.append(' ');
        buffer.append(this.getBriefTimestamp());
        buffer.append(' ');
        buffer.append(componentCode);
        buffer.append(": ");
        buffer.append(debugString);
        LogMonitorItem li = new LogMonitorItem(debugLevel, buffer.toString());
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i].capture(li);
            ++i;
        }
        this.executor.execute(this.notifier);
    }

    public String toString() {
        return "OAF [" + this.getPathSegment() + "]";
    }

    protected Processor addProcessor(LogMonitorChannel channel) {
        Processor proc = new Processor(channel);
        this.processors.add(proc);
        return proc;
    }

    protected void removeProcessor(Processor processor) {
        this.processors.remove(processor);
    }

    class Processor
    extends BasicWebsocketProcessor {
        final LogMonitorChannel channel;
        int lastUid;

        public Processor(LogMonitorChannel channel) {
            super(LogMonitor.this.app, LogMonitor.this.jsw);
            this.lastUid = 0;
            this.channel = channel;
        }

        @Override
        public void startup() {
            super.startup();
            this.update();
        }

        @Override
        public void teardown() {
            super.teardown();
            LogMonitor.this.removeProcessor(this);
        }

        public void update() {
            LogMonitorChannel.Updates updates = this.channel.getUpdatesSince(this.lastUid);
            this.lastUid = updates.getUid();
            this.sendJson("updates", updates.getItems());
        }
    }
}

