/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.logmonitor;

import com.techempower.gemini.admin.logmonitor.LogMonitorItem;
import com.techempower.helper.StringHelper;
import java.util.regex.Pattern;

public class LogMonitorChannel {
    public static final int DEFAULT_BUFFER_SIZE = 1000;
    private int end = 0;
    private int uid = 0;
    private int min = 0;
    private int max = 0;
    private String name;
    private String contains;
    private String regex;
    private Pattern pattern;
    private boolean enabled = true;
    private LogMonitorItem[] buffer;
    private long lastCapture = 0L;

    public LogMonitorChannel(String name, int size, int minLevel, int maxLevel, String contains, String regex) {
        this.buffer = new LogMonitorItem[size];
        this.name = name;
        this.setMin(minLevel);
        this.setMax(maxLevel);
        this.setContains(contains);
        this.setRegex(regex);
    }

    public LogMonitorChannel(String name, int minLevel, int maxLevel, String contains) {
        this(name, 1000, minLevel, maxLevel, contains, null);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public long getLastCapture() {
        return this.lastCapture;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public String getContains() {
        return this.contains;
    }

    public void setContains(String contains) {
        this.contains = contains;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        if (StringHelper.isNonEmpty(regex)) {
            this.pattern = Pattern.compile(regex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capture(LogMonitorItem item) {
        if (this.enabled && item.getLevel() >= this.min && item.getLevel() <= this.max && (StringHelper.isEmpty(this.contains) || item.getText().contains(this.contains)) && (StringHelper.isEmpty(this.regex) || this.pattern.matcher(item.getText()).matches())) {
            LogMonitorChannel logMonitorChannel = this;
            synchronized (logMonitorChannel) {
                this.buffer[this.end] = item;
                ++this.end;
                if (this.end >= this.buffer.length) {
                    this.end = 0;
                }
                ++this.uid;
            }
            this.lastCapture = System.currentTimeMillis();
        }
    }

    public synchronized Updates getUpdatesSince(int sinceUID) {
        return new Updates(this.getUid(), this.getItemsSince(sinceUID));
    }

    public synchronized int getUid() {
        return this.uid;
    }

    protected synchronized LogMonitorItem[] getItemsSince(int sinceUID) {
        int size = this.uid - sinceUID;
        if (size > this.buffer.length) {
            size = this.buffer.length;
        } else if (size < 0) {
            size = 0;
        }
        LogMonitorItem[] toReturn = new LogMonitorItem[size];
        int index = this.end - size;
        if (index < 0) {
            index = this.buffer.length + index;
        }
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = this.buffer[index];
            if (++index >= this.buffer.length) {
                index = 0;
            }
            ++i;
        }
        return toReturn;
    }

    public static class Updates {
        private final int uid;
        private final LogMonitorItem[] items;

        public Updates(int uid, LogMonitorItem[] items) {
            this.uid = uid;
            this.items = items;
        }

        public int getUid() {
            return this.uid;
        }

        public LogMonitorItem[] getItems() {
            return this.items;
        }
    }
}

