/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.notification;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.notification.BasicNotification;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.gemini.admin.notification.NotificationListener;
import com.techempower.gemini.admin.notification.NotificationSort;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Notifier
implements Configurable,
Asynchronous {
    public static final String COMPONENT_CODE = "Ntfr";
    public static final String CONFIGURATION_PREFIX = "Notifier.";
    public static final int DEFAULT_HISTORY_SIZE = 50;
    public static final int DEFAULT_HISTORY_DETAIL_SIZE = 50;
    public static final int DEFAULT_HISTORY_PROCESS_INTERVAL = 600;
    public static final int DEFAULT_LIST_SIZE = 10;
    private final GeminiApplication app;
    private final ComponentLog log;
    private final NotifierThread thread;
    private NotificationListener[] listeners;
    private int historySize = 50;
    private int historyDetails = 50;
    private int historyProcessInterval = 600;
    private int lastHistoryProcess = 0;
    private final AtomicInteger sequencer = new AtomicInteger(0);
    private final List<Notification> inbound = new ArrayList<Notification>(10);
    private final List<Notification> history = new ArrayList<Notification>(this.historySize);

    public Notifier(GeminiApplication app) {
        this.app = app;
        this.log = app.getLog(COMPONENT_CODE);
        this.listeners = new NotificationListener[0];
        this.thread = new NotifierThread();
        app.getConfigurator().addConfigurable(this);
        app.addAsynchronous(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(Notification notification) {
        List<Notification> list = this.inbound;
        synchronized (list) {
            this.inbound.add(notification);
        }
    }

    public void addNotification(String source, String synopsis, String details, Notification.Severity severity) {
        BasicNotification not = new BasicNotification(source, synopsis, details, severity);
        this.addNotification(not);
    }

    public void addNotification(String source, String synopsis, String details) {
        BasicNotification not = new BasicNotification(source, synopsis, details);
        this.addNotification(not);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Notification> consumeInbound() {
        ArrayList<Notification> toReturn = new ArrayList<Notification>(this.inbound.size() + 1);
        List<Notification> list = this.inbound;
        synchronized (list) {
            toReturn.addAll(this.inbound);
            this.inbound.clear();
        }
        return toReturn;
    }

    protected void processQueue() {
        if (this.inbound.size() > 0) {
            List<Notification> toProcess = this.consumeInbound();
            for (Notification notification : toProcess) {
                notification.setSequenceNumber(this.sequencer.incrementAndGet());
                this.distribute(notification);
                if (this.history.size() > this.historySize) {
                    this.history.remove(0);
                }
                this.history.add(notification);
                if (this.historyDetails >= this.historySize) continue;
                int pos = this.historySize - this.historyDetails;
                this.history.get(pos).purgeDetails();
            }
        }
    }

    protected void processHistory() {
        int lastSequence = this.sequencer.get();
        if (lastSequence > this.lastHistoryProcess) {
            List<Notification> hist = this.getHistory();
            ArrayList<Notification> sinceLast = new ArrayList<Notification>(lastSequence - this.lastHistoryProcess);
            for (Notification n : hist) {
                if (n.getSequenceNumber() <= this.lastHistoryProcess) continue;
                sinceLast.add(n);
            }
            int i = 0;
            while (i < this.listeners.length) {
                try {
                    this.listeners[i].processHistory(hist, sinceLast, this);
                }
                catch (Exception exc) {
                    this.log.log("Exception while processing history: " + exc);
                }
                ++i;
            }
            this.lastHistoryProcess = lastSequence;
        }
    }

    protected void distribute(Notification notification) {
        int i = 0;
        while (i < this.listeners.length) {
            try {
                this.listeners[i].processNotification(notification, this);
            }
            catch (Exception exc) {
                this.log.log("Exception while distributing " + notification + ": " + exc);
            }
            ++i;
        }
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public List<Notification> getHistory() {
        ArrayList<Notification> toReturn = new ArrayList<Notification>(this.history);
        Collections.sort(toReturn, NotificationSort.DATE_DESC);
        return toReturn;
    }

    public Notification getHistory(int index) {
        try {
            return this.history.get(index);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            return null;
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus(CONFIGURATION_PREFIX);
        this.historySize = focus.getIntegerProperty("History", 50);
        this.historyDetails = focus.getIntegerProperty("HistoryDetails", 50);
        this.historyProcessInterval = focus.getIntegerProperty("HistoryProcessIntervalSeconds", 600);
    }

    public void addListener(NotificationListener listener) {
        NotificationListener[] temp = new NotificationListener[this.listeners.length + 1];
        System.arraycopy(this.listeners, 0, temp, 0, this.listeners.length);
        temp[temp.length - 1] = listener;
        this.listeners = temp;
    }

    @Override
    public void begin() {
        this.thread.begin();
    }

    @Override
    public void end() {
        this.thread.end();
    }

    class NotifierThread
    extends EndableThread {
        public static final int SLEEP_PERIOD = 5000;

        public NotifierThread() {
            super("Gemini Notifier Thread (" + Notifier.this.app.getVersion().getAbbreviatedProductName() + ")", 5000);
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long intervalMs = (long)Notifier.this.historyProcessInterval * 1000L;
            long nextProcess = now + intervalMs;
            while (this.checkPause()) {
                now = System.currentTimeMillis();
                if (now >= nextProcess) {
                    try {
                        Notifier.this.processHistory();
                    }
                    catch (Exception exc) {
                        Notifier.this.log.log("Exception while processing notification history: ", exc);
                    }
                    nextProcess = now + intervalMs;
                }
                try {
                    Notifier.this.processQueue();
                }
                catch (Exception exc) {
                    Notifier.this.log.log("Exception while processing inbound notification queue: ", exc);
                }
                this.simpleSleep();
            }
        }
    }
}

