/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.notification.listener;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.gemini.admin.notification.NotificationListener;
import com.techempower.gemini.admin.notification.NotificationSort;
import com.techempower.gemini.admin.notification.Notifier;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class EmailNotificationListener
implements NotificationListener,
Configurable {
    public static final String COMPONENT_CODE = "emNL";
    public static final String PROPERTY_PREFIX = "EmailNotificationListener.";
    public static final int MAXIMUM_SYNOPSIS_LENGTH = 40;
    public static final String DEFAULT_FROM_ADDRESS = "exceptions@techempower.com";
    private static final String[] TEXT_FINDS = new String[]{"\n", "\t", "\r"};
    private static final String[] TEXT_REPLACES = new String[]{" ", " ", " "};
    private final GeminiApplication application;
    private final ComponentLog log;
    private final SimpleDateFormat format = new SimpleDateFormat("MM-dd HH:mm:ss");
    private String fromMailAddress = "exceptions@techempower.com";
    private List<Recipient> recipients = new ArrayList<Recipient>();

    public EmailNotificationListener(GeminiApplication application) {
        this.application = application;
        this.log = this.application.getLog(COMPONENT_CODE);
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void processNotification(Notification notification, Notifier notifier) {
        if (notification.getSeverity() == Notification.Severity.HIGH) {
            ArrayList<Notification> list = new ArrayList<Notification>(1);
            list.add(notification);
            this.sendNotifications(list);
        }
    }

    @Override
    public void processHistory(List<Notification> history, List<Notification> sinceLastInterval, Notifier notifier) {
        if (sinceLastInterval.size() > 0) {
            ArrayList<Notification> lowmed = new ArrayList<Notification>(sinceLastInterval.size());
            Iterator<Notification> iter = sinceLastInterval.iterator();
            Notification n = null;
            while (iter.hasNext()) {
                n = iter.next();
                if (n.getSeverity() == Notification.Severity.HIGH) continue;
                lowmed.add(n);
            }
            if (lowmed.size() > 0) {
                this.sendNotifications(lowmed);
            }
        }
    }

    public String truncateSynopsis(String synopsis, int length) {
        String truncated = StringHelper.truncateEllipsis(synopsis, length);
        return StringHelper.replaceSubstrings(truncated, TEXT_FINDS, TEXT_REPLACES);
    }

    public void sendNotifications(List<Notification> notes) {
        Collections.sort(notes, NotificationSort.SEVERITY_DESC);
        for (Recipient recipient : this.recipients) {
            StringBuilder body = new StringBuilder();
            int matched = 0;
            Notification highest = null;
            for (Notification n : notes) {
                if (n.getSeverity().ordinal() < recipient.minSeverity.ordinal() || recipient.sources != null && recipient.sources.length != 0 && !CollectionHelper.arrayContains(recipient.sources, n.getSource().toLowerCase())) continue;
                ++matched;
                body.append("\r\n======================================================================\r\n");
                body.append(String.valueOf(this.format.format(n.getTime())) + " - " + n.getSource() + " - " + (Object)((Object)n.getSeverity()) + " severity" + "\r\n");
                body.append("----------------------------------------------------------------------\r\n");
                body.append(n.getDetails());
                body.append("\r\n");
                if (highest != null && highest.getSeverity().ordinal() >= n.getSeverity().ordinal()) continue;
                highest = n;
            }
            if (matched <= 0) continue;
            StringBuilder subject = new StringBuilder();
            subject.append("<auto>");
            subject.append("<" + StringHelper.truncate(this.application.getVersion().getProductName(), 10).toLowerCase() + ">");
            if (matched == 1) {
                subject.append("<" + StringHelper.truncate(highest.getSource().toLowerCase(), 3) + ">");
            }
            subject.append(" " + this.truncateSynopsis(highest.getSynopsis(), 40));
            if (matched > 1) {
                subject.append(" (and " + (matched - 1) + " more)");
            }
            long uptime = this.application.getUptime();
            body.insert(0, String.valueOf(this.application.getVersion().getNameAndDeployment()) + " - " + matched + " new notification" + StringHelper.pluralize(matched) + "\r\n" + DateHelper.getHumanDuration(uptime, 2) + " uptime (" + uptime + " ms)" + "\r\n");
            EmailPackage email = new EmailPackage(subject.toString(), body.toString(), recipient.email, this.fromMailAddress);
            this.application.getEmailServicer().sendMail(email);
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        ArrayList<Recipient> newRecipients = new ArrayList<Recipient>();
        String recipientPrefix = "EmailNotificationListener.Recipient";
        int index = 1;
        while (props.getProperty("EmailNotificationListener.Recipient" + index + ".Email") != null) {
            Recipient recipient = new Recipient(props, "EmailNotificationListener.Recipient" + index + ".");
            newRecipients.add(recipient);
            this.log.log(String.valueOf(index) + ": " + recipient);
            ++index;
        }
        this.recipients = newRecipients;
        this.fromMailAddress = props.getProperty("EmailNotificationListener.FromAddress", DEFAULT_FROM_ADDRESS);
        if (StringHelper.isEmpty(this.fromMailAddress) || this.recipients.size() == 0) {
            this.log.log("EmailNotificationListener disabled (both To and From email addresses must be provided in configuration).");
        }
    }

    static class Recipient {
        private final String email;
        private final String[] sources;
        private final Notification.Severity minSeverity;

        public Recipient(EnhancedProperties props, String prefix) {
            this.email = props.getProperty(String.valueOf(prefix) + "Email");
            this.sources = props.getArrayProperty(String.valueOf(prefix) + "Sources");
            int i = 0;
            while (i < this.sources.length) {
                this.sources[i] = this.sources[i].toLowerCase();
                ++i;
            }
            this.minSeverity = props.getEnumProperty(String.valueOf(prefix) + "MinSeverity", Notification.Severity.class, Notification.Severity.LOW);
        }

        public String toString() {
            return "Recipient [" + this.email + "; " + CollectionHelper.toString(this.sources, ",") + "; " + this.minSeverity.ordinal() + "]";
        }
    }
}

