/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.data.EntityGroup;
import com.techempower.gemini.admin.AdminFunction;
import com.techempower.gemini.admin.AdminFunctionCategory;
import com.techempower.gemini.admin.standard.cache.CacheList;
import com.techempower.gemini.admin.standard.cache.CacheReset;
import com.techempower.gemini.admin.standard.cache.ObjectCall;
import com.techempower.gemini.admin.standard.cache.ObjectList;
import com.techempower.gemini.admin.standard.cache.ObjectUpdate;
import com.techempower.gemini.admin.standard.cache.ObjectView;
import com.techempower.gemini.admin.standard.cache.RelationList;
import com.techempower.gemini.admin.standard.cache.RelationRemove;
import com.techempower.gemini.admin.standard.cache.RelationReset;
import com.techempower.gemini.admin.standard.cache.RelationView;
import com.techempower.helper.StringHelper;
import com.techempower.util.Identifiable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CacheCategory
extends AdminFunctionCategory {
    public static final int MAXIMUM_VALUE_LENGTH = 150;
    public static final int PAGE_SIZE = 50;
    public static final Comparator<EntityGroup<?>> SORT_ENTITY_GROUP_BY_NAME = new Comparator<EntityGroup<?>>(){

        @Override
        public int compare(EntityGroup<?> o1, EntityGroup<?> o2) {
            return o1.getType().getName().compareTo(o2.getType().getName());
        }
    };
    protected static final Class<?>[] NO_PARAMS = new Class[0];
    protected static final Object[] NO_VALUES = new Object[0];

    public CacheCategory() {
        super("cache", "Cache Management");
    }

    @Override
    public AdminFunction[] getStandardFunctions() {
        return new AdminFunction[]{new CacheList(), new CacheReset(), new ObjectCall(), new ObjectList(), new ObjectUpdate(), new ObjectView(), new RelationList(), new RelationRemove(), new RelationReset(), new RelationView()};
    }

    protected static Class<? extends Identifiable> getCacheClass(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    protected static List<String> decomposeObjectGetMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        ArrayList<String> list = new ArrayList<String>(methods.length);
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int i = 0;
        while (i < methods.length) {
            if ((methods[i].getName().startsWith("get") || methods[i].getName().matches("^[i][s][A-Z].*") && (methods[i].getReturnType() == Boolean.TYPE || methods[i].getReturnType() == Boolean.class)) && !Modifier.isStatic(methods[i].getModifiers()) && methods[i].getParameterTypes().length == 0) {
                list.add(methods[i].getName());
            }
            ++i;
        }
        return list;
    }

    protected static Map<String, String> decomposeObjectMethodValues(Object obj, List<String> methodNames) {
        HashMap<String, String> map = new HashMap<String, String>(methodNames.size());
        int i = 0;
        while (i < methodNames.size()) {
            String value;
            String name = methodNames.get(i);
            try {
                Method method = obj.getClass().getMethod(name, NO_PARAMS);
                value = StringHelper.truncateEllipsis("" + method.invoke(obj, NO_VALUES), 150);
            }
            catch (Exception exc) {
                value = "";
            }
            map.put(name, value);
            ++i;
        }
        return map;
    }

    protected static Map<String, String> decomposeObjectFields(Object obj) {
        Field[] fields = obj.getClass().getFields();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(fields.length);
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        String value = "";
        int i = 0;
        while (i < fields.length) {
            if (!Modifier.isStatic(fields[i].getModifiers())) {
                try {
                    value = StringHelper.truncateEllipsis("" + fields[i].get(obj), 150);
                }
                catch (IllegalAccessException iaexc) {
                    value = "";
                }
                map.put(fields[i].getName(), value);
            }
            ++i;
        }
        return map;
    }
}

