/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.data.EntityException;
import com.techempower.data.EntityGroup;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.cache.CacheCategory;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Identifiable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CacheList
extends BasicAdminFunction {
    public CacheList() {
        super("list", "List Caches", "List and reset the object caches", "cache", true, true);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        List<EntityGroup<? extends Identifiable>> groups = app.getStore().getGroupList();
        Collections.sort(groups, CacheCategory.SORT_ENTITY_GROUP_BY_NAME);
        ArrayList rendered = new ArrayList();
        for (EntityGroup<? extends Identifiable> group : groups) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", group.getType().getCanonicalName());
            try {
                map.put("size", String.valueOf(group.size()) + " object" + StringHelper.pluralize(group.size()));
            }
            catch (EntityException eexc) {
                map.put("size", "Unknown size");
            }
            rendered.add(map);
        }
        context.delivery().putObject("list", rendered);
        return bah.mustache(this.getTemplateName());
    }
}

