/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.data.EntityRelation;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.cache.CacheCategory;
import com.techempower.js.JavaScriptWriter;
import com.techempower.log.ComponentLog;
import com.techempower.util.Identifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ObjectView
extends BasicAdminFunction {
    public ObjectView() {
        super("object-view", "List Objects", "List of cached objects", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        return this.go(context, bah, app, log);
    }

    protected <T extends Identifiable> boolean go(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Class<? extends Identifiable> clazz = CacheCategory.getCacheClass(context.query().get("cid"));
        JavaScriptWriter jsW = JavaScriptWriter.standard();
        if (clazz != null) {
            Identifiable obj = null;
            int id = context.query().getInt("id");
            if (id >= 0 && (obj = app.getStore().get(clazz, id)) != null) {
                Map<String, String> fields = CacheCategory.decomposeObjectFields(obj);
                List<String> methods = CacheCategory.decomposeObjectGetMethods(obj.getClass());
                context.delivery().putObject("fields", fields).putObject("methods", methods).putObject("object", obj).put("className", clazz.getName()).put("objectId", id).put("methodsJson", jsW.write(methods)).put("fieldsJson", jsW.write(fields));
                ArrayList<RelationView> relations = new ArrayList<RelationView>();
                for (EntityRelation<?, ?> relation : app.getStore().getRelations()) {
                    if (relation.rightType().equals(clazz)) {
                        relations.add(new RelationView(relation.tableName(), relation.leftSize(id), 0));
                    }
                    if (!relation.leftType().equals(clazz)) continue;
                    relations.add(new RelationView(relation.tableName(), 0, relation.rightSize(id)));
                }
                context.delivery().putObject("relations", relations);
                return bah.mustache(this.getTemplateName());
            }
        }
        return false;
    }

    public static class RelationView {
        public String tableName;
        public int leftSize;
        public int rightSize;

        public RelationView(String tableName, int leftSize, int rightSize) {
            this.tableName = tableName;
            this.leftSize = leftSize;
            this.rightSize = rightSize;
        }
    }
}

