/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.data.EntityRelation;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.BasicAdminPaging;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class RelationList
extends BasicAdminFunction {
    public static final RelationTableComparator COMPARATOR = new RelationTableComparator();

    public RelationList() {
        super("relation-list", "List Relations", "List and reset the cached relations", "cache");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        int currentPage = context.query().getInt("p", 1, 1, 1000);
        ArrayList relations = new ArrayList();
        for (EntityRelation<?, ?> relation : app.getStore().getRelations()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("relation", relation);
            row.put("name", relation.getClass().getName());
            relations.add(row);
        }
        Collections.sort(relations, COMPARATOR);
        BasicAdminPaging paging = new BasicAdminPaging(context, this.getPathSegment(), relations.size(), currentPage, 50);
        context.delivery().putObject("relations", paging.extractCurrentPage(relations)).putObject("paging", paging.render());
        return bah.mustache(this.getTemplateName());
    }

    static final class RelationTableComparator
    implements Comparator<Map<String, Object>> {
        RelationTableComparator() {
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            return ((String)o1.get("name")).compareTo((String)o2.get("name"));
        }
    }
}

