/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.cache.CachedRelation;
import com.techempower.data.EntityRelation;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.log.ComponentLog;

public class RelationReset
extends BasicAdminFunction {
    public RelationReset() {
        super("relation-reset", "Reset Relation", "Reset cached relation", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        EntityRelation<?, ?> relation = app.getStore().getRelation(context.query().get("relation"));
        if (!(relation instanceof CachedRelation)) {
            context.messages().warning(String.valueOf(relation.tableName()) + " is not a cached relation, so it cannot be reset.");
            return bah.redirectRelative(bah.getFunction("cache-relation-list").getRelativeUri());
        }
        if (BasicAdminHandler.isNonceCorrect(context)) {
            ((CachedRelation)relation).reset(true);
            context.messages().normal(String.valueOf(relation.tableName()) + " relation reset.");
            return bah.redirectRelative(bah.getFunction("cache-relation-list").getRelativeUri());
        }
        return bah.handleConfirmation(context, 10, String.valueOf(relation.tableName()) + " relation reset", String.valueOf(this.getPathSegment()) + "?relation=" + relation.tableName());
    }
}

