/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.cache;

import com.techempower.cache.CachedRelation;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.IntegerRelationIterator;
import com.techempower.collection.relation.ManyToManyIntegerRelation;
import com.techempower.collection.relation.ManyToOneIntegerRelation;
import com.techempower.collection.relation.OneToManyIntegerRelation;
import com.techempower.collection.relation.OneToOneIntegerRelation;
import com.techempower.data.EntityRelation;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.BasicAdminPaging;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RelationView
extends BasicAdminFunction {
    public static final int MAXIMUM_NAME_LENGTH = 50;

    public RelationView() {
        super("relation-view", "View Relation", "View a cached relation", "cache", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        EntityRelation<?, ?> relation = app.getStore().getRelation(context.query().get("relation"));
        if (relation == null) {
            return bah.handleInformation(context, 5, "The specified Relation cannot be found.");
        }
        IntegerRelation coreRelation = relation.relation();
        ArrayList pairs = new ArrayList();
        IntegerRelationIterator iterator = coreRelation.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            Object left = app.getStore().get(relation.leftType(), iterator.left());
            Object right = app.getStore().get(relation.rightType(), iterator.right());
            if (left == null || right == null) continue;
            HashMap pair = new HashMap();
            HashMap<String, Object> leftMap = new HashMap<String, Object>();
            HashMap<String, Object> rightMap = new HashMap<String, Object>();
            leftMap.put("id", left.getId());
            rightMap.put("id", right.getId());
            leftMap.put("class", left.getClass().getName());
            rightMap.put("class", right.getClass().getName());
            leftMap.put("name", StringHelper.truncateEllipsis(left.toString(), 50));
            rightMap.put("name", StringHelper.truncateEllipsis(right.toString(), 50));
            pair.put("left", leftMap);
            pair.put("right", rightMap);
            pairs.add(pair);
        }
        int currentPage = Math.max(1, context.query().getInt("p"));
        BasicAdminPaging paging = new BasicAdminPaging(context, "?relation=" + relation.tableName(), pairs.size(), currentPage, 50);
        String relationType = "Unknown";
        if (relation instanceof CachedRelation) {
            if (coreRelation instanceof ManyToManyIntegerRelation) {
                relationType = "Many-to-many";
            } else if (coreRelation instanceof ManyToOneIntegerRelation) {
                relationType = "Many-to-one";
            } else if (coreRelation instanceof OneToManyIntegerRelation) {
                relationType = "One-to-many";
            } else if (coreRelation instanceof OneToOneIntegerRelation) {
                relationType = "One-to-one";
            }
        }
        List<Object> relationListeners = relation instanceof CachedRelation ? ((CachedRelation)relation).listeners() : Collections.emptyList();
        context.delivery().putObject("relation", relation).putObject("pairs", paging.extractCurrentPage(pairs)).putObject("paging", paging).putObject("relationListeners", relationListeners).put("relationType", relationType);
        return bah.mustache(this.getTemplateName());
    }
}

