/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.config;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.configuration.ConfigurationError;
import com.techempower.helper.ThrowableHelper;
import com.techempower.log.ComponentLog;

public class Reconfigure
extends BasicAdminFunction {
    public Reconfigure() {
        super("reconfigure", "Reconfigure", "Re-process the application's configuration", "config");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        if (BasicAdminHandler.isNonceCorrect(context)) {
            try {
                app.getConfigurator().configure();
                context.messages().success("Configuration file re-read.");
                return bah.redirectRelative(bah.getFunction("config-config-view").getRelativeUri());
            }
            catch (ConfigurationError ce) {
                context.delivery().put("Supplemental", ThrowableHelper.convertStackTraceToString(ce));
                return bah.handleInformation(context, 10, "Reconfiguration failed.");
            }
        }
        return bah.handleConfirmation(context, 10, "Reconfigure", this.getPathSegment());
    }
}

