/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.email;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.AdminFunction;
import com.techempower.gemini.admin.AdminFunctionCategory;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.email.EmailPause;
import com.techempower.gemini.admin.standard.email.EmailQueues;
import com.techempower.gemini.admin.standard.email.InboundEmailImmediate;
import com.techempower.gemini.admin.standard.email.InboundEmailPause;
import com.techempower.gemini.email.EmailHandler;
import java.util.ArrayList;

public class EmailCategory
extends AdminFunctionCategory {
    public EmailCategory() {
        super("email", "E-Mail Management");
    }

    @Override
    public AdminFunction[] getStandardFunctions() {
        return new AdminFunction[]{new EmailQueues(), new EmailPause(), new InboundEmailPause(), new InboundEmailImmediate()};
    }

    protected static boolean handleNoEmailServicer(BasicAdminHandler<?> bah, Context context) {
        return bah.handleInformation(context, 0, "This application does not have an EmailServicer so this functionality is not available.");
    }

    protected static void sendStandardDeliveries(GeminiApplication app, Context context) {
        context.delivery().putObject("servicer", app.getEmailServicer()).putObject("transport", app.getEmailTransport()).put("servicer_peakPlural", app.getEmailServicer().getPeakSenderThreadCount() != 1);
        if (app.getEmailDispatcher() != null) {
            context.delivery().putObject("dispatcher", app.getEmailDispatcher()).put("dispatcher_totalPlural", app.getEmailDispatcher().getTotalProcessed() != 1);
            ArrayList<EmailHandlerView> handlers = new ArrayList<EmailHandlerView>();
            int i = 1;
            for (EmailHandler handler : app.getEmailDispatcher().getHandlers()) {
                handlers.add(new EmailHandlerView(i++, handler));
            }
            context.delivery().putObject("dispatcher_handlers", handlers);
        }
    }

    static class EmailHandlerView {
        public String name;
        public int id;

        public EmailHandlerView(int id, EmailHandler handler) {
            this.id = id;
            this.name = handler.toString();
        }
    }
}

