/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.cluster.message.AdminRequest;
import com.techempower.gemini.cluster.message.AdminResponse;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitorSample;
import com.techempower.helper.DateHelper;
import com.techempower.helper.ThreadHelper;
import com.techempower.js.JavaScriptWriter;
import com.techempower.log.ComponentLog;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

public class Dashboard
extends BasicAdminFunction {
    public static final int DEFAULT_MAP_SIZE = 50;
    public static final JavaScriptWriter JSW = JavaScriptWriter.standard();

    public Dashboard() {
        super("dashboard", "Dashboard", "Application status dashboard", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Map<String, Object> attributes = this.getDashboardAttributes(app);
        if (context.query().getInt("mode") == 1) {
            return GeminiHelper.sendJson(context, "attr", attributes);
        }
        context.delivery().put("attributes", JSW.write(attributes));
        return bah.mustache(this.getTemplateName());
    }

    public AdminResponse handle(GeminiApplication app, AdminRequest request) {
        AdminResponse response = new AdminResponse();
        response.deliveries = this.getDashboardAttributes(app);
        return response;
    }

    protected Map<String, Object> getDashboardAttributes(GeminiApplication app) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(50);
        attributes.put("appname", app.getVersion().getVerboseDescription());
        attributes.put("reqnum", app.getRequestNumber());
        attributes.put("deployment", app.getVersion().getDeploymentDescription());
        attributes.put("freememmb", Runtime.getRuntime().freeMemory() / 0x100000L);
        attributes.put("totalmemmb", Runtime.getRuntime().totalMemory() / 0x100000L);
        long uptime = app.getUptime();
        attributes.put("uptimems", uptime);
        attributes.put("uptime", DateHelper.getHumanDuration(uptime, 2));
        GeminiMonitor monitor = app.getMonitor();
        if (monitor != null && monitor.isEnabled()) {
            attributes.put("reqs", monitor.getCurrentRequestCount());
            attributes.put("disps", monitor.getDispatchLoad());
            attributes.put("pages", monitor.getPageRenderLoad());
            attributes.put("queries", monitor.getQueryLoad());
        }
        Thread[] threads = ThreadHelper.getActiveThreads(false);
        attributes.put("threads", threads.length);
        ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
        if (tmxb.isThreadCpuTimeEnabled()) {
            int threadsOverTenSeconds = 0;
            int requestsOverFiveSeconds = 0;
            int i = 0;
            while (i < threads.length) {
                if (threads[i] != null) {
                    long reqms;
                    MonitorSample sample;
                    long cpums = tmxb.getThreadCpuTime(threads[i].getId()) / 1000000L;
                    if (cpums > 10000L) {
                        ++threadsOverTenSeconds;
                    }
                    if (monitor != null && monitor.isEnabled() && (sample = monitor.getRequest(threads[i].getId())) != null && (reqms = (long)sample.getTotalCpuTimeInProgress()) > 5000L) {
                        ++requestsOverFiveSeconds;
                    }
                }
                ++i;
            }
            attributes.put("t10s", threadsOverTenSeconds);
            attributes.put("r5s", requestsOverFiveSeconds);
        }
        attributes.put("vm", System.getProperty("java.vm.name", "Unknown"));
        attributes.put("vmvers", System.getProperty("java.vm.version", "?"));
        if (app.getServletConfig() != null) {
            attributes.put("sc", app.getServletConfig().getServerInfo());
        }
        this.getCustomDashboard(app, attributes);
        return attributes;
    }

    protected void getCustomDashboard(GeminiApplication app, Map<String, Object> attributes) {
    }
}

