/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.form.FormSelect;
import com.techempower.log.ComponentLog;
import com.techempower.log.Log;
import com.techempower.log.LogLevel;
import com.techempower.log.LogListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LogList
extends BasicAdminFunction {
    public LogList() {
        super("logs", "Logs", "List and manage log listeners", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Log appLog = log.getApplicationLog();
        ArrayList listeners = new ArrayList();
        List<LogListener> logListeners = appLog.getLogListeners();
        int tix = context.query().getInt("ix", 0);
        int ix = 0;
        for (LogListener listener : logListeners) {
            FormSelect menu = new FormSelect("ix" + ++ix, null);
            menu.setDisplayName("" + listener.getDebugThreshold());
            menu.addOptionsFromArray(LogLevel.DENSE_LEVEL_VALUES, LogLevel.DENSE_LEVEL_NAMES);
            menu.addClassName("ix");
            HashMap<String, Object> aListener = new HashMap<String, Object>(2);
            aListener.put("name", listener.getName());
            aListener.put("menu", menu);
            listeners.add(aListener);
        }
        int indexToConfigure = context.query().getInt("ix");
        int newLevel = context.query().getInt("level");
        if (indexToConfigure > 0 && newLevel >= 0 && newLevel <= 100) {
            if (indexToConfigure >= 0 && indexToConfigure < logListeners.size()) {
                LogListener listener = logListeners.get(indexToConfigure);
                listener.setDebugThreshold(newLevel);
                log.log("Threshold for " + listener.getName() + " set to " + newLevel + ".");
            }
            return GeminiHelper.sendJson(context, "result", "success");
        }
        context.delivery().putObject("ix", tix);
        context.delivery().putObject("logListeners", listeners);
        return bah.mustache(this.getTemplateName());
    }
}

