/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitorInterval;
import com.techempower.gemini.monitor.MonitoredCommand;
import com.techempower.log.ComponentLog;
import java.util.HashMap;

public class MonitorSignatures
extends BasicAdminFunction {
    public static final int DEFAULT_MAP_SIZE = 6;

    public MonitorSignatures() {
        super("monitor-sigs", "Signatures", "Monitor request signatures", "monitor", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        GeminiMonitor monitor = app.getMonitor();
        if (monitor != null) {
            int interval = context.query().getInt("interval");
            MonitoredCommand mc = monitor.getMonitoredCommand(context.query().get("command"));
            if (mc != null) {
                MonitorInterval[] history = mc.getHistory();
                if (interval >= 0 && interval < history.length) {
                    HashMap<String, String> sigs = new HashMap<String, String>(6);
                    MonitorInterval hist = history[interval];
                    if (hist != null) {
                        if (hist.getMostQueries() != null) {
                            sigs.put("qc", hist.getMostQueries().getRequestSignature());
                        }
                        if (hist.getMostLogicTime() != null) {
                            sigs.put("lt", hist.getMostLogicTime().getRequestSignature());
                        }
                        if (hist.getMostRenderTime() != null) {
                            sigs.put("rt", hist.getMostRenderTime().getRequestSignature());
                        }
                        if (hist.getMostQueryExceptions() != null) {
                            sigs.put("qe", hist.getMostQueryExceptions().getRequestSignature());
                        }
                        if (hist.getMostQueryTime() != null) {
                            sigs.put("qt", hist.getMostQueryTime().getRequestSignature());
                        }
                        if (hist.getMostSpecialTime() != null) {
                            sigs.put("st", hist.getMostSpecialTime().getRequestSignature());
                        }
                    }
                    return GeminiHelper.sendJson(context, "sigs", sigs);
                }
            }
        }
        return true;
    }
}

