/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.gemini.admin.notification.Notifier;
import com.techempower.js.JavaScriptWriter;
import com.techempower.js.Visitors;
import com.techempower.log.ComponentLog;

public class NotificationView
extends BasicAdminFunction {
    private static JavaScriptWriter jsw = JavaScriptWriter.custom().addVisitorFactory(Notification.class, Visitors.forClass(Notification.class, "source", "getSource", "synopsis", "getSynopsis", "details", "getDetails", "time", "getTime", "severity", "getSeverity")).build();

    public NotificationView() {
        super("notifications", "Notifications", "List administrative notifications / alerts", "monitor");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Notifier notifier = app.getNotifier();
        if (notifier != null) {
            context.delivery().put("notifications", jsw.write(notifier.getHistory()));
            return bah.mustache(this.getTemplateName());
        }
        return NotificationView.handleNoNotifier(bah, context);
    }

    protected static boolean handleNoNotifier(BasicAdminHandler<?> bah, Context context) {
        return bah.handleInformation(context, 5, "No Notifier is available within this application.");
    }
}

